/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen;

import com.google.common.collect.BiMap;
import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.features.player.badges.BssClientPlayerBadge_Badgeless;
import io.github.thecsdev.betterstats.api.client.features.player.badges.BssClientPlayerBadges;
import io.github.thecsdev.betterstats.client.gui.other.BSTooltipElement;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_Downloading;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_Statistics;
import io.github.thecsdev.betterstats.client.gui.panel.network.BSNetworkProfilePanel;
import io.github.thecsdev.betterstats.client.network.BStatsListener;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientNetworkHandler;
import io.github.thecsdev.betterstats.network.BSNetworkProfile;
import io.github.thecsdev.betterstats.network.BetterStatsNetworkHandler;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTooltipElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.client.network.PlayerBadgeNetworkListener;
import io.github.thecsdev.tcdcommons.api.features.player.badges.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.util.GenericProperties;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsScreen
extends TScreenPlus
implements BStatsListener,
PlayerBadgeNetworkListener {
    public static final class_2960 BSS_WIDGETS_TEXTURE = new class_2960(BetterStats.getModID(), "textures/gui/widgets.png");
    protected boolean STATUS_RECIEVED = false;
    protected int STATUS_TIMEOUT = 0;
    public final class_437 parent;
    public final GameProfile targetProfile;
    @Nullable
    protected BSNetworkProfile bStatHandler;
    protected BSPanel_Downloading panel_download;
    protected BSPanel_Statistics panel_stats;
    public CurrentTab filter_currentTab;
    public String filter_searchTerm;
    public double filter_statsScroll;
    public static boolean filter_showEmpty = false;
    public GroupStatsBy filter_groupBy;
    public final GenericProperties cache = new GenericProperties();
    public final boolean PLAYER_BADGES_ENABLED;

    public BetterStatsScreen(class_437 parent) {
        this(parent, null);
    }

    public BetterStatsScreen(class_437 parent, GameProfile gameProfile) {
        super((class_2561)TextUtils.translatable((String)"gui.stats", (Object[])new Object[0]));
        BSNetworkProfile cachedStatHandler;
        this.field_22787 = class_310.method_1551();
        this.parent = parent;
        this.PLAYER_BADGES_ENABLED = TCDCommons.getInstance().getConfig().enablePlayerBadges;
        if (gameProfile == null) {
            gameProfile = this.field_22787.field_1724.method_7334();
        }
        if ((cachedStatHandler = BetterStatsClientNetworkHandler.getCachedProfile(gameProfile)) == null) {
            cachedStatHandler = BSNetworkProfile.compareGameProfiles(gameProfile, this.field_22787.field_1724.method_7334()) ? BSNetworkProfile.ofLocalClient() : BSNetworkProfile.ofGameProfile(gameProfile);
        }
        this.bStatHandler = cachedStatHandler;
        this.targetProfile = gameProfile;
        this.filter_currentTab = CurrentTab.General;
        this.filter_searchTerm = "";
        this.filter_statsScroll = 0.0;
        this.filter_groupBy = GroupStatsBy.Default;
    }

    protected TTooltipElement __createTooltip() {
        return new BSTooltipElement(this.getTpeWidth() / 2);
    }

    public void onOpened() {
        if (!this.STATUS_RECIEVED) {
            this.sendStatsRequest();
        }
    }

    public boolean shouldRenderInGameHud() {
        return false;
    }

    public void method_25393() {
        if (this.STATUS_RECIEVED || this.STATUS_TIMEOUT > 60) {
            return;
        }
        if (this.STATUS_TIMEOUT < 60) {
            ++this.STATUS_TIMEOUT;
        } else if (this.STATUS_TIMEOUT == 60) {
            this.panel_download.onTimedOut();
            ++this.STATUS_TIMEOUT;
        }
    }

    public void sendStatsRequest() {
        this.STATUS_RECIEVED = false;
        this.STATUS_TIMEOUT = 0;
        this.panel_download.onSendRequest();
        this.panel_download.setVisible(true);
        if (!this.sendStatsRequestPacket()) {
            this.panel_download.onTimedOut();
        }
    }

    public boolean sendStatsRequestPacket() {
        class_310 client = this.getClient();
        class_746 localPlayer = client.field_1724;
        if (localPlayer == null) {
            return false;
        }
        GameProfile targetGameProfile = this.getListenerTargetGameProfile();
        if (!BSNetworkProfile.compareGameProfiles(targetGameProfile, localPlayer.method_7334())) {
            if (!BetterStatsClientNetworkHandler.serverHasBSS || !BetterStatsClientNetworkHandler.enableBSSProtocol) {
                return false;
            }
            class_2540 data = new class_2540(Unpooled.buffer());
            BSNetworkProfile.writeGameProfile(data, targetGameProfile);
            class_2817 packet = new class_2817(BetterStatsNetworkHandler.C2S_REQ_STATS, data);
            client.method_1562().method_2883((class_2596)packet);
            BetterStats.LOGGER.debug("Client requesting stats from server using CustomPayloadC2SPacket.");
            return true;
        }
        class_2799 packet = new class_2799(class_2799.class_2800.field_12775);
        client.method_1562().method_2883((class_2596)packet);
        BetterStats.LOGGER.debug("Client requesting stats from server using ClientStatusC2SPacket.");
        return true;
    }

    public class_3469 getStatHandler() {
        return this.bStatHandler.stats;
    }

    @Nullable
    public BSNetworkProfile getBSStatHandler() {
        return this.bStatHandler;
    }

    @Nullable
    public BSPanel_Statistics getStatPanel() {
        return this.panel_stats;
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return this.getStatPredicate_emptyFilter().and(this.getStatPredicate_searchFilter());
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate_emptyFilter() {
        return stat -> filter_showEmpty || !stat.isEmpty();
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate_searchFilter() {
        return stat -> {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.filter_searchTerm})) {
                return true;
            }
            String lbl = stat.label.getString().toLowerCase().replaceAll("\\s+", "");
            String st = this.filter_searchTerm.toLowerCase().replaceAll("\\s+", "");
            return lbl.contains(st);
        };
    }

    protected void method_25426() {
        this.panel_download = new BSPanel_Downloading(this);
        this.panel_stats = new BSPanel_Statistics(this);
        this.addTChild((TElement)this.panel_download);
        this.addTChild((TElement)this.panel_stats);
        if (this.STATUS_RECIEVED) {
            this.onBetterStatsReady(this.bStatHandler);
        }
    }

    @Override
    public GameProfile getListenerTargetGameProfile() {
        return this.bStatHandler.gameProfile;
    }

    @Override
    public void onBetterStatsReady(BSNetworkProfile recievedProfile) {
        BssClientPlayerBadge_Badgeless.instance.tick();
        this.STATUS_RECIEVED = true;
        this.bStatHandler = Objects.requireNonNull(recievedProfile);
        BetterStats.LOGGER.debug("Client received stats from server for: " + recievedProfile);
        if (this.PLAYER_BADGES_ENABLED) {
            int playTime = this.bStatHandler.stats.method_15024(class_3468.field_15419, (Object)class_3468.field_15417);
            if (playTime > 20736000) {
                this.bStatHandler.playerBadgeIds.add(BssClientPlayerBadges.DEDICATION.getBadgeId());
            }
            if (playTime > 41472000) {
                this.bStatHandler.playerBadgeIds.add(BssClientPlayerBadges.LOYALTY.getBadgeId());
            }
            if (!new StatUtils.StatUtilsItemStat(this.getStatHandler(), class_1802.field_8840).isEmpty()) {
                this.bStatHandler.playerBadgeIds.add(BssClientPlayerBadges.THE_NEXT_GEN.getBadgeId());
            }
        }
        this.panel_download.setVisible(false);
        this.panel_stats.setVisible(true);
        this.panel_stats.clearTChildren();
        if (this.getStatHandler() != null) {
            this.panel_stats.init();
        }
    }

    @Override
    public void onStatsPlayerNotFound() {
        if (this.panel_download != null) {
            this.panel_download.onPlayer404();
        }
        this.STATUS_TIMEOUT = 256;
    }

    public void onPlayerBadgesReady(BiMap<class_2960, PlayerBadge> badges) {
        this.bStatHandler.playerBadgeIds.addAll(badges.keySet());
        this.reInit_BSNetworkProfilePanel();
    }

    public boolean reInit_BSNetworkProfilePanel() {
        if (!this.STATUS_RECIEVED) {
            return false;
        }
        BSNetworkProfilePanel npp = (BSNetworkProfilePanel)this.findTChildOfType(BSNetworkProfilePanel.class, true);
        if (npp == null) {
            return false;
        }
        npp.init(this);
        return true;
    }

    public void method_25420(class_4587 matrices) {
    }

    public static enum CurrentTab {
        General(TextUtils.translatable((String)"stat.generalButton", (Object[])new Object[0])),
        Items(TextUtils.translatable((String)"stat.itemsButton", (Object[])new Object[0])),
        Entities(TextUtils.translatable((String)"stat.mobsButton", (Object[])new Object[0])),
        FoodStuffs(TextUtils.translatable((String)"advancements.husbandry.balanced_diet.title", (Object[])new Object[0])),
        MonstersHunted(TextUtils.translatable((String)"advancements.adventure.kill_all_mobs.title", (Object[])new Object[0]));

        private final class_5250 text;

        private CurrentTab(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }

    public static enum GroupStatsBy {
        Default(TextUtils.translatable((String)"betterstats.gui.filters.group_by.default", (Object[])new Object[0])),
        Mod(TextUtils.translatable((String)"betterstats.gui.filters.group_by.mod", (Object[])new Object[0])),
        None(TextUtils.translatable((String)"betterstats.gui.filters.group_by.none", (Object[])new Object[0]));

        private final class_5250 text;

        private GroupStatsBy(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }
}

