/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.registry.BetterStatsRegistry;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.client.gui_hud.screen.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget_Entity;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectEnumWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3469;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class BSStatPanel_Mobs
extends BSStatPanel {
    protected final boolean guiMobsFollowCursor;

    public BSStatPanel_Mobs(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.guiMobsFollowCursor = BetterStats.getInstance().getConfig().guiMobsFollowCursor;
    }

    public BSStatPanel_Mobs(TPanelElement parentToFill) {
        super(parentToFill);
        this.guiMobsFollowCursor = BetterStats.getInstance().getConfig().guiMobsFollowCursor;
    }

    @Override
    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return stat -> {
            if (!(stat instanceof StatUtils.StatUtilsMobStat)) {
                return false;
            }
            class_1297 ent = TEntityRendererElement.getCachedEntityFromType(((StatUtils.StatUtilsMobStat)stat).entityType);
            return ent instanceof class_1309 || !stat.isEmpty();
        };
    }

    @Override
    public TSelectWidget createFilterSortByWidget(BetterStatsScreen bss, int x, int y, int width, int height) {
        TSelectEnumWidget sw = new TSelectEnumWidget(x, y, width, height, BSStatPanelMobs_SortBy.class);
        sw.setSelected((Enum)bss.cache.getAs("BSStatPanelMobs_SortBy", BSStatPanelMobs_SortBy.class, (Object)BSStatPanelMobs_SortBy.Default), false);
        sw.setEnumValueToLabel(newVal -> ((BSStatPanelMobs_SortBy)((Object)newVal)).asText());
        sw.setOnSelectionChange(newVal -> {
            bss.cache.set("BSStatPanelMobs_SortBy", newVal);
            bss.getStatPanel().init_stats();
        });
        return sw;
    }

    @Override
    public void init(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        switch (this.getFilterGroupBy()) {
            case None: {
                this.initByNoGroups(bss, statHandler, statFilter);
                break;
            }
            default: {
                this.initByModGroups(bss, statHandler, statFilter);
            }
        }
    }

    protected void initByNoGroups(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<String, ArrayList<StatUtils.StatUtilsMobStat>> mobStats = StatUtils.getMobStats(statHandler, statFilter.and(this.getStatPredicate()));
        ArrayList allMobs = Lists.newArrayList();
        for (String mobGroup : mobStats.keySet()) {
            allMobs.addAll((Collection)mobStats.get(mobGroup));
        }
        if (mobStats.size() > 0) {
            this.init_groupLabel((class_2561)TextUtils.literal((String)"*"));
            this.init_mobStats(bss, allMobs);
            this.init_totalStats(mobStats.values());
        } else {
            this.init_noResults();
        }
    }

    protected void initByModGroups(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<String, ArrayList<StatUtils.StatUtilsMobStat>> mobStats = StatUtils.getMobStats(statHandler, statFilter.and(this.getStatPredicate()));
        for (String mobGroup : mobStats.keySet()) {
            this.init_groupLabel((class_2561)TextUtils.literal((String)StatUtils.getModName(mobGroup)));
            this.init_mobStats(bss, mobStats.get(mobGroup));
        }
        if (mobStats.size() == 0) {
            this.init_noResults();
        } else {
            this.init_totalStats(mobStats.values());
        }
    }

    protected void init_mobStats(BetterStatsScreen bss, ArrayList<StatUtils.StatUtilsMobStat> mobStats) {
        switch ((BSStatPanelMobs_SortBy)((Object)bss.cache.getAs("BSStatPanelMobs_SortBy", BSStatPanelMobs_SortBy.class, (Object)BSStatPanelMobs_SortBy.Default))) {
            case Kills: {
                Collections.sort(mobStats, (o1, o2) -> Integer.compare(o2.killed, o1.killed));
                break;
            }
            case Deaths: {
                Collections.sort(mobStats, (o1, o2) -> Integer.compare(o2.killedBy, o1.killedBy));
                break;
            }
        }
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        int SIZE = 50;
        for (StatUtils.StatUtilsMobStat stat : mobStats) {
            this.addTChild(this.createStatWidget(stat, nextX, nextY, 50), false);
            if ((nextX += 52) + 50 <= this.getTpeEndX() - this.getScrollPadding()) continue;
            nextX = this.getTpeX() + this.getScrollPadding();
            nextY += 52;
        }
    }

    protected void init_totalStats(Collection<ArrayList<StatUtils.StatUtilsMobStat>> mobStats) {
        int kills = 0;
        int deaths = 0;
        for (ArrayList<StatUtils.StatUtilsMobStat> group : mobStats) {
            for (StatUtils.StatUtilsMobStat groupItem : group) {
                if (groupItem == null || groupItem.isEmpty()) continue;
                kills += groupItem.killed;
                deaths += groupItem.killedBy;
            }
        }
        StringBuilder glSb = new StringBuilder();
        glSb.append(new char[]{'\u2190', ' ', '\u2022', ' ', '\u2192'});
        TLabelElement groupLabel = this.init_groupLabel((class_2561)TextUtils.literal((String)glSb.toString()));
        groupLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        BSPanel panel = new BSPanel(nextX, nextY, this.getTpeWidth() - this.getScrollPadding() * 2, 20);
        panel.setScrollPadding(0);
        this.addTChild((TElement)panel, false);
        int leftX = 5;
        int leftW = panel.getTpeWidth() / 2 - 10;
        int rightX = panel.getTpeWidth() / 2 + 5;
        int rightW = panel.getTpeWidth() / 2 - 10;
        TLabelElement lbl_kills_a = new TLabelElement(leftX, 0, leftW, 20, (class_2561)TextUtils.translatable((String)"betterstats.hud.entity.kills", (Object[])new Object[0]));
        TLabelElement lbl_kills_b = new TLabelElement(leftX, 0, leftW, 20, (class_2561)TextUtils.literal((String)Integer.toString(kills)));
        lbl_kills_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        TLabelElement lbl_deaths_a = new TLabelElement(rightX, 0, rightW, 20, (class_2561)TextUtils.translatable((String)"betterstats.hud.entity.deaths", (Object[])new Object[0]));
        TLabelElement lbl_deaths_b = new TLabelElement(rightX, 0, rightW, 20, (class_2561)TextUtils.literal((String)Integer.toString(deaths)));
        lbl_deaths_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_kills_a, true);
        panel.addTChild((TElement)lbl_kills_b, true);
        panel.addTChild((TElement)lbl_deaths_a, true);
        panel.addTChild((TElement)lbl_deaths_b, true);
    }

    protected BSStatWidget_Mob createStatWidget(StatUtils.StatUtilsMobStat stat, int x, int y, int size) {
        return new BSStatWidget_Mob(stat, x, y, size);
    }

    public static enum BSStatPanelMobs_SortBy {
        Default(TextUtils.literal((String)"-")),
        Kills(TextUtils.translatable((String)"betterstats.hud.entity.kills", (Object[])new Object[0])),
        Deaths(TextUtils.translatable((String)"betterstats.hud.entity.deaths", (Object[])new Object[0]));

        private final class_5250 text;

        private BSStatPanelMobs_SortBy(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }

    protected class BSStatWidget_Mob
    extends BSStatPanel.BSStatWidget {
        public final StatUtils.StatUtilsMobStat stat;
        public final TEntityRendererElement entityRenderer;

        public BSStatWidget_Mob(StatUtils.StatUtilsMobStat stat, int x, int y, int size) {
            super(BSStatPanel_Mobs.this, x, y, size, size);
            this.stat = Objects.requireNonNull(stat, "stat must not be null.");
            this.entityRenderer = new TEntityRendererElement(x, y, size, size, stat.entityType);
            this.addTChild((TElement)this.entityRenderer, false);
            this.entityRenderer.setFollowCursor(BSStatPanel_Mobs.this.guiMobsFollowCursor);
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            String entityName = this.stat.label.getString();
            String s0 = TextUtils.translatable((String)"stat_type.minecraft.killed.none", (Object[])new Object[]{entityName}).getString();
            String s1 = TextUtils.translatable((String)"stat_type.minecraft.killed_by.none", (Object[])new Object[]{entityName}).getString();
            if (this.stat.killed != 0) {
                s0 = TextUtils.translatable((String)"stat_type.minecraft.killed", (Object[])new Object[]{Integer.toString(this.stat.killed), entityName}).getString();
            }
            if (this.stat.killedBy != 0) {
                s1 = TextUtils.translatable((String)"stat_type.minecraft.killed_by", (Object[])new Object[]{entityName, Integer.toString(this.stat.killedBy)}).getString();
            }
            this.setTooltip((class_2561)TextUtils.literal((String)(s0 + "\n" + s1)));
        }

        @Override
        public boolean mousePressed(int mouseX, int mouseY, int button) {
            String url;
            if (button == 2 && (url = BetterStatsRegistry.getMobWikiURL(class_2378.field_11145.method_10221(this.stat.entityType))) != null) {
                GuiUtils.showUrlPrompt((String)url, (boolean)false);
                return false;
            }
            return super.mousePressed(mouseX, mouseY, button);
        }

        protected void onContextMenu(TContextMenuPanel contextMenu) {
            super.onContextMenu(contextMenu);
            contextMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.gui.ctx_menu.pin_to_hud", (Object[])new Object[0]), btn -> {
                BetterStatsHudScreen bshs = BetterStatsHudScreen.getOrCreateInstance((class_437)this.screen);
                this.getClient().method_1507((class_437)bshs);
                bshs.addHudStatWidget(new BSHudStatWidget_Entity(0, 0, this.stat.statHandler, this.stat.entityType));
            });
            contextMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.gui.ctx_menu.close", (Object[])new Object[0]), btn -> {});
        }
    }
}

