/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.network.BetterStatsNetworkHandler;
import io.github.thecsdev.betterstats.server.BetterStatsServer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterStats {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)BetterStats.getModID());
    private static final String ModID = "betterstats";
    private static BetterStats Instance;
    public final ModContainer modInfo;
    public final String contact_sources;
    public final String contact_playerBadgeWebhook;
    protected final BetterStatsConfig config;

    public BetterStats() {
        if (BetterStats.isModInitialized()) {
            throw new IllegalStateException(BetterStats.getModID() + " has already been initialized.");
        }
        if (!BetterStats.isInstanceValid(this)) {
            throw new UnsupportedOperationException("Invalid " + BetterStats.getModID() + " type: " + this.getClass().getName());
        }
        Instance = this;
        this.modInfo = (ModContainer)FabricLoader.getInstance().getModContainer(BetterStats.getModID()).get();
        ContactInformation contact = this.modInfo.getMetadata().getContact();
        this.contact_sources = (String)contact.get("sources").get();
        this.contact_playerBadgeWebhook = (String)contact.get("player_badge_webhook").get();
        LOGGER.info("Initializing '" + BetterStats.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
        this.config = new BetterStatsConfig(BetterStats.getModID());
        this.config.tryLoadFromFile(true);
        BetterStatsNetworkHandler.init();
    }

    public ModContainer getModInfo() {
        return this.modInfo;
    }

    public BetterStatsConfig getConfig() {
        return this.config;
    }

    public static BetterStats getInstance() {
        return Instance;
    }

    public static String getModName() {
        return BetterStats.getInstance().getModInfo().getMetadata().getName();
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return BetterStats.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(BetterStats instance) {
        return BetterStats.isServer(instance) || BetterStats.isClient(instance);
    }

    public static boolean isServer() {
        return BetterStats.isServer(Instance);
    }

    public static boolean isClient() {
        return BetterStats.isClient(Instance);
    }

    private static boolean isServer(BetterStats arg0) {
        return arg0 instanceof BetterStatsServer;
    }

    private static boolean isClient(BetterStats arg0) {
        return arg0 instanceof BetterStatsClient;
    }
}

