/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SlotManager {
    protected final ITravelersBackpackInventory inventory;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected List<Pair<Integer, class_1799>> memorySlots = new ArrayList<Pair<Integer, class_1799>>();
    protected boolean isUnsortableActive = false;
    protected boolean isMemoryActive = false;
    private final String UNSORTABLE_SLOTS = "UnsortableSlots";
    private final String MEMORY_SLOTS = "MemorySlots";
    public static final byte UNSORTABLE = 0;
    public static final byte MEMORY = 1;

    public SlotManager(ITravelersBackpackInventory inventory) {
        this.inventory = inventory;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public List<Pair<Integer, class_1799>> getMemorySlots() {
        return this.memorySlots;
    }

    public boolean isSlot(byte type, int slot) {
        if (type == 0) {
            return this.unsortableSlots.contains(slot);
        }
        if (type == 1) {
            for (Pair<Integer, class_1799> pair : this.memorySlots) {
                if ((Integer)pair.getFirst() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnsortableSlots(int[] slots, boolean isFinal) {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = Arrays.stream(slots).boxed().collect(Collectors.toList());
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isSelectorActive((byte)0) && slot <= this.inventory.getTier().getStorageSlots() - 7) {
            if (this.isSlot((byte)0, slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void setMemorySlots(int[] slots, class_1799[] stacks, boolean isFinal) {
        if (this.isSelectorActive((byte)1)) {
            ArrayList<Pair<Integer, class_1799>> pairs = new ArrayList<Pair<Integer, class_1799>>();
            for (int i = 0; i < slots.length; ++i) {
                pairs.add((Pair<Integer, class_1799>)Pair.of((Object)slots[i], (Object)stacks[i]));
            }
            pairs.sort(Comparator.comparing(pair -> ((Integer)pair.getFirst()).toString()));
            this.memorySlots = pairs;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlot(int slot, class_1799 stack) {
        if (this.isSelectorActive((byte)1) && slot <= this.inventory.getTier().getStorageSlots() - 7) {
            if (this.isSlot((byte)1, slot)) {
                this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot);
            } else {
                this.memorySlots.add((Pair<Integer, class_1799>)Pair.of((Object)slot, (Object)stack));
            }
        }
    }

    public void clearUnsortables() {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = new ArrayList<Integer>();
        }
    }

    public void clearMemory() {
        if (this.isSelectorActive((byte)1)) {
            this.memorySlots = new ArrayList<Pair<Integer, class_1799>>();
        }
    }

    public void setChanged() {
        if (this.inventory.getScreenID() != 3) {
            this.inventory.markDataDirty(8);
        } else {
            this.inventory.method_5431();
        }
    }

    public boolean isSelectorActive(byte type) {
        return switch (type) {
            case 0 -> this.isUnsortableActive;
            case 1 -> this.isMemoryActive;
            default -> false;
        };
    }

    public void setSelectorActive(byte type, boolean bool) {
        switch (type) {
            case 0: {
                this.isUnsortableActive = bool;
                break;
            }
            case 1: {
                this.isMemoryActive = bool;
            }
        }
    }

    public void writeUnsortableSlots(class_2487 compound) {
        compound.method_10539("UnsortableSlots", this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void readUnsortableSlots(class_2487 compound) {
        this.unsortableSlots = Arrays.stream(compound.method_10561("UnsortableSlots")).boxed().collect(Collectors.toList());
    }

    public void writeMemorySlots(class_2487 compound) {
        class_2499 memorySlotsList = new class_2499();
        for (Pair<Integer, class_1799> pair : this.memorySlots) {
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", ((Integer)pair.getFirst()).intValue());
            ((class_1799)pair.getSecond()).method_7953(itemTag);
            memorySlotsList.add((Object)itemTag);
        }
        compound.method_10566("MemorySlots", (class_2520)memorySlotsList);
    }

    public void readMemorySlots(class_2487 compound) {
        class_2499 tagList = compound.method_10554("MemorySlots", 10);
        ArrayList<Pair<Integer, class_1799>> pairs = new ArrayList<Pair<Integer, class_1799>>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTag = tagList.method_10602(i);
            int slot = itemTag.method_10550("Slot");
            if (slot > this.inventory.getTier().getStorageSlots() - 7) continue;
            Pair pair = Pair.of((Object)slot, (Object)class_1799.method_7915((class_2487)itemTag));
            pairs.add((Pair<Integer, class_1799>)pair);
        }
        this.memorySlots = pairs;
    }
}

