/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.screen;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.FluidSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.ToolSlot;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBaseScreenHandler
extends class_1703 {
    public class_1661 playerInventory;
    public ITravelersBackpackInventory inventory;
    public CraftingInventoryImproved craftMatrix;
    public class_1731 craftResult = new class_1731();
    private final int CRAFTING_GRID_START = 1;
    private final int CRAFTING_GRID_END = 9;
    private final int BACKPACK_INV_START = 10;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;

    protected TravelersBackpackBaseScreenHandler(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, ITravelersBackpackInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this);
        int currentItemIndex = playerInventory.field_7545;
        this.BACKPACK_INV_END = 10 + inventory.getTier().getStorageSlots() - 7;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.TOOL_END + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_LEFT_IN + 1;
        this.PLAYER_INV_START = this.BUCKET_RIGHT_OUT + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addCraftMatrix();
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInventory, currentItemIndex);
        this.method_7609(inventory.getCraftingGridInventory());
    }

    public void addCraftMatrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new BackpackSlot((class_1263)this.craftMatrix, j + i * 3, 152 + j * 18, 7 + this.inventory.getTier().getMenuSlotPlacementFactor() + i * 18));
            }
        }
    }

    public void addCraftResult() {
        this.method_7621((class_1735)new class_1734(this.playerInventory.field_7546, this.craftMatrix, (class_1263)this.craftResult, 0, 226, 43 + this.inventory.getTier().getMenuSlotPlacementFactor()){

            public boolean method_7682() {
                if (TravelersBackpackBaseScreenHandler.this.inventory.getTier().getOrdinal() <= 0) {
                    return TravelersBackpackBaseScreenHandler.this.inventory.getInventory().method_5438(TravelersBackpackBaseScreenHandler.this.inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT)).method_7960() && TravelersBackpackBaseScreenHandler.this.inventory.getInventory().method_5438(TravelersBackpackBaseScreenHandler.this.inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT)).method_7960();
                }
                return true;
            }
        });
    }

    public void addBackpackInventory(ITravelersBackpackInventory inventory) {
        int j;
        int i;
        int slot = 0;
        if (this.inventory.getTier().getOrdinal() > Tiers.LEATHER.getOrdinal()) {
            for (i = 0; i < this.inventory.getTier().getOrdinal(); ++i) {
                for (j = 0; j < (this.inventory.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal() ? 9 : 8); ++j) {
                    this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, (this.inventory.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal() ? 44 : 62) + j * 18, 7 + i * 18));
                }
            }
        }
        if (this.inventory.getTier().getOrdinal() == Tiers.NETHERITE.getOrdinal()) {
            this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, 44, 79));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, 62 + j * 18, 7 + this.inventory.getTier().getMenuSlotPlacementFactor() + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInv, x + y * 9 + 9, 44 + x * 18, 71 + this.inventory.getTier().getMenuSlotPlacementFactor() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInv, x, 44 + x * 18, 129 + this.inventory.getTier().getMenuSlotPlacementFactor()));
        }
    }

    public void addFluidSlots(ITravelersBackpackInventory inventory) {
        this.method_7621(new FluidSlot(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), 6, 7));
        this.method_7621(new FluidSlot(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_LEFT), 6, 37));
        this.method_7621(new FluidSlot(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), 226, 7));
        this.method_7621(new FluidSlot(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT), 226, 37));
    }

    public void addToolSlots(ITravelersBackpackInventory inventory) {
        this.method_7621(new ToolSlot(this.playerInventory.field_7546, inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.TOOL_UPPER), 44, 25 + inventory.getTier().getMenuSlotPlacementFactor()));
        this.method_7621(new ToolSlot(this.playerInventory.field_7546, inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.TOOL_LOWER), 44, 43 + inventory.getTier().getMenuSlotPlacementFactor()));
    }

    protected static void slotChangedCraftingGrid(class_1703 handler, class_1937 world, class_1657 player, class_1715 craftMatrix, class_1731 craftResult) {
        if (!world.field_9236) {
            class_3955 craftingRecipe;
            class_3222 serverPlayerEntity = (class_3222)player;
            class_1799 itemStack = class_1799.field_8037;
            Optional optional = world.method_8503().method_3772().method_8132(class_3956.field_17545, (class_1263)craftMatrix, world);
            if (optional.isPresent() && craftResult.method_7665(world, serverPlayerEntity, (class_1860)(craftingRecipe = (class_3955)optional.get()))) {
                itemStack = craftingRecipe.method_8116((class_1263)craftMatrix);
            }
            craftResult.method_5447(0, itemStack);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37421(), 0, itemStack));
        }
    }

    public void method_7609(class_1263 inventory) {
        TravelersBackpackBaseScreenHandler.slotChangedCraftingGrid(this, this.playerInventory.field_7546.field_6002, this.playerInventory.field_7546, this.craftMatrix, this.craftResult);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.craftResult && super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = this.method_7611(index);
        class_1799 result = class_1799.field_8037;
        if (slot != null && slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (index >= 0 && index <= this.BUCKET_RIGHT_OUT) {
                if (index == 0) {
                    stack.method_7909().method_7843(stack, player.field_6002, player);
                    if (!this.method_7616(stack, 10, this.PLAYER_HOT_END + 1, true)) {
                        return class_1799.field_8037;
                    }
                    slot.method_7670(stack, result);
                    this.craftMatrix.method_5431();
                } else if (!this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return class_1799.field_8037;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.inventory.getSlotManager().getMemorySlots().isEmpty()) {
                    for (Pair<Integer, class_1799> pair : this.inventory.getSlotManager().getMemorySlots()) {
                        if (!ItemStackUtils.canCombine((class_1799)pair.getSecond(), stack) || this.method_7611((Integer)pair.getFirst() + 10).method_7677().method_7947() == this.method_7611((Integer)pair.getFirst() + 10).method_7677().method_7914() || this.method_7616(stack, (Integer)pair.getFirst() + 10, (Integer)pair.getFirst() + 11, false)) continue;
                        return class_1799.field_8037;
                    }
                }
                if (ToolSlot.isValid(stack) && !this.method_7616(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.method_7616(stack, 10, this.BACKPACK_INV_END + 1, false) && !this.method_7616(stack, 1, 10, false)) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(stack, 10, this.BACKPACK_INV_END + 1, false) && !this.method_7616(stack, 1, 10, false)) {
                    return class_1799.field_8037;
                }
            }
            if (stack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stack);
        }
        return result;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        class_1799 itemStack;
        class_1735 slot;
        boolean bl = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && !(!fromLast ? i >= endIndex : i < startIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                itemStack = slot.method_7677();
                if (!itemStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) {
                    int j = itemStack.method_7947() + stack.method_7947();
                    if (j <= stack.method_7914()) {
                        stack.method_7939(0);
                        itemStack.method_7939(j);
                        slot.method_7668();
                        bl = true;
                    } else if (itemStack.method_7947() < stack.method_7914()) {
                        stack.method_7934(stack.method_7914() - itemStack.method_7947());
                        itemStack.method_7939(stack.method_7914());
                        slot.method_7668();
                        bl = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.method_7960()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (!(!fromLast ? i >= endIndex : i < startIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                itemStack = slot.method_7677();
                if (itemStack.method_7960() && slot.method_7680(stack) && this.canPutStackInSlot(stack, i)) {
                    if (stack.method_7947() > slot.method_7675()) {
                        slot.method_7673(stack.method_7971(slot.method_7675()));
                    } else {
                        slot.method_7673(stack.method_7971(stack.method_7947()));
                    }
                    slot.method_7668();
                    bl = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public boolean canPutStackInSlot(class_1799 stack, int slot) {
        if (this.inventory.getSlotManager().isSlot((byte)1, slot - 10)) {
            return this.inventory.getSlotManager().getMemorySlots().stream().anyMatch(pair -> (Integer)pair.getFirst() + 10 == slot && ItemStackUtils.canCombine((class_1799)pair.getSecond(), stack));
        }
        return true;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void method_7595(class_1657 playerIn) {
        class_1799 componentStack;
        super.method_7595(playerIn);
        if (this.inventory.getScreenID() != 3) {
            this.inventory.markDataDirty(9);
        }
        if (this.inventory.getScreenID() == 3) {
            if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
                this.inventory.getSlotManager().setChanged();
            }
            this.inventory.setUsingPlayer(null);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)0)) {
            this.inventory.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            this.inventory.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.playSound(playerIn, this.inventory);
        TravelersBackpackBaseScreenHandler.clearBucketSlots(playerIn, this.inventory);
        if (!playerIn.field_6002.field_9236 && TravelersBackpack.enableTrinkets() && ComponentUtils.isWearingBackpack(playerIn) && this.inventory.getScreenID() == 2 && (componentStack = ComponentUtils.getWearingBackpack(playerIn)).method_7969() != null && this.inventory.getItemStack().method_7969() != null && !class_1799.method_31577((class_1799)componentStack, (class_1799)this.inventory.getItemStack())) {
            ComponentUtils.getWearingBackpack(playerIn).method_7980(this.inventory.getItemStack().method_7969());
        }
    }

    public static void clearBucketSlots(class_1657 playerIn, ITravelersBackpackInventory inventoryIn) {
        if (inventoryIn.getScreenID() == 1 || inventoryIn.getScreenID() == 2) {
            IntStream.range(inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT) + 1).forEach(i -> TravelersBackpackBaseScreenHandler.clearBucketSlot(playerIn, inventoryIn, i));
        }
    }

    public static void clearBucketSlot(class_1657 playerIn, ITravelersBackpackInventory inventoryIn, int index) {
        if (!inventoryIn.getInventory().method_5438(index).method_7960()) {
            class_3222 serverPlayer;
            if (!playerIn.method_5805() || playerIn instanceof class_3222 && (serverPlayer = (class_3222)playerIn).method_14239()) {
                class_1799 stack = inventoryIn.getInventory().method_5438(index).method_7972();
                inventoryIn.getInventory().method_5447(index, class_1799.field_8037);
                playerIn.method_7328(stack, false);
            } else {
                class_1799 stack = inventoryIn.getInventory().method_5438(index);
                inventoryIn.getInventory().method_5447(index, class_1799.field_8037);
                playerIn.method_31548().method_7398(stack);
            }
        }
    }

    public void playSound(class_1657 playerIn, ITravelersBackpackInventory inventoryIn) {
        for (int i = inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT); i <= inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT); ++i) {
            if (inventoryIn.getInventory().method_5438(i).method_7960()) continue;
            playerIn.field_6002.method_8396(playerIn, playerIn.method_24515(), class_3417.field_15197, class_3419.field_15245, 1.0f, (1.0f + (playerIn.field_6002.field_9229.method_43057() - playerIn.field_6002.field_9229.method_43057()) * 0.2f) * 0.7f);
            break;
        }
    }
}

