/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.effects.LavaEffect;
import com.tiviacz.travelersbackpack.fluids.effects.MilkEffect;
import com.tiviacz.travelersbackpack.fluids.effects.PotionEffect;
import com.tiviacz.travelersbackpack.fluids.effects.WaterEffect;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3611;

public class EffectFluidRegistry {
    public static BiMap<String, EffectFluid> EFFECT_REGISTRY = HashBiMap.create();
    public static EffectFluid WATER_EFFECT;
    public static EffectFluid LAVA_EFFECT;
    public static EffectFluid POTION_EFFECT;
    public static EffectFluid MILK_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new WaterEffect();
        LAVA_EFFECT = new LavaEffect();
        POTION_EFFECT = new PotionEffect();
        MILK_EFFECT = new MilkEffect();
    }

    public static int registerFluidEffect(EffectFluid effect) {
        String className = effect.getClass().getName();
        if (!EFFECT_REGISTRY.containsKey((Object)className) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)className, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the class " + className + " as a FluidEffect for " + class_2378.field_11154.method_10221((Object)effect.fluid) + " " + effect.amountRequired + " with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static Map<String, EffectFluid> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static String[] getRegisteredFluids() {
        String[] result = new String[EFFECT_REGISTRY.size()];
        int counter = 0;
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            result[counter++] = class_2378.field_11154.method_10221((Object)effect.fluid).toString();
        }
        return result;
    }

    public static boolean hasFluidEffect(class_3611 fluid) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return true;
        }
        return false;
    }

    public static EffectFluid getFluidEffect(class_3611 fluid) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return effect;
        }
        return null;
    }

    public static ArrayList<EffectFluid> getEffectsForFluid(class_3611 fluid) {
        ArrayList<EffectFluid> effectsForFluid = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EFFECT_REGISTRY.values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean hasFluidEffectAndCanExecute(SingleVariantStorage<FluidVariant> storage, class_1937 world, class_1297 entity) {
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (((FluidVariant)storage.getResource()).getFluid() != effect.fluid || !effect.canExecuteEffect((StorageView<FluidVariant>)storage, world, entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean executeFluidEffectsForFluid(SingleVariantStorage<FluidVariant> storage, class_1297 entity, class_1937 world) {
        boolean executed = false;
        for (EffectFluid effect : EFFECT_REGISTRY.values()) {
            if (effect == null || effect.fluid != ((FluidVariant)storage.getResource()).getFluid()) continue;
            effect.affectDrinker((StorageView<FluidVariant>)storage, world, entity);
            executed = true;
        }
        return executed;
    }

    static {
        effectIDCounter = 0;
    }
}

