/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="travelersbackpack")
public class TravelersBackpackConfigData
implements ConfigData {
    @ConfigEntry.Category(value="BackpackSettings")
    BackpackSettings backpackSettings = new BackpackSettings();
    @ConfigEntry.Category(value="World")
    World world = new World();
    @ConfigEntry.Category(value="BackpackAbilities")
    BackpackAbilities backpackAbilities = new BackpackAbilities();
    @ConfigEntry.Category(value="SlownessDebuff")
    SlownessDebuff slownessDebuff = new SlownessDebuff();
    @ConfigEntry.Category(value="Client")
    Client client = new Client();

    public static class BackpackSettings {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        public boolean enableTierUpgrades = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        public boolean disableCrafting = false;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables wearing backpack directly from ground")
        public boolean enableBackpackBlockQuickEquip = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item")
        public boolean invulnerableBackpack = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of items that can be put in tool slots (Use registry names, for example: minecraft:apple)")
        public String[] toolSlotsAcceptableItems = new String[0];
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of items that can't be put in backpack inventory (Use registry names, for example: minecraft:apple)")
        public String[] blacklistedItems = new String[0];
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public boolean allowShulkerBoxes = false;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        @Comment(value="Represents tanks capacity for each tier, from left: Leather, Iron, Gold, Diamond, Netherite, 81000 equals 1 Bucket")
        public long[] tanksCapacity = new long[]{162000L, 243000L, 324000L, 405000L, 486000L};
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Prevents backpack disappearing in void")
        public boolean voidProtection = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Places backpack at place where player died")
        public boolean backpackDeathPlace = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)")
        public boolean backpackForceDeathPlace = false;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        public boolean enableSleepingBagSpawnPoint = false;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="If true, backpack can only be worn by placing it in curios 'Back' slot\nWARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack")
        public boolean trinketsIntegration = false;
    }

    public static class World {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables backpacks spawning in loot chests")
        public boolean enableLoot = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables chance to spawn Zombie, Skeleton, Wither Skeleton, Piglin or Enderman with random backpack equipped")
        public boolean spawnEntitiesWithBackpack = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of overworld entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack")
        public String[] possibleOverworldEntityTypes = new String[]{"minecraft:zombie", "minecraft:skeleton", "minecraft:enderman"};
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of nether entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack")
        public String[] possibleNetherEntityTypes = new String[]{"minecraft:wither_skeleton", "minecraft:piglin"};
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Defines spawn chance of entity with backpack (1 in [selected value])")
        public int spawnChance = 500;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of backpacks that can spawn on overworld mobs")
        public String[] overworldBackpacks = new String[]{"travelersbackpack:standard", "travelersbackpack:diamond", "travelersbackpack:gold", "travelersbackpack:emerald", "travelersbackpack:iron", "travelersbackpack:lapis", "travelersbackpack:redstone", "travelersbackpack:coal", "travelersbackpack:bookshelf", "travelersbackpack:sandstone", "travelersbackpack:snow", "travelersbackpack:sponge", "travelersbackpack:cake", "travelersbackpack:cactus", "travelersbackpack:hay", "travelersbackpack:melon", "travelersbackpack:pumpkin", "travelersbackpack:creeper", "travelersbackpack:enderman", "travelersbackpack:skeleton", "travelersbackpack:spider", "travelersbackpack:bee", "travelersbackpack:wolf", "travelersbackpack:fox", "travelersbackpack:ocelot", "travelersbackpack:horse", "travelersbackpack:cow", "travelersbackpack:pig", "travelersbackpack:sheep", "travelersbackpack:chicken", "travelersbackpack:squid"};
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="List of backpacks that can spawn on nether mobs")
        public String[] netherBackpacks = new String[]{"travelersbackpack:quartz", "travelersbackpack:nether", "travelersbackpack:blaze", "travelersbackpack:ghast", "travelersbackpack:magma_cube", "travelersbackpack:wither"};
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables trade for Villager Backpack in Librarian villager trades")
        public boolean enableVillagerTrade = true;
    }

    public static class BackpackAbilities {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        public boolean enableBackpackAbilities = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.NoTooltip
        public boolean forceAbilityEnabled = false;
    }

    public static class SlownessDebuff {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Player gets slowness effect, if carries too many backpacks in inventory")
        public boolean tooManyBackpacksSlowness = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=1L, max=37L)
        @Comment(value="Maximum number of backpacks, which can be carried in inventory, without slowness effect")
        public int maxNumberOfBackpacks = 3;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=1L, max=5L)
        public int slownessPerExcessedBackpack = 1;
    }

    public static class Client {
        @ConfigEntry.Category(value="Overlay")
        Overlay overlay = new Overlay();
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn")
        public boolean enableToolCycling = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enables tip, how to obtain a backpack, if there's no crafting recipe for it")
        public boolean obtainTips = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Render tools in tool slots on the backpack, while worn")
        public boolean renderTools = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Render backpack if elytra is present")
        public boolean renderBackpackWithElytra = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Disable backpack rendering")
        public boolean disableBackpackRender = false;

        public static class Overlay {
            @ConfigEntry.Gui.RequiresRestart
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Enables tanks and tool slots overlay, while backpack is worn")
            public boolean enableOverlay = true;
            @ConfigEntry.Gui.RequiresRestart
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Offsets to left side")
            public int offsetX = 20;
            @ConfigEntry.Gui.RequiresRestart
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Offsets to up")
            public int offsetY = 30;
        }
    }
}

