/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBaseScreenHandler;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1735;

public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addExclusionArea(TravelersBackpackHandledScreen.class, (screen, consumer) -> {
            if (screen.settingsWidget != null) {
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            }
            if (screen.sortWidget != null && screen.sortWidget.isVisible()) {
                int[] sort = screen.sortWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(sort[0], sort[1], sort[2], sort[3]));
            }
            if (screen.memoryWidget != null && screen.memoryWidget.isVisible()) {
                int[] memory = screen.memoryWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(memory[0], memory[1], memory[2], memory[3]));
            }
        });
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY, new GridMenuInfo());
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_ITEM, new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends TravelersBackpackBaseScreenHandler>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public class_1735 getOutputSlot(T handler) {
            return handler.method_7611(0);
        }

        public List<class_1735> getInputSources(T handler) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>(this.getCraftingSlots(handler));
            int tierStorageSlots = ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getTier().getStorageSlots();
            IntStream.range(10, tierStorageSlots + 46).filter(i -> i <= 10 + tierStorageSlots - 7 || i >= 10 + tierStorageSlots).mapToObj(arg_0 -> handler.method_7611(arg_0)).forEach(slots::add);
            return slots;
        }

        public List<class_1735> getCraftingSlots(T handler) {
            return ((TravelersBackpackBaseScreenHandler)((Object)handler)).field_7761.subList(1, 10);
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
        }
    }
}

