/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ShapedBackpackRecipe
extends class_1869 {
    public ShapedBackpackRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> input, class_1799 output) {
        super(id, group, width, height, input, output);
    }

    public class_1799 method_17727(class_1715 inv) {
        class_1799 output = super.method_17727(inv);
        if (!output.method_7960()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ingredient = inv.method_5438(i);
                if (!ingredient.method_7960() && ingredient.method_7909() instanceof TravelersBackpackItem) {
                    class_2487 compound = ingredient.method_7969();
                    output.method_7980(compound);
                    break;
                }
                if (ingredient.method_7960() || !(ingredient.method_7909() instanceof SleepingBagItem)) continue;
                output.method_7948().method_10569("SleepingBagColor", ShapedBackpackRecipe.getProperColor((SleepingBagItem)ingredient.method_7909()));
            }
        }
        return output;
    }

    public static int getProperColor(SleepingBagItem item) {
        if (item.method_7711() instanceof SleepingBagBlock) {
            return ((SleepingBagBlock)item.method_7711()).method_9487().method_7789();
        }
        return class_1767.field_7964.method_7789();
    }

    public class_1865<?> method_8119() {
        return ModCrafting.BACKPACK_SHAPED;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, class_1856> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    static class_2371<class_1856> createPatternMatrix(String[] pattern, Map<String, class_1856> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    static String[] removePadding(String ... pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.length; ++m) {
            String string = pattern[m];
            i = Math.min(i, ShapedBackpackRecipe.findFirstSymbol(string));
            int n = ShapedBackpackRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.length == l) {
            return new String[0];
        }
        String[] m = new String[pattern.length - l - k];
        for (int string = 0; string < m.length; ++string) {
            m[string] = pattern[string + k].substring(i, j + 1);
        }
        return m;
    }

    public static class Serializer
    implements class_1865<ShapedBackpackRecipe> {
        public ShapedBackpackRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String string = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            Map<String, class_1856> map = ShapedBackpackRecipe.readSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] strings = ShapedBackpackRecipe.removePadding(ShapedBackpackRecipe.getPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> defaultedList = ShapedBackpackRecipe.createPatternMatrix(strings, map, i, j);
            class_1799 itemStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new ShapedBackpackRecipe(identifier, string, i, j, defaultedList, itemStack);
        }

        public ShapedBackpackRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int i = packetByteBuf.method_10816();
            int j = packetByteBuf.method_10816();
            String string = packetByteBuf.method_19772();
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < defaultedList.size(); ++k) {
                defaultedList.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 k = packetByteBuf.method_10819();
            return new ShapedBackpackRecipe(identifier, string, i, j, (class_2371<class_1856>)defaultedList, k);
        }

        public void write(class_2540 packetByteBuf, ShapedBackpackRecipe shapedRecipe) {
            packetByteBuf.method_10804(shapedRecipe.method_8150());
            packetByteBuf.method_10804(shapedRecipe.method_8158());
            packetByteBuf.method_10814(shapedRecipe.method_8112());
            for (class_1856 ingredient : shapedRecipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapedRecipe.method_8110());
        }
    }
}

