/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class NumberReflection {
    public static boolean isNumberType(Class<?> clazz) {
        return clazz.isPrimitive() && clazz != Boolean.TYPE && clazz != Character.TYPE || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class;
    }

    public static boolean isFloatingPointType(Class<?> clazz) {
        return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
    }

    public static <T extends Number> T convert(Number in, Class<T> targetClass) {
        if (!NumberReflection.isNumberType(targetClass)) {
            throw new IllegalArgumentException("Cannot convert to non-number target class");
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return (T)Float.valueOf(in.floatValue());
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return (T)Double.valueOf(in.doubleValue());
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return (T)Byte.valueOf(in.byteValue());
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return (T)Short.valueOf(in.shortValue());
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return (T)Integer.valueOf(in.intValue());
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return (T)Long.valueOf(in.longValue());
        }
        throw new IllegalStateException("Target class does not correspond to a supported number type - this should be unreachable");
    }

    public static <T extends Number> T maxValue(Class<T> numberType) {
        if (!NumberReflection.isNumberType(numberType)) {
            throw new IllegalArgumentException("Cannot get maximum value of non-number class");
        }
        if (numberType == Float.class || numberType == Float.TYPE) {
            return (T)Float.valueOf(Float.MAX_VALUE);
        }
        if (numberType == Double.class || numberType == Double.TYPE) {
            return (T)Double.valueOf(Double.MAX_VALUE);
        }
        if (numberType == Byte.class || numberType == Byte.TYPE) {
            return (T)Byte.valueOf((byte)127);
        }
        if (numberType == Short.class || numberType == Short.TYPE) {
            return (T)Short.valueOf((short)Short.MAX_VALUE);
        }
        if (numberType == Integer.class || numberType == Integer.TYPE) {
            return (T)Integer.valueOf(Integer.MAX_VALUE);
        }
        if (numberType == Long.class || numberType == Long.TYPE) {
            return (T)Long.valueOf(Long.MAX_VALUE);
        }
        throw new IllegalStateException("Target class does not correspond to a supported number type - this should be unreachable");
    }

    public static <T extends Number> T minValue(Class<T> numberType) {
        if (!NumberReflection.isNumberType(numberType)) {
            throw new IllegalArgumentException("Cannot get minimum value of non-number class");
        }
        if (numberType == Float.class || numberType == Float.TYPE) {
            return (T)Float.valueOf(-3.4028235E38f);
        }
        if (numberType == Double.class || numberType == Double.TYPE) {
            return (T)Double.valueOf(-1.7976931348623157E308);
        }
        if (numberType == Byte.class || numberType == Byte.TYPE) {
            return (T)Byte.valueOf((byte)-128);
        }
        if (numberType == Short.class || numberType == Short.TYPE) {
            return (T)Short.valueOf((short)Short.MIN_VALUE);
        }
        if (numberType == Integer.class || numberType == Integer.TYPE) {
            return (T)Integer.valueOf(Integer.MIN_VALUE);
        }
        if (numberType == Long.class || numberType == Long.TYPE) {
            return (T)Long.valueOf(Long.MIN_VALUE);
        }
        throw new IllegalStateException("Target class does not correspond to a supported number type - this should be unreachable");
    }
}

