/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.layers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layer;
import io.wispforest.owo.util.pond.OwoScreenExtension;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public final class Layers {
    public static class_2960 INIT_PHASE = new class_2960("owo", "init-layers");
    private static final Multimap<Class<? extends class_437>, Layer<?, ?>> LAYERS = HashMultimap.create();

    @SafeVarargs
    public static <S extends class_437, R extends ParentComponent> Layer<S, R> add(BiFunction<Sizing, Sizing, R> rootComponentMaker, Consumer<Layer.Instance> instanceInitializer, Class<? extends S> ... screenClasses) {
        Layer layer = new Layer(rootComponentMaker, instanceInitializer);
        for (Class<? extends S> screenClass : screenClasses) {
            LAYERS.put(screenClass, layer);
        }
        return layer;
    }

    public static <S extends class_437> Collection<Layer<S, ?>> getLayers(Class<S> screenClass) {
        return LAYERS.get(screenClass);
    }

    public static <S extends class_437> List<Layer.Instance> getInstances(S screen) {
        return ((OwoScreenExtension)screen).owo$getLayersView();
    }

    static {
        ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, INIT_PHASE);
        ScreenEvents.AFTER_INIT.register(INIT_PHASE, (client, screen, scaledWidth, scaledHeight) -> {
            ((OwoScreenExtension)screen).owo$updateLayers();
            ScreenEvents.remove((class_437)screen).register(bruh -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    instance.adapter.dispose();
                }
            });
            ScreenEvents.beforeRender((class_437)screen).register((bruh, matrices, mouseX, mouseY, tickDelta) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    if (!instance.aggressivePositioning) continue;
                    instance.dispatchLayoutUpdates();
                }
            });
            ScreenEvents.afterRender((class_437)screen).register((bruh, matrices, mouseX, mouseY, tickDelta) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    instance.adapter.method_25394(matrices, mouseX, mouseY, tickDelta);
                }
            });
            ScreenMouseEvents.allowMouseClick((class_437)screen).register((bruh, mouseX, mouseY, button) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.method_25402(mouseX, mouseY, button);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenMouseEvents.allowMouseRelease((class_437)screen).register((bruh, mouseX, mouseY, button) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.method_25406(mouseX, mouseY, button);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenMouseEvents.allowMouseScroll((class_437)screen).register((bruh, mouseX, mouseY, horizontalAmount, verticalAmount) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.method_25401(mouseX, mouseY, verticalAmount);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((bruh, key, scancode, modifiers) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.method_25404(key, scancode, modifiers);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenKeyboardEvents.allowKeyRelease((class_437)screen).register((bruh, key, scancode, modifiers) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.method_16803(key, scancode, modifiers);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
        });
    }
}

