/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.util.UIErrorToast;
import java.nio.file.Path;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseUIModelScreen<R extends ParentComponent>
extends BaseOwoScreen<R> {
    protected final UIModel model;
    protected final Class<R> rootComponentClass;

    protected BaseUIModelScreen(Class<R> rootComponentClass, DataSource source) {
        UIModel providedModel = source.get();
        if (providedModel == null) {
            source.reportError();
            this.invalid = true;
        }
        this.rootComponentClass = rootComponentClass;
        this.model = providedModel;
    }

    @Override
    @NotNull
    protected OwoUIAdapter<R> createAdapter() {
        return this.model.createAdapter(this.rootComponentClass, this);
    }

    public static interface DataSource {
        @Nullable
        public UIModel get();

        public void reportError();

        public static DataSource file(final String filePath) {
            return new DataSource(){

                @Override
                @Nullable
                public UIModel get() {
                    if (!Owo.DEBUG) {
                        throw new IllegalStateException("Debug UI data source must not be used in production");
                    }
                    return UIModel.load(Path.of(filePath, new String[0]));
                }

                @Override
                public void reportError() {
                    UIErrorToast.report("Could not load UI model from file " + filePath);
                }
            };
        }

        public static DataSource asset(final class_2960 assetPath) {
            return new DataSource(){

                @Override
                @Nullable
                public UIModel get() {
                    return UIModelLoader.getPreloaded(assetPath);
                }

                @Override
                public void reportError() {
                    UIErrorToast.report("No UI model with id " + assetPath + " was found");
                }
            };
        }
    }
}

