/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.FocusHandler;
import io.wispforest.owo.ui.util.ScissorStack;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public abstract class BaseParentComponent
extends BaseComponent
implements ParentComponent {
    protected Observable<VerticalAlignment> verticalAlignment = Observable.of(VerticalAlignment.TOP);
    protected Observable<HorizontalAlignment> horizontalAlignment = Observable.of(HorizontalAlignment.LEFT);
    protected AnimatableProperty<Insets> padding = AnimatableProperty.of(Insets.none());
    @Nullable
    protected FocusHandler focusHandler = null;
    @Nullable
    protected ArrayList<Runnable> taskQueue = null;
    protected Surface surface = Surface.BLANK;
    protected boolean allowOverflow = false;

    protected BaseParentComponent(Sizing horizontalSizing, Sizing verticalSizing) {
        this.horizontalSizing.set(horizontalSizing);
        this.verticalSizing.set(verticalSizing);
        Observable.observeAll(this::updateLayout, this.horizontalAlignment, this.verticalAlignment, this.padding);
    }

    @Override
    public final void update(float delta, int mouseX, int mouseY) {
        ParentComponent.super.update(delta, mouseX, mouseY);
        super.update(delta, mouseX, mouseY);
        this.parentUpdate(delta, mouseX, mouseY);
        if (this.taskQueue != null) {
            this.taskQueue.forEach(Runnable::run);
            this.taskQueue.clear();
        }
    }

    protected void parentUpdate(float delta, int mouseX, int mouseY) {
    }

    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        this.surface.draw(matrices, this);
    }

    @Override
    public void queue(Runnable task) {
        if (this.taskQueue == null) {
            this.parent.queue(task);
        } else {
            this.taskQueue.add(task);
        }
    }

    @Override
    @Nullable
    public FocusHandler focusHandler() {
        if (this.focusHandler == null) {
            return super.focusHandler();
        }
        return this.focusHandler;
    }

    @Override
    public ParentComponent verticalAlignment(VerticalAlignment alignment) {
        this.verticalAlignment.set(alignment);
        return this;
    }

    @Override
    public VerticalAlignment verticalAlignment() {
        return this.verticalAlignment.get();
    }

    @Override
    public ParentComponent horizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment.set(alignment);
        return this;
    }

    @Override
    public HorizontalAlignment horizontalAlignment() {
        return this.horizontalAlignment.get();
    }

    @Override
    public ParentComponent padding(Insets padding) {
        this.padding.set(padding);
        this.updateLayout();
        return this;
    }

    @Override
    public AnimatableProperty<Insets> padding() {
        return this.padding;
    }

    @Override
    public ParentComponent allowOverflow(boolean allowOverflow) {
        this.allowOverflow = allowOverflow;
        return this;
    }

    @Override
    public boolean allowOverflow() {
        return this.allowOverflow;
    }

    @Override
    public ParentComponent surface(Surface surface) {
        this.surface = surface;
        return this;
    }

    @Override
    public Surface surface() {
        return this.surface;
    }

    @Override
    public void mount(ParentComponent parent, int x, int y) {
        super.mount(parent, x, y);
        if (parent == null && this.focusHandler == null) {
            this.focusHandler = new FocusHandler(this);
            this.taskQueue = new ArrayList();
        }
    }

    @Override
    public void inflate(Size space) {
        if (this.space.equals(space) && !this.dirty) {
            return;
        }
        this.space = space;
        for (Component child : this.children()) {
            child.dismount(Component.DismountReason.LAYOUT_INFLATION);
        }
        super.inflate(space);
        this.layout(space);
        super.inflate(space);
    }

    protected void updateLayout() {
        if (!this.mounted) {
            return;
        }
        if (this.batchedEvents > 0) {
            ++this.batchedEvents;
            return;
        }
        Size previousSize = this.fullSize();
        this.dirty = true;
        this.inflate(this.space);
        if (!previousSize.equals(this.fullSize()) && this.parent != null) {
            this.parent.onChildMutated(this);
        }
    }

    @Override
    protected void runAndDeferEvents(Runnable action) {
        try {
            this.batchedEvents = 1;
            action.run();
        }
        finally {
            if (this.batchedEvents > 1) {
                this.batchedEvents = 0;
                this.updateLayout();
            } else {
                this.batchedEvents = 0;
            }
        }
    }

    @Override
    public void onChildMutated(Component child) {
        this.updateLayout();
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        if (this.focusHandler != null) {
            this.focusHandler.updateClickFocus((double)this.x + mouseX, (double)this.y + mouseY);
        }
        return ParentComponent.super.onMouseDown(mouseX, mouseY, button) || super.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        if (this.focusHandler != null && this.focusHandler.focused() != null) {
            Component focused = this.focusHandler.focused();
            return focused.onMouseUp((double)this.x + mouseX - (double)focused.x(), (double)this.y + mouseY - (double)focused.y(), button);
        }
        return super.onMouseUp(mouseX, mouseY, button);
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return ParentComponent.super.onMouseScroll(mouseX, mouseY, amount) || super.onMouseScroll(mouseX, mouseY, amount);
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.focusHandler != null && this.focusHandler.focused() != null) {
            Component focused = this.focusHandler.focused();
            return focused.onMouseDrag((double)this.x + mouseX - (double)focused.x(), (double)this.y + mouseY - (double)focused.y(), deltaX, deltaY, button);
        }
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (this.focusHandler == null) {
            return false;
        }
        if (keyCode == 258) {
            this.focusHandler.cycle((modifiers & 1) == 0);
        } else if ((keyCode == 262 || keyCode == 263 || keyCode == 264 || keyCode == 265) && (modifiers & 4) != 0) {
            this.focusHandler.moveFocus(keyCode);
        } else if (this.focusHandler.focused() != null) {
            return this.focusHandler.focused().onKeyPress(keyCode, scanCode, modifiers);
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char chr, int modifiers) {
        if (this.focusHandler == null) {
            return false;
        }
        if (this.focusHandler.focused() != null) {
            return this.focusHandler.focused().onCharTyped(chr, modifiers);
        }
        return super.onCharTyped(chr, modifiers);
    }

    @Override
    public void updateX(int x) {
        int offset = x - this.x;
        super.updateX(x);
        for (Component child : this.children()) {
            child.updateX(child.x() + offset);
        }
    }

    @Override
    public void updateY(int y) {
        int offset = y - this.y;
        super.updateY(y);
        for (Component child : this.children()) {
            child.updateY(child.y() + offset);
        }
    }

    protected Size childMountingOffset() {
        Insets padding = (Insets)this.padding.get();
        return Size.of(padding.left(), padding.top());
    }

    protected void mountChild(@Nullable Component child, Size space, Consumer<Component> layoutFunc) {
        if (child == null) {
            return;
        }
        Positioning positioning = (Positioning)child.positioning().get();
        Insets componentMargins = (Insets)child.margins().get();
        Insets padding = (Insets)this.padding.get();
        switch (positioning.type) {
            case LAYOUT: {
                layoutFunc.accept(child);
                break;
            }
            case ABSOLUTE: {
                child.inflate(space);
                child.mount(this, this.x + positioning.x + componentMargins.left() + padding.left(), this.y + positioning.y + componentMargins.top() + padding.top());
                break;
            }
            case RELATIVE: {
                child.inflate(space);
                child.mount(this, this.x + padding.left() + componentMargins.left() + Math.round((float)positioning.x / 100.0f * (float)(this.width() - child.fullSize().width() - padding.horizontal())), this.y + padding.top() + componentMargins.top() + Math.round((float)positioning.y / 100.0f * (float)(this.height() - child.fullSize().height() - padding.vertical())));
            }
        }
    }

    protected void drawChildren(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta, List<Component> children) {
        if (!this.allowOverflow) {
            Insets padding = (Insets)this.padding.get();
            ScissorStack.push(this.x + padding.left(), this.y + padding.top(), this.width - padding.horizontal(), this.height - padding.vertical(), matrices);
        }
        FocusHandler focusHandler = this.focusHandler();
        for (int i = 0; i < children.size(); ++i) {
            Component child = children.get(i);
            if (!ScissorStack.isVisible(child, matrices)) continue;
            matrices.method_22904(0.0, 0.0, (double)child.zIndex());
            child.draw(matrices, mouseX, mouseY, partialTicks, delta);
            if (focusHandler.lastFocusSource() == Component.FocusSource.KEYBOARD_CYCLE && focusHandler.focused() == child) {
                child.drawFocusHighlight(matrices, mouseX, mouseY, partialTicks, delta);
            }
            matrices.method_22904(0.0, 0.0, (double)(-child.zIndex()));
        }
        if (!this.allowOverflow) {
            ScissorStack.pop();
        }
    }

    protected Size calculateChildSpace(Size thisSpace) {
        Insets padding = (Insets)this.padding.get();
        return Size.of(((Sizing)this.horizontalSizing.get()).isContent() ? thisSpace.width() - padding.horizontal() : this.width - padding.horizontal(), ((Sizing)this.verticalSizing.get()).isContent() ? thisSpace.height() - padding.vertical() : this.height - padding.vertical());
    }

    @Override
    public BaseParentComponent positioning(Positioning positioning) {
        return (BaseParentComponent)super.positioning(positioning);
    }

    @Override
    public BaseParentComponent margins(Insets margins) {
        return (BaseParentComponent)super.margins(margins);
    }
}

