/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.moddata;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.wispforest.owo.Owo;
import io.wispforest.owo.moddata.ModDataConsumer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;

public class ModDataLoader {
    private static final Gson GSON = new Gson();
    private static final Path DATA_PATH = FabricLoader.getInstance().getGameDir().resolve("moddata");

    public static void load(ModDataConsumer consumer) {
        HashMap<class_2960, JsonObject> foundFiles = new HashMap<class_2960, JsonObject>();
        FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
            Path targetPath = modContainer.getRootPath().resolve(String.format("data/%s/%s", modContainer.getMetadata().getId(), consumer.getDataSubdirectory()));
            ModDataLoader.tryLoadFilesFrom(foundFiles, modContainer.getMetadata().getId(), targetPath);
        });
        try {
            Files.createDirectories(DATA_PATH, new FileAttribute[0]);
            Files.list(DATA_PATH).forEach(nsPath -> {
                if (!Files.isDirectory(nsPath, new LinkOption[0])) {
                    return;
                }
                String namespace = nsPath.getFileName().toString();
                Path targetPath = nsPath.resolve(consumer.getDataSubdirectory());
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    return;
                }
                ModDataLoader.tryLoadFilesFrom(foundFiles, namespace, targetPath);
            });
        }
        catch (IOException e) {
            Owo.LOGGER.error("### Unable to traverse global data tree ++ Stacktrace below ###", (Throwable)e);
        }
        foundFiles.forEach(consumer::acceptParsedFile);
    }

    private static void tryLoadFilesFrom(Map<class_2960, JsonObject> foundFiles, String namespace, Path targetPath) {
        try {
            if (!Files.exists(targetPath, new LinkOption[0])) {
                return;
            }
            Files.walk(targetPath, new FileVisitOption[0]).forEach(path -> {
                if (!path.toString().endsWith(".json")) {
                    return;
                }
                try {
                    InputStreamReader tabData = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]));
                    foundFiles.put(new class_2960(namespace, FilenameUtils.removeExtension((String)targetPath.relativize((Path)path).toString())), (JsonObject)GSON.fromJson((Reader)tabData, JsonObject.class));
                }
                catch (IOException e) {
                    Owo.LOGGER.warn("### Unable to open data file {} ++ Stacktrace below ###", path, (Object)e);
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            Owo.LOGGER.error("### Unable to traverse data tree {} ++ Stacktrace below ###", (Object)targetPath, (Object)e);
        }
    }
}

