/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.configured;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraftforge.api.fml.event.config.ModConfigEvents;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.configured.ForgeConfigHelper;
import net.minecraftforge.configured.ForgeFolderEntry;
import net.minecraftforge.configured.ForgeListValue;
import net.minecraftforge.configured.ForgeValue;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfig
implements IModConfig {
    protected static final EnumMap<ModConfig.Type, ConfigType> TYPE_RESOLVER = (EnumMap)class_156.method_654(new EnumMap(ModConfig.Type.class), map -> {
        map.put(ModConfig.Type.CLIENT, ConfigType.CLIENT);
        map.put(ModConfig.Type.COMMON, ConfigType.UNIVERSAL);
        map.put(ModConfig.Type.SERVER, ConfigType.WORLD_SYNC);
    });
    protected final ModConfig config;
    protected final List<ForgeValueEntry> allConfigValues;

    public ForgeConfig(ModConfig config) {
        this.config = config;
        this.allConfigValues = this.getAllConfigValues(config);
    }

    protected ForgeConfig(ModConfig config, List<ForgeValueEntry> allConfigValues) {
        this.config = config;
        this.allConfigValues = allConfigValues;
    }

    public void update(IConfigEntry entry) {
        Set changedValues = ConfigHelper.getChangedValues((IConfigEntry)entry);
        if (!changedValues.isEmpty()) {
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
            changedValues.forEach(value -> {
                if (value instanceof ForgeValue) {
                    ForgeListValue forgeList;
                    Function<List<?>, List<?>> converter;
                    ForgeValue forge = (ForgeValue)value;
                    if (forge instanceof ForgeListValue && (converter = (forgeList = (ForgeListValue)forge).getConverter()) != null) {
                        newConfig.set(forge.configValue.getPath(), converter.apply((List)forgeList.get()));
                        return;
                    }
                    newConfig.set(forge.configValue.getPath(), value.get());
                }
            });
            this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        }
        if (this.getType() == ConfigType.WORLD_SYNC) {
            if (!ConfigHelper.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ForgeConfigHelper.setForgeConfigData(this.config, null);
            }
        } else if (!changedValues.isEmpty()) {
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            ModConfigEvents.reloading(this.getModId());
        }
    }

    public IConfigEntry getRoot() {
        return new ForgeFolderEntry(((ForgeConfigSpec)this.config.getSpec()).getValues(), (ForgeConfigSpec)this.config.getSpec());
    }

    public ConfigType getType() {
        return TYPE_RESOLVER.get((Object)this.config.getType());
    }

    public String getFileName() {
        return this.config.getFileName();
    }

    public String getModId() {
        return this.config.getModId();
    }

    public void loadWorldConfig(Path path, Consumer<IModConfig> result) {
        CommentedFileConfig data = this.config.getHandler().reader(path).apply(this.config);
        ForgeConfigHelper.setForgeConfigData(this.config, (CommentedConfig)data);
        result.accept(this);
    }

    public void stopEditing() {
        if (this.config != null && this.getType() == ConfigType.WORLD && !ConfigHelper.isPlayingGame()) {
            this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
            ForgeConfigHelper.setForgeConfigData(this.config, null);
        }
    }

    public boolean isChanged() {
        if (ConfigHelper.isWorldConfig((IModConfig)this) && this.config.getConfigData() == null) {
            return false;
        }
        return this.allConfigValues.stream().anyMatch(entry -> !Objects.equals(entry.value.get(), entry.spec.getDefault()));
    }

    public void restoreDefaults() {
        if (ConfigHelper.isWorldConfig((IModConfig)this) && this.config.getConfigData() == null) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        this.allConfigValues.forEach(entry -> newConfig.set(entry.value.getPath(), entry.spec.getDefault()));
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        this.allConfigValues.forEach(pair -> pair.value.clearCache());
    }

    protected List<ForgeValueEntry> getAllConfigValues(ModConfig config) {
        return ForgeConfigHelper.gatherAllForgeConfigValues(config).stream().map(pair -> new ForgeValueEntry((ForgeConfigSpec.ConfigValue)pair.getLeft(), (ForgeConfigSpec.ValueSpec)pair.getRight())).toList();
    }

    protected record ForgeValueEntry(ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
    }
}

