/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.creativetab;

import fuzs.puzzleslib.util.CreativeModeTabBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public abstract class CreativeModeTabBuilderImpl
implements CreativeModeTabBuilder {
    private static final class_1792[] POTION_ITEMS = new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150, class_1802.field_8087};
    final class_2960 identifier;
    private Supplier<class_1799> iconSupplier = () -> class_1799.field_8037;
    boolean cacheIcon = true;
    boolean showTitle = true;
    boolean showScrollbar = true;
    boolean alignRight;
    @Nullable
    BiConsumer<class_2371<class_1799>, class_1761> stacksForDisplay;
    boolean appendEnchantments;
    boolean appendPotions;
    boolean showSearch;

    public CreativeModeTabBuilderImpl(String modId, String identifier) {
        this.identifier = new class_2960(modId, identifier);
    }

    class_1799 getIcon() {
        class_1799 stack = this.iconSupplier.get();
        if (stack.method_7960()) {
            throw new IllegalStateException("Creative tab icon cannot be empty");
        }
        return stack;
    }

    @Override
    public CreativeModeTabBuilder setIcon(Supplier<class_1799> icon) {
        Objects.requireNonNull(icon, "icon supplier was null");
        this.iconSupplier = icon;
        return this;
    }

    @Override
    public CreativeModeTabBuilder disableIconCache() {
        this.cacheIcon = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder hideTitle() {
        this.showTitle = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder hideScroll() {
        this.showScrollbar = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder alignRight() {
        this.alignRight = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendItemsV2(BiConsumer<class_2371<class_1799>, class_1761> itemStacks) {
        Objects.requireNonNull(itemStacks, "item stacks consumer was null");
        this.stacksForDisplay = itemStacks;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendAllEnchantments() {
        this.appendEnchantments = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendAllPotions() {
        this.appendPotions = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder showSearch() {
        this.showSearch = true;
        return this;
    }

    void appendAdditionals(class_2371<class_1799> itemStacks) {
        if (this.appendEnchantments) {
            this.appendAllEnchantments(arg_0 -> itemStacks.add(arg_0));
        }
        if (this.appendPotions) {
            this.appendAllPotions(arg_0 -> itemStacks.add(arg_0));
        }
    }

    private void appendAllEnchantments(Consumer<class_1799> itemStacks) {
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> ((class_5321)entry.getKey()).method_29177().method_12832());
        this.getNamespacedEntries(class_2378.field_11160, this.identifier.method_12836()).sorted(comparator).map(Map.Entry::getValue).forEach(enchantment -> itemStacks.accept(class_1772.method_7808((class_1889)new class_1889(enchantment, enchantment.method_8183()))));
    }

    private void appendAllPotions(Consumer<class_1799> itemStacks) {
        Comparator<class_1842> comparator = Comparator.comparing(potion -> {
            if (potion.method_8049().isEmpty()) {
                throw new IllegalArgumentException("Cannot compare potions with empty effects!");
            }
            class_1291 effect = ((class_1293)potion.method_8049().get(0)).method_5579();
            class_2960 key = class_2378.field_11159.method_10221((Object)effect);
            Objects.requireNonNull(key, "Mob effect key for class %s is null".formatted(effect.getClass()));
            return key.method_12832();
        }).thenComparingInt(potion -> ((class_1293)potion.method_8049().get(0)).method_5578()).thenComparingInt(potion -> ((class_1293)potion.method_8049().get(0)).method_5584());
        class_1842[] potions = (class_1842[])this.getNamespacedEntries((class_2378)class_2378.field_11143, this.identifier.method_12836()).map(Map.Entry::getValue).filter(potion -> !potion.method_8049().isEmpty()).sorted(comparator).toArray(class_1842[]::new);
        for (class_1792 item : POTION_ITEMS) {
            for (class_1842 potion2 : potions) {
                itemStacks.accept(class_1844.method_8061((class_1799)new class_1799((class_1935)item), (class_1842)potion2));
            }
        }
    }

    private <T> Stream<Map.Entry<class_5321<T>, T>> getNamespacedEntries(class_2378<T> registry, String namespace) {
        return registry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(namespace));
    }
}

