/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.renderer.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.client.renderer.item.v1.ItemModelOverrides;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_763;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverridesImpl
implements ItemModelOverrides {
    private static final Map<class_1792, ItemModelData> ITEM_MODEL_PROVIDERS = Maps.newIdentityHashMap();

    public static Optional<class_1087> getSpecificModelOverride(class_763 itemModelShaper, class_1799 stack, class_809.class_811 transformType) {
        return ItemModelOverridesImpl.getModelOverride(itemModelShaper, stack, (class_1937)class_310.method_1551().field_1687, null, 0, data -> data.getModelLocationByType(transformType));
    }

    public static Optional<class_1087> getGenericModelOverride(class_763 itemModelShaper, class_1799 stack, @Nullable class_1937 level, @Nullable class_1309 livingEntity, int seed) {
        return ItemModelOverridesImpl.getModelOverride(itemModelShaper, stack, level, livingEntity, seed, ItemModelData::customModel);
    }

    public static Optional<class_1087> getModelOverride(class_763 itemModelShaper, class_1799 stack, @Nullable class_1937 level, @Nullable class_1309 livingEntity, int seed, Function<ItemModelData, class_1091> modelGetter) {
        return ItemModelOverridesImpl.getItemModelData(stack).map(modelGetter).map(arg_0 -> ((class_1092)itemModelShaper.method_3303()).method_4742(arg_0)).map(model -> ItemModelOverridesImpl.resolveVanillaModelOverrides(model, itemModelShaper, stack, level, livingEntity, seed));
    }

    private static Optional<ItemModelData> getItemModelData(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ITEM_MODEL_PROVIDERS.get(stack.method_7909()));
    }

    private static class_1087 resolveVanillaModelOverrides(class_1087 bakedModel, class_763 itemModelShaper, class_1799 itemStack, @Nullable class_1937 level, @Nullable class_1309 livingEntity, int seed) {
        class_638 clientLevel = level instanceof class_638 ? (class_638)level : null;
        class_1087 modelOverride = bakedModel.method_4710().method_3495(bakedModel, itemStack, clientLevel, livingEntity, seed);
        return modelOverride == null ? itemModelShaper.method_3303().method_4744() : modelOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(class_1792 item, class_1091 itemModel, class_1091 customModel, class_809.class_811 ... itemModelTransforms) {
        Class<ItemModelOverridesImpl> clazz = ItemModelOverridesImpl.class;
        synchronized (ItemModelOverridesImpl.class) {
            if (ITEM_MODEL_PROVIDERS.put(item, new ItemModelData(itemModel, customModel, (Set<class_809.class_811>)ImmutableSet.copyOf((Object[])itemModelTransforms))) != null) {
                throw new IllegalStateException("Duplicate custom item model provider registered for item %s".formatted(class_2378.field_11142.method_10221((Object)item)));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private record ItemModelData(class_1091 itemModel, class_1091 customModel, Set<class_809.class_811> itemModelTransforms) {
        @Nullable
        public class_1091 getModelLocationByType(class_809.class_811 transformType) {
            return this.itemModelTransforms.contains(transformType) ? this.itemModel : null;
        }
    }
}

