/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.biome;

import com.google.common.collect.ImmutableSet;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.core.ReflectionHelperV2;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_5483;
import org.jetbrains.annotations.Nullable;

public class MobSpawnSettingsContextFabric
implements MobSpawnSettingsContext {
    private final class_5483 mobSpawnSettings;
    private final BiomeModificationContext.SpawnSettingsContext context;

    public MobSpawnSettingsContextFabric(class_5483 mobSpawnSettings, BiomeModificationContext.SpawnSettingsContext context) {
        this.mobSpawnSettings = mobSpawnSettings;
        this.context = context;
    }

    @Override
    public void setCreatureGenerationProbability(float probability) {
        this.context.setCreatureSpawnProbability(probability);
    }

    @Override
    public void addSpawn(class_1311 spawnGroup, class_5483.class_1964 spawnEntry) {
        this.context.addSpawn(spawnGroup, spawnEntry);
    }

    @Override
    public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> predicate) {
        return this.context.removeSpawns(predicate);
    }

    @Override
    public void setSpawnCost(class_1299<?> entityType, double mass, double gravityLimit) {
        this.context.setSpawnCost(entityType, mass, gravityLimit);
    }

    @Override
    public boolean clearSpawnCost(class_1299<?> entityType) {
        if (this.mobSpawnSettings.method_31003(entityType) != null) {
            this.context.clearSpawnCost(entityType);
            return true;
        }
        return false;
    }

    @Override
    public Set<class_1311> getMobCategoriesWithSpawns() {
        Optional<EnumMap<class_1311, List<class_5483.class_1964>>> optional = this.findFabricSpawners();
        return (Set)optional.map(map -> map.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).map(Map.Entry::getKey)).orElseGet(() -> Stream.of(class_1311.values()).filter(mobCategory -> !this.mobSpawnSettings.method_31004(mobCategory).method_34993())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public List<class_5483.class_1964> getSpawnerData(class_1311 type) {
        Optional<EnumMap<class_1311, List<class_5483.class_1964>>> optional = this.findFabricSpawners();
        return optional.map(map -> Collections.unmodifiableList((List)map.get(type))).orElseGet(() -> this.mobSpawnSettings.method_31004(type).method_34994());
    }

    private Optional<EnumMap<class_1311, List<class_5483.class_1964>>> findFabricSpawners() {
        Field field = ReflectionHelperV2.findField("net.fabricmc.fabric.impl.biome.modification.BiomeModificationContextImpl$SpawnSettingsContextImpl", "fabricSpawners", true);
        return ReflectionHelperV2.getValue(field, this.context);
    }

    @Override
    public Set<class_1299<?>> getEntityTypesWithSpawnCost() {
        return (Set)class_2378.field_11145.method_10220().filter(entityType -> this.mobSpawnSettings.method_31003(entityType) != null).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nullable
    public class_5483.class_5265 getSpawnCost(class_1299<?> type) {
        return this.mobSpawnSettings.method_31003(type);
    }

    @Override
    public float getCreatureGenerationProbability() {
        return this.mobSpawnSettings.method_31002();
    }
}

