/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolder;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.FabricConfigDataHolderImpl;
import fuzs.puzzleslib.config.core.FabricModConfig;
import fuzs.puzzleslib.core.DistType;
import fuzs.puzzleslib.core.DistTypeExecutor;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraftforge.api.fml.event.config.ModConfigEvents;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class FabricConfigHolderImpl
implements ConfigHolder.Builder {
    private Map<Class<? extends ConfigCore>, FabricConfigDataHolderImpl<? extends ConfigCore>> configsByClass = Maps.newIdentityHashMap();

    @Override
    public <T extends ConfigCore> ConfigDataHolder<T> getHolder(Class<T> clazz) {
        FabricConfigDataHolderImpl<? extends ConfigCore> holder = this.configsByClass.get(clazz);
        Objects.requireNonNull(holder, String.format("No config holder available for type %s", clazz));
        return holder;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder clientConfig(Class<T> clazz, Supplier<T> clientConfig) {
        Supplier<ConfigCore> config = () -> (ConfigCore)DistTypeExecutor.getWhenOn(DistType.CLIENT, () -> FabricConfigHolderImpl.lambda$clientConfig$0((Supplier)clientConfig));
        if (this.configsByClass.put(clazz, new FabricConfigDataHolderImpl<ConfigCore>(ModConfig.Type.CLIENT, config)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for client config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder commonConfig(Class<T> clazz, Supplier<T> commonConfig) {
        if (this.configsByClass.put(clazz, new FabricConfigDataHolderImpl<T>(ModConfig.Type.COMMON, commonConfig)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for common config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder serverConfig(Class<T> clazz, Supplier<T> serverConfig) {
        if (this.configsByClass.put(clazz, new FabricConfigDataHolderImpl<T>(ModConfig.Type.SERVER, serverConfig)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for server config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder setFileName(Class<T> clazz, UnaryOperator<String> fileName) {
        FabricConfigDataHolderImpl holder = (FabricConfigDataHolderImpl)this.getHolder(clazz);
        holder.setFileName(fileName);
        return this;
    }

    @Override
    public void bakeConfigs(String modId) {
        this.configsByClass = ImmutableMap.copyOf(this.configsByClass);
        for (FabricConfigDataHolderImpl<? extends ConfigCore> holder : this.configsByClass.values()) {
            if (holder.config == null) continue;
            ModConfigEvents.loading((String)modId).register(config -> holder.onModConfig(config, false));
            ModConfigEvents.reloading((String)modId).register(config -> holder.onModConfig(config, true));
            holder.register((type, spec, fileName) -> {
                ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new IllegalArgumentException(String.format("No mod with mod id %s", modId)));
                return new FabricModConfig(type, (IConfigSpec<?>)spec, modContainer, (String)fileName.apply(modId));
            });
        }
    }

    private static /* synthetic */ Supplier lambda$clientConfig$0(Supplier clientConfig) {
        return clientConfig;
    }
}

