/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.networking.v3;

import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.networking.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.proxy.Proxy;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public interface NetworkHandlerV3 {
    public <T extends Record> class_2596<?> toClientboundPacket(T var1);

    public <T extends Record> class_2596<?> toServerboundPacket(T var1);

    default public <T extends Record> void sendToServer(T message) {
        Proxy.INSTANCE.getClientConnection().method_10743(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendTo(T message, class_3222 player) {
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(T message) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14581(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllExcept(T message, class_3222 exclude) {
        for (class_3222 player : Proxy.INSTANCE.getGameServer().method_3760().method_14571()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public <T extends Record> void sendToAllNear(T message, class_2338 pos, class_1937 level) {
        this.sendToAllNearExcept(message, null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, level);
    }

    default public <T extends Record> void sendToAllNear(T message, double posX, double posY, double posZ, double distance, class_1937 level) {
        this.sendToAllNearExcept(message, null, posX, posY, posZ, 64.0, level);
    }

    default public <T extends Record> void sendToAllNearExcept(T message, @Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_1937 level) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(T message, class_1297 entity) {
        ((class_3215)entity.method_5770().method_8398()).method_18754(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTrackingAndSelf(T message, class_1297 entity) {
        ((class_3215)entity.method_5770().method_8398()).method_18751(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToDimension(T message, class_1937 level) {
        this.sendToDimension(message, (class_5321<class_1937>)level.method_27983());
    }

    default public <T extends Record> void sendToDimension(T message, class_5321<class_1937> dimension) {
        Proxy.INSTANCE.getGameServer().method_3760().method_14589(this.toClientboundPacket(message), dimension);
    }

    public static Builder builder(String modId) {
        return CommonFactories.INSTANCE.networkingV3(modId);
    }

    public static interface Builder {
        default public <T> Builder registerSerializer(Class<T> type, class_2540.class_7462<T> writer, class_2540.class_7461<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, class_5321<class_2378<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder clientAcceptsVanillaOrMissing();

        public Builder serverAcceptsVanillaOrMissing();

        default public Builder allAcceptVanillaOrMissing() {
            return this.clientAcceptsVanillaOrMissing().serverAcceptsVanillaOrMissing();
        }

        public NetworkHandlerV3 build();
    }
}

