/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli.page;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lucaargolo.seasonsextras.patchouli.mixed.FontManagerMixed;
import io.github.lucaargolo.seasonsextras.patchouli.mixin.MinecraftClientAccessor;
import io.github.lucaargolo.seasonsextras.utils.Tickable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageText;

public abstract class PageSearch
extends PageText
implements Tickable {
    protected final transient List<class_3545<class_2960, String>> searchable = new ArrayList<class_3545<class_2960, String>>();
    private transient BookTextRenderer textRender;
    private transient class_342 searchBar;
    private double scrollableOffset = 0.0;
    private boolean scrollable = false;
    private double excessHeight = 0.0;
    private boolean draggingScroll = false;

    protected abstract String getSearchable();

    public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
        super.render(ms, mouseX, mouseY, pticks);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.parent.getBookTexture());
        class_332.method_25290((class_4587)ms, (int)6, (int)135, (float)140.0f, (float)183.0f, (int)99, (int)14, (int)512, (int)256);
        this.textRender.render(ms, mouseX, mouseY);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.parent.getBookTexture());
        if (this.scrollable) {
            int mx = mouseX - this.parent.bookLeft;
            int my = mouseY - this.parent.bookTop;
            double offset = class_3532.method_16436((double)(this.scrollableOffset / this.excessHeight), (double)12.0, (double)104.0);
            class_332.method_25290((class_4587)ms, (int)99, (int)11, (float)352.0f, (float)56.0f, (int)8, (int)115, (int)512, (int)256);
            class_332.method_25290((class_4587)ms, (int)100, (int)((int)offset), (float)360.0f, (float)56.0f, (int)6, (int)21, (int)512, (int)256);
            if (mx > 100 && mx < 106 && (double)my > offset && (double)my < offset + 21.0) {
                class_332.method_25294((class_4587)ms, (int)100, (int)((int)offset), (int)106, (int)((int)offset + 21), (int)-2130706433);
            }
        }
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.textRender = new BookTextRenderer((GuiBook)parent, (class_2561)this.text.as(class_2561.class), 0, 12);
        class_327 fontRenderer = ((FontManagerMixed)((MinecraftClientAccessor)class_310.method_1551()).getFontManager()).createStyledTextRenderer(this.book.getFontStyle());
        this.searchBar = new class_342(fontRenderer, parent.bookLeft + left + 21, parent.bookTop + top + 136, 115, 10, (class_2561)class_2561.method_43470((String)""));
        this.searchBar.method_1868(0);
        this.searchBar.method_1858(false);
        this.searchBar.method_1863(this::updateText);
        this.searchBar.method_1854((string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)parent.book.getFontStyle()));
        parent.method_37063((class_364)this.searchBar);
        this.updateText(this.searchBar.method_1882());
    }

    public void updateText(String search) {
        this.scrollableOffset = 0.0;
        this.excessHeight = 0.0;
        this.scrollable = false;
        AtomicReference<String> string = new AtomicReference<String>("");
        AtomicInteger height = new AtomicInteger(0);
        AtomicInteger overflow = new AtomicInteger(0);
        this.searchable.stream().filter(p -> ((String)p.method_15441()).toLowerCase().contains(search.toLowerCase())).forEach(p -> {
            if (height.getAndIncrement() < 13) {
                string.getAndUpdate(t -> t + "$(l:" + this.getSearchable() + "#" + p.method_15442() + ")" + (String)p.method_15441() + "$(br)$()");
            } else {
                this.scrollable = true;
                overflow.getAndIncrement();
            }
        });
        this.excessHeight = overflow.get() * 9;
        while (height.getAndIncrement() < 13) {
            string.getAndUpdate(t -> t + "$(br)");
        }
        string.getAndUpdate(t -> t + "$(br)");
        this.setText(string.get());
        this.textRender = new BookTextRenderer((GuiBook)this.parent, (class_2561)this.text.as(class_2561.class), 0, this.getTextHeight());
    }

    public void updateTextHeight() {
        String search = this.searchBar.method_1882();
        int cycle = class_3532.method_15357((double)(this.scrollableOffset / 9.0));
        if (cycle < this.searchable.size()) {
            AtomicReference<String> string = new AtomicReference<String>("");
            AtomicInteger height = new AtomicInteger(0);
            this.searchable.subList(cycle, this.searchable.size()).stream().filter(p -> ((String)p.method_15441()).toLowerCase().contains(search.toLowerCase())).forEach(p -> {
                if (height.getAndIncrement() < 13) {
                    string.getAndUpdate(t -> t + "$(l:" + this.getSearchable() + "#" + p.method_15442() + ")" + (String)p.method_15441() + "$(br)$()");
                }
            });
            while (height.getAndIncrement() < 13) {
                string.getAndUpdate(t -> t + "$(br)");
            }
            string.getAndUpdate(t -> t + "$(br)");
            this.setText(string.get());
            this.textRender = new BookTextRenderer((GuiBook)this.parent, (class_2561)this.text.as(class_2561.class), 0, this.getTextHeight());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int mx = (int)mouseX - this.parent.bookLeft;
        int my = (int)mouseY - this.parent.bookTop;
        if (this.scrollable && mx > 100 && mx < 106 && my > 12 && my < 125) {
            double offset = class_3532.method_16436((double)(this.scrollableOffset / this.excessHeight), (double)12.0, (double)104.0);
            if ((double)my > offset && (double)my < offset + 21.0) {
                this.draggingScroll = true;
            } else {
                this.scrollableOffset = class_3532.method_16436((double)(((double)my - 12.0) / 113.0), (double)0.0, (double)this.excessHeight);
                this.updateTextHeight();
            }
        }
        return this.textRender.click(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.draggingScroll) {
            this.draggingScroll = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (this.draggingScroll) {
            if (this.scrollable) {
                this.scrollableOffset += deltaY * (this.excessHeight / 104.0);
                this.scrollableOffset = class_3532.method_15350((double)this.scrollableOffset, (double)0.0, (double)this.excessHeight);
                this.updateTextHeight();
                return true;
            }
            this.draggingScroll = false;
            return false;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (this.scrollable) {
            this.scrollableOffset -= amount * 4.0;
            this.scrollableOffset = class_3532.method_15350((double)this.scrollableOffset, (double)0.0, (double)this.excessHeight);
            this.updateTextHeight();
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        this.searchBar.method_1865();
    }

    public void onHidden(GuiBookEntry parent) {
        super.onHidden(parent);
        parent.removeDrawablesIf(d -> d.equals(this.searchBar));
        this.searchBar = null;
    }

    public boolean shouldRenderText() {
        return false;
    }
}

