/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

@Mixin(value={GuiBookLanding.class}, remap=false)
public class GuiBookLandingMixin
extends GuiBook {
    @Shadow
    List<BookEntry> entriesInPamphlet;
    @Shadow
    @Nullable
    BookTextRenderer text;
    @Unique
    List<BookEntry> capturedEntriesInPamphlet;
    @Unique
    BookTextRenderer capuredText;
    @Unique
    Book capturedBook;
    @Unique
    private BookEntry dummyEntry;
    @Unique
    private int entryX = 0;

    public GuiBookLandingMixin(Book book, class_2561 title) {
        super(book, title);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void captureBook(Book book, CallbackInfo ci) {
        this.capturedBook = book;
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            JsonObject dummyJson = new JsonObject();
            dummyJson.add("name", (JsonElement)new JsonPrimitive(""));
            dummyJson.add("category", (JsonElement)new JsonPrimitive("seasonsextras:compendium"));
            dummyJson.add("icon", (JsonElement)new JsonPrimitive("minecraft:air"));
            dummyJson.add("pages", (JsonElement)new JsonArray());
            dummyJson.add("read_by_default", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            this.dummyEntry = new BookEntry(dummyJson, new class_2960(""), this.capturedBook);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"init"}, remap=true)
    public void captureText(CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            this.capuredText = this.text;
            if (this.spread != 0) {
                this.text = null;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"buildEntryButtons"})
    public void addDummySpaces(CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            if (this.capturedEntriesInPamphlet == null) {
                this.capturedEntriesInPamphlet = this.entriesInPamphlet;
            }
            this.entriesInPamphlet = new ArrayList<BookEntry>();
            this.entriesInPamphlet.add(this.dummyEntry);
            this.entriesInPamphlet.add(this.dummyEntry);
            this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(0));
            if (FabricSeasons.CONFIG.isSeasonMessingCrops()) {
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(1));
            }
            this.entriesInPamphlet.add(this.dummyEntry);
            this.entriesInPamphlet.add(this.dummyEntry);
            this.entriesInPamphlet.add(this.dummyEntry);
            if (FabricSeasons.CONFIG.isSeasonMessingCrops()) {
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(2));
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(3));
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(4));
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(5));
            }
            this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(6));
            this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(7));
            if (FabricSeasons.CONFIG.isSeasonMessingCrops()) {
                this.entriesInPamphlet.add(this.capturedEntriesInPamphlet.get(8));
            }
        }
    }

    @ModifyArgs(at=@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/GuiBookLanding;addEntryButtons(IIII)V"), method={"buildEntryButtons"})
    public void fixTopPadding(Args args) {
        int y = (Integer)args.get(1);
        int start = (Integer)args.get(2);
        int count = (Integer)args.get(3);
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            if (this.spread == 0) {
                args.set(1, (Object)(y + 3));
            }
            args.set(2, (Object)(start + 13 * this.spread));
            args.set(3, (Object)(count + 2));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/button/GuiButtonEntry;<init>(Lvazkii/patchouli/client/book/gui/GuiBook;IILvazkii/patchouli/client/book/BookEntry;Lnet/minecraft/client/gui/widget/ButtonWidget$PressAction;)V", shift=At.Shift.BEFORE, remap=true)}, method={"addEntryButtons"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void collectEntry(int x, int y, int start, int count, CallbackInfo ci, int i) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            this.entryX = this.spread != 0 && i - start < 13 ? this.bookLeft + 15 : this.bookLeft + 141;
        }
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/button/GuiButtonEntry;<init>(Lvazkii/patchouli/client/book/gui/GuiBook;IILvazkii/patchouli/client/book/BookEntry;Lnet/minecraft/client/gui/widget/ButtonWidget$PressAction;)V", remap=true), method={"addEntryButtons"}, index=1)
    public int fixEntryX(int x) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            return this.entryX;
        }
        return x;
    }

    @Inject(at={@At(value="TAIL")}, method={"addEntryButtons"})
    public void fixDummySpaces(int x, int y, int start, int count, CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            this.removeDrawablesIf(drawable -> {
                GuiButtonEntry entry;
                return drawable instanceof GuiButtonEntry && (entry = (GuiButtonEntry)drawable).getEntry() == this.dummyEntry;
            });
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/GuiBookLanding;addEntryButtons(IIII)V")}, method={"buildEntryButtons"})
    public void addPageButton(CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            this.maxSpreads = (int)Math.ceil((float)(13 + this.entriesInPamphlet.size()) / 26.0f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onPageChanged"})
    public void fixText(CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            this.text = this.spread == 0 ? this.capuredText : null;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/GuiBookLanding;drawFromTexture(Lnet/minecraft/client/util/math/MatrixStack;Lvazkii/patchouli/common/book/Book;IIIIII)V", remap=true)}, method={"drawHeader"}, cancellable=true)
    public void drawExtraHeaders(class_4587 ms, CallbackInfo ci) {
        if (this.capturedBook.id.equals((Object)new ModIdentifier("seasonal_compendium"))) {
            if (this.spread == 0) {
                int color = this.book.nameplateColor;
                GuiBookLandingMixin.drawFromTexture((class_4587)ms, (Book)this.book, (int)140, (int)12, (int)0, (int)211, (int)140, (int)31);
                this.field_22793.method_30883(ms, (class_2561)class_2561.method_43471((String)"patchouli.seasonsextras.modifications"), 161.0f, 16.0f, color);
                this.field_22793.method_30883(ms, (class_2561)class_2561.method_43471((String)"patchouli.seasonsextras.modifications_info").method_27696(this.book.getFontStyle()), 161.0f, 24.0f, color);
                int cropOffset = FabricSeasons.CONFIG.isSeasonMessingCrops() ? 0 : -10;
                GuiBookLandingMixin.drawFromTexture((class_4587)ms, (Book)this.book, (int)140, (int)(69 + cropOffset), (int)0, (int)211, (int)140, (int)31);
                this.field_22793.method_30883(ms, (class_2561)class_2561.method_43471((String)"patchouli.seasonsextras.resources"), 161.0f, (float)(73 + cropOffset), color);
                this.field_22793.method_30883(ms, (class_2561)class_2561.method_43471((String)"patchouli.seasonsextras.resources_info").method_27696(this.book.getFontStyle()), 161.0f, (float)(81 + cropOffset), color);
            } else {
                ci.cancel();
            }
        }
    }
}

