/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.resources.CropConfigs;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.client.FabricSeasonsExtrasClient;
import io.github.lucaargolo.seasonsextras.patchouli.PatchouliModifications;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageBiomeDescription;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageBiomeSearch;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageCropSearch;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageMultipleCrafting;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageSeasonalBiome;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.text.BookTextParser;

public class FabricSeasonsExtrasPatchouliCompat {
    public static void onInitializeClient() {
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("biome_search"), PageBiomeSearch.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("seasonal_biome"), PageSeasonalBiome.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("biome_description"), PageBiomeDescription.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("crop_search"), PageCropSearch.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("multiple_crafting"), PageMultipleCrafting.class);
        BookTextParser.register((parameter, state) -> FabricSeasonsExtrasClient.prefersCelsius ? FabricSeasonsExtrasClient.minecraftToCelsius(parameter) : FabricSeasonsExtrasClient.minecraftToFahrenheit(parameter), (String[])new String[]{"seasonsextrastemperature"});
        BookTextParser.register((parameter, state) -> class_1074.method_4662((String)parameter, (Object[])new Object[0]), (String[])new String[]{"seasonsextrastranslate"});
        PatchouliModifications.registerEntry(new ModIdentifier("biomes"), new ModIdentifier("seasonal_biomes"), (pages, index) -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null) {
                class_5321 worldKey = world.method_27983();
                AtomicInteger offset = new AtomicInteger(0);
                ((Set)FabricSeasonsExtrasClient.worldValidBiomes.getOrDefault(worldKey, new HashSet())).forEach(entry -> FabricSeasonsExtrasPatchouliCompat.addSeasonalBiomePage(pages, index + offset.getAndAdd(2), (class_5321<class_1937>)worldKey, (class_6880<class_1959>)entry));
            }
        });
        PatchouliModifications.registerEntry(new ModIdentifier("crops"), new ModIdentifier("seasonal_crops"), (pages, index) -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null) {
                AtomicInteger offset = new AtomicInteger(0);
                FabricSeasons.SEEDS_MAP.entrySet().stream().map(entry -> Map.entry(entry, class_2378.field_11146.method_10221((Object)((class_2248)entry.getValue())))).sorted(Map.Entry.comparingByValue()).forEach(entry -> {
                    class_2960 seedId = class_2378.field_11142.method_10221((Object)((class_1792)((Map.Entry)entry.getKey()).getKey()));
                    class_2960 cropId = class_2378.field_11146.method_10221((Object)((class_2248)((Map.Entry)entry.getKey()).getValue()));
                    FabricSeasonsExtrasPatchouliCompat.addSeasonalCropPage(pages, index + offset.getAndAdd(1), (class_1792)((Map.Entry)entry.getKey()).getKey(), seedId, (class_2248)((Map.Entry)entry.getKey()).getValue(), cropId);
                });
            }
        });
    }

    private static void addSeasonalBiomePage(JsonArray pages, int index, class_5321<class_1937> worldKey, class_6880<class_1959> entry) {
        class_1959 biome = (class_1959)entry.comp_349();
        class_2960 biomeId = entry.method_40230().orElse(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("plains"))).method_29177();
        String biomeName = biomeId.method_42093("biome");
        boolean isJungle = entry.method_40220(class_6908.field_36516) || entry.method_40220(class_6908.field_37378);
        class_3545 springPair = FabricSeasons.getSeasonWeather((Season)Season.SPRING, (class_2960)biomeId, (boolean)isJungle, (class_1959.class_1963)biome.method_8694(), (float)biome.method_8712());
        class_3545 summerPair = FabricSeasons.getSeasonWeather((Season)Season.SUMMER, (class_2960)biomeId, (boolean)isJungle, (class_1959.class_1963)biome.method_8694(), (float)biome.method_8712());
        class_3545 fallPair = FabricSeasons.getSeasonWeather((Season)Season.FALL, (class_2960)biomeId, (boolean)isJungle, (class_1959.class_1963)biome.method_8694(), (float)biome.method_8712());
        class_3545 winterPair = FabricSeasons.getSeasonWeather((Season)Season.WINTER, (class_2960)biomeId, (boolean)isJungle, (class_1959.class_1963)biome.method_8694(), (float)biome.method_8712());
        ArrayList<Season> rainSeasons = new ArrayList<Season>();
        if (((class_1959.class_1963)springPair.method_15442()).equals((Object)class_1959.class_1963.field_9382)) {
            rainSeasons.add(Season.SPRING);
        }
        if (((class_1959.class_1963)summerPair.method_15442()).equals((Object)class_1959.class_1963.field_9382)) {
            rainSeasons.add(Season.SUMMER);
        }
        if (((class_1959.class_1963)fallPair.method_15442()).equals((Object)class_1959.class_1963.field_9382)) {
            rainSeasons.add(Season.FALL);
        }
        if (((class_1959.class_1963)winterPair.method_15442()).equals((Object)class_1959.class_1963.field_9382)) {
            rainSeasons.add(Season.WINTER);
        }
        ArrayList<Season> snowSeasons = new ArrayList<Season>();
        if (((class_1959.class_1963)springPair.method_15442()).equals((Object)class_1959.class_1963.field_9383)) {
            snowSeasons.add(Season.SPRING);
        }
        if (((class_1959.class_1963)summerPair.method_15442()).equals((Object)class_1959.class_1963.field_9383)) {
            snowSeasons.add(Season.SUMMER);
        }
        if (((class_1959.class_1963)fallPair.method_15442()).equals((Object)class_1959.class_1963.field_9383)) {
            snowSeasons.add(Season.FALL);
        }
        if (((class_1959.class_1963)winterPair.method_15442()).equals((Object)class_1959.class_1963.field_9383)) {
            snowSeasons.add(Season.WINTER);
        }
        String springTemperature = "$(seasonsextrastemperature:" + springPair.method_15441() + ")";
        String summerTemperature = "$(seasonsextrastemperature:" + summerPair.method_15441() + ")";
        String fallTemperature = "$(seasonsextrastemperature:" + fallPair.method_15441() + ")";
        String winterTemperature = "$(seasonsextrastemperature:" + winterPair.method_15441() + ")";
        StringBuilder rainInfo = new StringBuilder(rainSeasons.isEmpty() ? "$(seasonsextrastranslate:patchouli.seasonsextras.doesnotrain)" : "$(seasonsextrastranslate:patchouli.seasonsextras.rainsduring) ");
        if (rainSeasons.size() == 4) {
            rainInfo.append("$(seasonsextrastranslate:patchouli.seasonsextras.all_seasons)");
        } else {
            for (int i = 0; i < rainSeasons.size(); ++i) {
                Season season = (Season)rainSeasons.get(i);
                rainInfo.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
                if (i == rainSeasons.size() - 1) {
                    rainInfo.append("$(0).");
                    continue;
                }
                if (i == rainSeasons.size() - 2) {
                    rainInfo.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                    continue;
                }
                rainInfo.append("$(0), ");
            }
        }
        StringBuilder snowInfo = new StringBuilder(snowSeasons.isEmpty() ? "$(seasonsextrastranslate:patchouli.seasonsextras.doesnotsnow)" : "$(seasonsextrastranslate:patchouli.seasonsextras.snowsduring) ");
        if (snowSeasons.size() == 4) {
            snowInfo.append("$(seasonsextrastranslate:patchouli.seasonsextras.all_seasons)");
        } else {
            for (int i = 0; i < snowSeasons.size(); ++i) {
                Season season = (Season)snowSeasons.get(i);
                snowInfo.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
                if (i == snowSeasons.size() - 1) {
                    snowInfo.append("$(0).");
                    continue;
                }
                if (i == snowSeasons.size() - 2) {
                    snowInfo.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                    continue;
                }
                snowInfo.append("$(0), ");
            }
        }
        String biomeInfo = isJungle ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(2)$(seasonsextrastranslate:patchouli.seasonsextras.tropicalbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.tropicaldesc)" : ((double)((Float)springPair.method_15441()).floatValue() <= 0.1 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(3)$(seasonsextrastranslate:patchouli.seasonsextras.frozenbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.frozendesc)" : ((double)((Float)springPair.method_15441()).floatValue() <= 0.3 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(3)$(seasonsextrastranslate:patchouli.seasonsextras.coldbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.colddesc)" : ((double)((Float)springPair.method_15441()).floatValue() <= 0.95 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(2)$(seasonsextrastranslate:patchouli.seasonsextras.temperatebiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.temperatedesc)" : "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(4)$(seasonsextrastranslate:patchouli.seasonsextras.hotbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.hotdesc)")));
        JsonObject biomeFirstPage = new JsonObject();
        biomeFirstPage.add("type", (JsonElement)new JsonPrimitive("seasonsextras:biome_description"));
        biomeFirstPage.add("title", (JsonElement)new JsonPrimitive(biomeName));
        String biomeText = biomeInfo + "$(br2)$(2)$(seasonsextrastranslate:patchouli.seasonsextras.springtemp): $(0)" + springTemperature + "$(br)$(6)$(seasonsextrastranslate:patchouli.seasonsextras.summertemp): $(0)" + summerTemperature + "$(br)$(c)$(seasonsextrastranslate:patchouli.seasonsextras.falltemp): $(0)" + fallTemperature + "$(br)$(3)$(seasonsextrastranslate:patchouli.seasonsextras.wintertemp): $(0)" + winterTemperature + "$(br2)" + rainInfo + "$(br2)" + snowInfo;
        biomeFirstPage.add("text", (JsonElement)new JsonPrimitive(biomeText));
        biomeFirstPage.add("anchor", (JsonElement)new JsonPrimitive(biomeId.toString()));
        JsonObject biomeSecondPage = new JsonObject();
        biomeSecondPage.add("type", (JsonElement)new JsonPrimitive("seasonsextras:seasonal_biome"));
        biomeSecondPage.add("name", (JsonElement)new JsonPrimitive("Colors"));
        biomeSecondPage.add("enable_visualize", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        biomeSecondPage.add("biome_id", (JsonElement)new JsonPrimitive(biomeId.toString()));
        if (FabricSeasonsExtrasClient.worldBiomeMultiblocks.getOrDefault(worldKey, new HashMap()).containsKey(biomeId)) {
            JsonArray multiblocks = new JsonArray();
            ((Set)FabricSeasonsExtrasClient.worldBiomeMultiblocks.getOrDefault(worldKey, new HashMap()).get(biomeId)).forEach(treeId -> {
                JsonObject multiblock = FabricSeasonsExtrasClient.multiblocks.get(treeId);
                if (multiblock != null && multiblock.size() > 0) {
                    multiblocks.add((JsonElement)multiblock);
                }
            });
            biomeSecondPage.add("multiblocks", (JsonElement)multiblocks);
        }
        JsonArray oldPages = pages.deepCopy();
        FabricSeasonsExtrasPatchouliCompat.setOrAdd(pages, index, (JsonElement)biomeFirstPage);
        FabricSeasonsExtrasPatchouliCompat.setOrAdd(pages, index + 1, (JsonElement)biomeSecondPage);
        for (int i = index; i < oldPages.size(); ++i) {
            FabricSeasonsExtrasPatchouliCompat.setOrAdd(pages, index + 2 + (i - index), oldPages.get(i));
        }
    }

    private static void addSeasonalCropPage(JsonArray pages, int index, class_1792 seed, class_2960 seedId, class_2248 crop, class_2960 cropId) {
        float springMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.SPRING);
        float summerMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.SUMMER);
        float fallMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.FALL);
        float winterMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.WINTER);
        float maxMultiplier = Math.max(Math.max(springMultiplier, summerMultiplier), Math.max(fallMultiplier, winterMultiplier));
        ArrayList<Season> cropSeasons = new ArrayList<Season>();
        ArrayList<Season> alternateSeasons = new ArrayList<Season>();
        if (springMultiplier == maxMultiplier) {
            cropSeasons.add(Season.SPRING);
        } else {
            alternateSeasons.add(Season.SPRING);
        }
        if (summerMultiplier == maxMultiplier) {
            cropSeasons.add(Season.SUMMER);
        } else {
            alternateSeasons.add(Season.SUMMER);
        }
        if (fallMultiplier == maxMultiplier) {
            cropSeasons.add(Season.FALL);
        } else {
            alternateSeasons.add(Season.FALL);
        }
        if (winterMultiplier == maxMultiplier) {
            cropSeasons.add(Season.WINTER);
        } else {
            alternateSeasons.add(Season.WINTER);
        }
        StringBuilder cropText = new StringBuilder("$(seasonsextrastranslate:patchouli.seasonsextras.thisisacrop) ");
        for (int i = 0; i < cropSeasons.size(); ++i) {
            Season season = (Season)cropSeasons.get(i);
            cropText.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
            if (i == cropSeasons.size() - 1) {
                cropText.append("$(0) $(seasonsextrastranslate:patchouli.seasonsextras.crop). ");
                continue;
            }
            if (i == cropSeasons.size() - 2) {
                cropText.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                continue;
            }
            cropText.append("$(0), ");
        }
        if (cropSeasons.size() == 1) {
            cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.growsfasterduringthis)$(br2)");
        } else {
            cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.growsfasterduringthese)$(br2)");
        }
        for (Season season : alternateSeasons) {
            float multiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)season);
            if (multiplier == 0.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.notgrowduring) ");
            } else if (multiplier < 1.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.slowedgrowduring) ");
            } else if (multiplier == 1.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.normalgrowduring) ");
            } else {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.fastergrowduring) ");
            }
            cropText.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")$(0)");
            cropText.append("$(br)");
        }
        cropText.append("$(br)");
        cropText.append("$(").append(Season.SPRING.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.SPRING.getTranslationKey()).append(")$(0): ").append(springMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.SUMMER.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.SUMMER.getTranslationKey()).append(")$(0): ").append(summerMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.FALL.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.FALL.getTranslationKey()).append(")$(0): ").append(fallMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.WINTER.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.WINTER.getTranslationKey()).append(")$(0): ").append(winterMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        JsonObject biomeFirstPage = new JsonObject();
        biomeFirstPage.add("type", (JsonElement)new JsonPrimitive("patchouli:spotlight"));
        biomeFirstPage.add("item", (JsonElement)new JsonPrimitive(seedId.toString()));
        biomeFirstPage.add("title", (JsonElement)new JsonPrimitive(crop.method_9539()));
        biomeFirstPage.add("text", (JsonElement)new JsonPrimitive(cropText.toString()));
        biomeFirstPage.add("anchor", (JsonElement)new JsonPrimitive(cropId.toString()));
        JsonArray oldPages = pages.deepCopy();
        FabricSeasonsExtrasPatchouliCompat.setOrAdd(pages, index, (JsonElement)biomeFirstPage);
        for (int i = index; i < oldPages.size(); ++i) {
            FabricSeasonsExtrasPatchouliCompat.setOrAdd(pages, index + 1 + (i - index), oldPages.get(i));
        }
    }

    private static void setOrAdd(JsonArray array, int index, JsonElement element) {
        if (index == array.size()) {
            array.add(element);
        } else {
            array.set(index, element);
        }
    }
}

