/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import io.github.lucaargolo.seasonsextras.block.GreenhouseGlassBlock;
import io.github.lucaargolo.seasonsextras.client.screen.AirConditioningScreen;
import io.github.lucaargolo.seasonsextras.patchouli.FabricSeasonsExtrasPatchouliCompat;
import io.github.lucaargolo.seasonsextras.patchouli.mixin.GuiBookEntryAccessor;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import io.github.lucaargolo.seasonsextras.utils.Tickable;
import io.github.lucaargolo.seasonsextras.utils.TooltipRenderer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import vazkii.patchouli.client.book.BookPage;

public class FabricSeasonsExtrasClient
implements ClientModInitializer {
    public static class_5321<class_1959> multiblockBiomeOverride = null;
    public static Season multiblockSeasonOverride = null;
    public static final HashMap<class_5321<class_1937>, Set<class_6880<class_1959>>> worldValidBiomes = new HashMap();
    public static final HashMap<class_5321<class_1937>, HashMap<class_2960, Set<class_2960>>> worldBiomeMultiblocks = new HashMap();
    public static HashMap<class_2960, JsonObject> multiblocks = new HashMap();
    public static boolean prefersCelsius = true;
    public static final List<class_2561> testedTooltip = new ArrayList<class_2561>();
    public static class_2338 testedPos = null;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtras.SEND_TESTED_SEASON_S2C, (client, handler, buf, responseSender) -> {
            class_2338 receivedTestedPos = buf.method_10811();
            ArrayList<class_2561> receivedTooltip = new ArrayList<class_2561>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                receivedTooltip.add(buf.method_10808());
            }
            client.execute(() -> {
                testedPos = receivedTestedPos;
                testedTooltip.clear();
                testedTooltip.addAll(receivedTooltip);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtras.SEND_VALID_BIOMES_S2C, (client, handler, buf, responseSender) -> {
            HashSet<class_2960> validBiomes = new HashSet<class_2960>();
            class_2960 worldId = buf.method_10810();
            class_5321 worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId);
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                validBiomes.add(buf.method_10810());
            }
            client.execute(() -> {
                worldValidBiomes.computeIfPresent((class_5321<class_1937>)worldKey, (key, list) -> new LinkedHashSet());
                validBiomes.stream().sorted(Comparator.comparing(class_2960::method_12832)).forEach(biome -> handler.method_29091().method_30530(class_2378.field_25114).method_40264(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)biome)).ifPresent(entry -> worldValidBiomes.computeIfAbsent((class_5321<class_1937>)worldKey, key -> new LinkedHashSet()).add(entry)));
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtras.SEND_BIOME_MULTIBLOCKS_S2C, (client, handler, buf, responseSender) -> {
            HashMap biomeMultiblocks = new HashMap();
            class_2960 worldId = buf.method_10810();
            class_5321 worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId);
            int mapSize = buf.readInt();
            for (int m = 0; m < mapSize; ++m) {
                HashSet<class_2960> set = new HashSet<class_2960>();
                class_2960 biomeId = buf.method_10810();
                int setSize = buf.readInt();
                for (int s = 0; s < setSize; ++s) {
                    set.add(buf.method_10810());
                }
                biomeMultiblocks.put(biomeId, set);
            }
            client.execute(() -> worldBiomeMultiblocks.put((class_5321<class_1937>)worldKey, biomeMultiblocks));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtras.SEND_MULTIBLOCKS_S2C, (client, handler, buf, responseSender) -> {
            HashMap<class_2960, JsonObject> serverMultiblocks = new HashMap<class_2960, JsonObject>();
            int size = buf.readInt();
            for (int m = 0; m < size; ++m) {
                serverMultiblocks.put(buf.method_10810(), JsonParser.parseString((String)buf.method_19772()).getAsJsonObject());
            }
            client.execute(() -> {
                multiblocks = serverMultiblocks;
            });
        });
        class_5272.method_27879((class_1792)FabricSeasonsExtras.SEASON_CALENDAR_ITEM, (class_2960)new class_2960("season"), (itemStack, clientWorld, livingEntity, seed) -> {
            class_1309 entity;
            Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
            if (entity == null) {
                return 0.0f;
            }
            if (clientWorld == null && entity.field_6002 instanceof class_638) {
                clientWorld = (class_638)entity.field_6002;
            }
            if (clientWorld == null) {
                return 0.0f;
            }
            return (float)FabricSeasons.getCurrentSeason((class_1937)clientWorld).ordinal() / 4.0f;
        });
        class_5272.method_27879((class_1792)FabricSeasonsExtras.SEASON_CALENDAR_ITEM, (class_2960)new class_2960("progress"), (itemStack, clientWorld, livingEntity, seed) -> {
            class_1309 entity;
            Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
            if (entity == null) {
                return 0.0f;
            }
            if (clientWorld == null && entity.field_6002 instanceof class_638) {
                clientWorld = (class_638)entity.field_6002;
            }
            if (clientWorld == null) {
                return 0.0f;
            }
            long timeToNextSeason = FabricSeasons.getTimeToNextSeason((class_1937)clientWorld);
            double progressLeft = (double)timeToNextSeason / (double)FabricSeasons.getCurrentSeason((class_1937)clientWorld).getSeasonLength();
            return (float)((int)(16.0 - progressLeft * 16.0) % 16) / 16.0f;
        });
        class_3929.method_17542(FabricSeasonsExtras.AIR_CONDITIONING_SCREEN_HANDLER, AirConditioningScreen::new);
        for (GreenhouseGlassBlock block : FabricSeasonsExtras.GREENHOUSE_GLASS_BLOCKS) {
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block, class_1921.method_23583());
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)class_2378.field_11146.method_10223((class_2960)new ModIdentifier("season_calendar")), class_1921.method_23581());
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {
            class_310 client = class_310.method_1551();
            TooltipRenderer.render(client, matrixStack, tickDelta);
        });
        if (FabricLoader.getInstance().isModLoaded("patchouli")) {
            FabricSeasonsExtrasPatchouliCompat.onInitializeClient();
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1755 == null) {
                    multiblockBiomeOverride = null;
                    multiblockSeasonOverride = null;
                } else {
                    class_437 patt8602$temp = client.field_1755;
                    if (patt8602$temp instanceof GuiBookEntryAccessor) {
                        BookPage patt8845$temp;
                        Tickable page;
                        GuiBookEntryAccessor bookEntry = (GuiBookEntryAccessor)patt8602$temp;
                        BookPage patt8698$temp = bookEntry.getLeftPage();
                        if (patt8698$temp instanceof Tickable) {
                            page = (Tickable)patt8698$temp;
                            page.tick();
                        }
                        if ((patt8845$temp = bookEntry.getRightPage()) instanceof Tickable) {
                            page = (Tickable)patt8845$temp;
                            page.tick();
                        }
                    }
                }
            });
        }
    }

    private static double minecraftToCelsius(float x) {
        return 1.02557113 * (double)x * (double)x * (double)x * (double)x - 2.5249755 * (double)x * (double)x * (double)x + 0.61120004 * (double)x * (double)x + 28.51377 * (double)x - 4.2984804;
    }

    public static String minecraftToCelsius(String string) {
        float x = Float.parseFloat(string);
        return BigDecimal.valueOf(FabricSeasonsExtrasClient.minecraftToCelsius(x)).setScale(1, RoundingMode.HALF_UP).doubleValue() + "\u00b0C";
    }

    public static String minecraftToFahrenheit(String string) {
        float x = Float.parseFloat(string);
        return BigDecimal.valueOf(FabricSeasonsExtrasClient.minecraftToCelsius(x) * 1.8 + 32.0).setScale(1, RoundingMode.HALF_UP).doubleValue() + "\u00b0F";
    }
}

