/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasonsextras.block.AirConditioningBlock;
import io.github.lucaargolo.seasonsextras.block.GreenhouseGlassBlock;
import io.github.lucaargolo.seasonsextras.block.SeasonCalendarBlock;
import io.github.lucaargolo.seasonsextras.block.SeasonDetectorBlock;
import io.github.lucaargolo.seasonsextras.blockentities.AirConditioningBlockEntity;
import io.github.lucaargolo.seasonsextras.blockentities.GreenhouseGlassBlockEntity;
import io.github.lucaargolo.seasonsextras.blockentities.SeasonCalendarBlockEntity;
import io.github.lucaargolo.seasonsextras.blockentities.SeasonDetectorBlockEntity;
import io.github.lucaargolo.seasonsextras.item.AirConditioningItem;
import io.github.lucaargolo.seasonsextras.item.CropSeasonTesterItem;
import io.github.lucaargolo.seasonsextras.item.GreenHouseGlassItem;
import io.github.lucaargolo.seasonsextras.item.SeasonCalendarItem;
import io.github.lucaargolo.seasonsextras.item.SeasonDetectorItem;
import io.github.lucaargolo.seasonsextras.item.SeasonalCompendiumItem;
import io.github.lucaargolo.seasonsextras.patchouli.PatchouliMultiblockCreator;
import io.github.lucaargolo.seasonsextras.screenhandlers.AirConditioningScreenHandler;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricSeasonsExtras
implements ModInitializer {
    private static final HashMap<class_2960, JsonObject> multiblockCache = new HashMap();
    public static final String MOD_ID = "seasonsextras";
    public static class_2591<SeasonDetectorBlockEntity> SEASON_DETECTOR_TYPE = null;
    public static class_2591<SeasonCalendarBlockEntity> SEASON_CALENDAR_TYPE = null;
    public static class_2591<GreenhouseGlassBlockEntity> GREENHOUSE_GLASS_TYPE = null;
    public static class_2591<AirConditioningBlockEntity> AIR_CONDITIONING_TYPE = null;
    public static SeasonCalendarBlock SEASON_CALENDAR_BLOCK;
    public static GreenhouseGlassBlock[] GREENHOUSE_GLASS_BLOCKS;
    public static ModIdentifier SEASONAL_COMPENDIUM_ITEM_ID;
    public static class_1792 SEASON_CALENDAR_ITEM;
    public static class_3917<AirConditioningScreenHandler> AIR_CONDITIONING_SCREEN_HANDLER;
    public static ModIdentifier SEND_VALID_BIOMES_S2C;
    public static ModIdentifier SEND_BIOME_MULTIBLOCKS_S2C;
    public static ModIdentifier SEND_MULTIBLOCKS_S2C;
    public static ModIdentifier SEND_TESTED_SEASON_S2C;
    public static ModIdentifier SEND_MODULE_PRESS_C2S;
    public static final class_1761 CREATIVE_TAB;

    public void onInitialize() {
        for (class_1767 value : class_1767.values()) {
            GreenhouseGlassBlock greenhouseGlass = (GreenhouseGlassBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier(value.method_7792() + "_greenhouse_glass"), (Object)((Object)new GreenhouseGlassBlock(false, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10357)))));
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier(value.method_7792() + "_greenhouse_glass"), (Object)((Object)new GreenHouseGlassItem(greenhouseGlass, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
            FabricSeasonsExtras.GREENHOUSE_GLASS_BLOCKS[value.ordinal()] = greenhouseGlass;
        }
        GreenhouseGlassBlock tintedGreenhouseGlass = (GreenhouseGlassBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("tinted_greenhouse_glass"), (Object)((Object)new GreenhouseGlassBlock(true, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_27115)))));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("tinted_greenhouse_glass"), (Object)((Object)new GreenHouseGlassItem(tintedGreenhouseGlass, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        FabricSeasonsExtras.GREENHOUSE_GLASS_BLOCKS[16] = tintedGreenhouseGlass;
        GREENHOUSE_GLASS_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("greenhouse_glass"), (Object)FabricBlockEntityTypeBuilder.create(GreenhouseGlassBlockEntity::new, (class_2248[])GREENHOUSE_GLASS_BLOCKS).build(null));
        AirConditioningBlock heaterBlock = (AirConditioningBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("heater"), (Object)((Object)new AirConditioningBlock(AirConditioningBlockEntity.Conditioning.HEATER, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10445).luminance(state -> (Integer)state.method_11654(AirConditioningBlock.LEVEL) * 5)))));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("heater"), (Object)((Object)new AirConditioningItem(heaterBlock, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        AirConditioningBlock chillerBlock = (AirConditioningBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("chiller"), (Object)((Object)new AirConditioningBlock(AirConditioningBlockEntity.Conditioning.CHILLER, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10085).luminance(state -> (Integer)state.method_11654(AirConditioningBlock.LEVEL) * 5)))));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("chiller"), (Object)((Object)new AirConditioningItem(chillerBlock, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        AIR_CONDITIONING_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("air_conditioning"), (Object)FabricBlockEntityTypeBuilder.create(AirConditioningBlockEntity::new, (class_2248[])new class_2248[]{heaterBlock, chillerBlock}).build(null));
        AIR_CONDITIONING_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_2378.field_17429, (class_2960)new ModIdentifier("air_conditioning_screen"), (Object)new ExtendedScreenHandlerType((syncId, playerInventory, buf) -> new AirConditioningScreenHandler(syncId, playerInventory, class_3914.method_17392((class_1937)playerInventory.field_7546.field_6002, (class_2338)buf.method_10811()), (class_2248)buf.method_42064((class_2359)class_2378.field_11146))));
        SeasonDetectorBlock seasonDetector = (SeasonDetectorBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("season_detector"), (Object)((Object)new SeasonDetectorBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10429)))));
        SEASON_DETECTOR_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("season_detector"), (Object)FabricBlockEntityTypeBuilder.create(seasonDetector::createBlockEntity, (class_2248[])new class_2248[]{seasonDetector}).build(null));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("season_detector"), (Object)((Object)new SeasonDetectorItem(seasonDetector, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        SEASON_CALENDAR_BLOCK = (SeasonCalendarBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("season_calendar"), (Object)((Object)new SeasonCalendarBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10161)))));
        SEASON_CALENDAR_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("season_calendar"), (Object)FabricBlockEntityTypeBuilder.create(SEASON_CALENDAR_BLOCK::createBlockEntity, (class_2248[])new class_2248[]{SEASON_CALENDAR_BLOCK}).build(null));
        SEASON_CALENDAR_ITEM = (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("season_calendar"), (Object)((Object)new SeasonCalendarItem((class_2248)SEASON_CALENDAR_BLOCK, new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)SEASONAL_COMPENDIUM_ITEM_ID, (Object)((Object)new SeasonalCompendiumItem(new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("crop_season_tester"), (Object)((Object)new CropSeasonTesterItem(new class_1792.class_1793().method_7892(CREATIVE_TAB))));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> FabricSeasonsExtras.sendValidBiomes(server, handler.field_14140));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SEND_MODULE_PRESS_C2S, (server, player, handler, buf, sender) -> {
            int button = buf.readInt();
            server.execute(() -> {
                class_1703 patt9725$temp = player.field_7512;
                if (patt9725$temp instanceof AirConditioningScreenHandler) {
                    AirConditioningScreenHandler screenHandler = (AirConditioningScreenHandler)patt9725$temp;
                    screenHandler.cycleButton(button);
                }
            });
        });
        ItemStorage.SIDED.registerForBlockEntity((entity, direction) -> {
            InventoryStorage inputStorage = InventoryStorage.of((class_1263)entity.getInputInventory(), (class_2350)direction);
            Storage moduleStorage = FilteringStorage.extractOnlyOf((Storage)InventoryStorage.of((class_1263)entity.getModuleInventory(), (class_2350)direction));
            return new CombinedStorage(List.of(inputStorage, moduleStorage));
        }, AIR_CONDITIONING_TYPE);
        ResourceConditions.register((class_2960)new ModIdentifier("is_season_messing_crops"), json -> FabricSeasons.CONFIG.isSeasonMessingCrops());
    }

    public static void sendValidBiomes(MinecraftServer server, @Nullable class_3222 player) {
        boolean generateMultiblocks;
        boolean bl = generateMultiblocks = player == null;
        if (generateMultiblocks) {
            multiblockCache.clear();
        }
        server.method_3738().forEach(serverWorld -> {
            if (FabricSeasons.CONFIG.isValidInDimension(serverWorld.method_27983())) {
                HashSet<class_6880<class_1959>> validBiomes = new HashSet<class_6880<class_1959>>();
                serverWorld.method_14178().method_12129().method_12098().method_28443().forEach(entry -> entry.method_40230().ifPresent(key -> validBiomes.add((class_6880<class_1959>)entry)));
                class_2540 buf = PacketByteBufs.create();
                buf.method_10812(serverWorld.method_27983().method_29177());
                buf.writeInt(validBiomes.size());
                validBiomes.stream().map(r -> ((class_5321)r.method_40230().get()).method_29177()).forEach(arg_0 -> ((class_2540)buf).method_10812(arg_0));
                if (player != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_VALID_BIOMES_S2C, (class_2540)buf);
                } else {
                    server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_2960)SEND_VALID_BIOMES_S2C, (class_2540)buf));
                }
                FabricSeasonsExtras.sendBiomeMultiblocks(server, player, serverWorld, validBiomes);
            }
        });
        FabricSeasonsExtras.sendMultiblocks(server, player);
    }

    private static void sendBiomeMultiblocks(MinecraftServer server, @Nullable class_3222 player, class_3218 serverWorld, Set<class_6880<class_1959>> validBiomes) {
        class_2960 worldId = serverWorld.method_27983().method_29177();
        HashMap<class_2960, HashSet> biomeToMultiblocks = new HashMap<class_2960, HashSet>();
        validBiomes.forEach(entry -> {
            class_2960 biomeId = ((class_5321)entry.method_40230().get()).method_29177();
            List validFeatures = (List)((class_1959)entry.comp_349()).method_30970().method_30983().stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(c -> c.comp_332() instanceof class_2944).collect(ImmutableList.toImmutableList());
            for (class_2975 cf : validFeatures) {
                class_2960 cfId = server.method_30611().method_30530(class_2378.field_25914).method_10221((Object)cf);
                if (cfId == null) continue;
                if (!multiblockCache.containsKey(cfId)) {
                    PatchouliMultiblockCreator creator = new PatchouliMultiblockCreator(serverWorld, class_2246.field_10219.method_9564(), class_2246.field_10479.method_9564(), new class_2338(-100, -100, -100), c -> cf.method_12862((class_5281)c.getFakeWorld(), serverWorld.method_14178().method_12129(), class_5819.method_43049((long)0L), new class_2338(100, 100, 100)));
                    Optional<JsonObject> optional = creator.getMultiblock(set -> {
                        boolean foundLeave = false;
                        boolean foundLog = false;
                        Iterator iterator = set.iterator();
                        while (!(!iterator.hasNext() || foundLeave && foundLog)) {
                            class_2680 state = (class_2680)iterator.next();
                            if (state.method_26164(class_3481.field_15503)) {
                                foundLeave = true;
                            }
                            if (!state.method_26164(class_3481.field_15475)) continue;
                            foundLog = true;
                        }
                        return foundLeave && foundLog;
                    });
                    optional.ifPresent(o -> {
                        multiblockCache.put(cfId, (JsonObject)o);
                        biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet()).add(cfId);
                    });
                    continue;
                }
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet()).add(cfId);
            }
            ModIdentifier empty = new ModIdentifier("empty");
            if (multiblockCache.containsKey((Object)empty)) {
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet<class_2960>(Collections.singleton(empty)));
            } else {
                PatchouliMultiblockCreator creator = new PatchouliMultiblockCreator(serverWorld, class_2246.field_10102.method_9564(), class_2246.field_10428.method_9564(), new class_2338(0, 0, 0), c -> {});
                JsonObject emptyMultiblock = creator.getMultiblock(set -> true).get();
                multiblockCache.put(empty, emptyMultiblock);
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet<class_2960>(Collections.singleton(empty)));
            }
        });
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(worldId);
        buf.writeInt(biomeToMultiblocks.size());
        biomeToMultiblocks.forEach((identifier, set) -> {
            buf.method_10812(identifier);
            buf.writeInt(set.size());
            set.forEach(arg_0 -> ((class_2540)buf).method_10812(arg_0));
        });
        if (player != null) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_BIOME_MULTIBLOCKS_S2C, (class_2540)buf);
        } else {
            server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_2960)SEND_BIOME_MULTIBLOCKS_S2C, (class_2540)buf));
        }
    }

    private static void sendMultiblocks(MinecraftServer server, @Nullable class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(multiblockCache.size());
        multiblockCache.forEach((identifier, jsonObject) -> {
            buf.method_10812(identifier);
            String string = jsonObject.toString();
            if (string.length() > Short.MAX_VALUE) {
                buf.method_10814("{}");
            } else {
                buf.method_10814(string);
            }
        });
        if (player != null) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_MULTIBLOCKS_S2C, (class_2540)buf);
        } else {
            server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_2960)SEND_MULTIBLOCKS_S2C, (class_2540)buf));
        }
    }

    static {
        GREENHOUSE_GLASS_BLOCKS = new GreenhouseGlassBlock[17];
        SEASONAL_COMPENDIUM_ITEM_ID = new ModIdentifier("seasonal_compendium");
        SEND_VALID_BIOMES_S2C = new ModIdentifier("send_valid_biomes_s2c");
        SEND_BIOME_MULTIBLOCKS_S2C = new ModIdentifier("send_biome_multiblocks_s2c");
        SEND_MULTIBLOCKS_S2C = new ModIdentifier("send_multiblocks_s2c");
        SEND_TESTED_SEASON_S2C = new ModIdentifier("send_tested_season_s2c");
        SEND_MODULE_PRESS_C2S = new ModIdentifier("send_module_press_c2s");
        CREATIVE_TAB = FabricItemGroupBuilder.create((class_2960)new ModIdentifier("creative_tab")).icon(() -> SEASON_CALENDAR_ITEM.method_7854()).build();
    }
}

