/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.compat.PermissionsCompat;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.PacketIdentifiers;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class YigdCommand {
    public static void registerCommands() {
        YigdConfig.CommandToggles config = YigdConfig.getConfig().commandToggles;
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)config.coreCommandName).executes(ctx -> YigdCommand.viewGrave(((class_2168)ctx.getSource()).method_44023(), ((class_2168)ctx.getSource()).method_44023()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").requires(source -> YigdCommand.hasPermission(source, "yigd.command.restore") && config.retrieveGrave)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
            int posX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int posY = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            int posZ = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z");
            class_2960 worldId = class_2181.method_9289((CommandContext)ctx, (String)"dim").method_27983().method_29177();
            class_2338 pos = new class_2338(posX, posY, posZ);
            UUID graveId = YigdCommand.posToId(pos, worldId, player.method_5667());
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.restoreGrave((class_1657)player, commandUser, graveId);
            }
            return YigdCommand.restoreGrave((class_1657)player, null, graveId);
        }))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
            int posX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int posY = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            int posZ = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z");
            class_2960 worldId = player.field_6002.method_27983().method_29177();
            class_2338 pos = new class_2338(posX, posY, posZ);
            UUID graveId = YigdCommand.posToId(pos, worldId, player.method_5667());
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.restoreGrave((class_1657)player, commandUser, graveId);
            }
            return YigdCommand.restoreGrave((class_1657)player, null, graveId);
        }))))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.restoreGrave((class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), commandUser, null);
            }
            return YigdCommand.restoreGrave((class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"), null, null);
        }))).executes(ctx -> YigdCommand.restoreGrave((class_1657)((class_2168)ctx.getSource()).method_44023(), ((class_2168)ctx.getSource()).method_44023(), null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rob").requires(source -> YigdCommand.hasPermission(source, "yigd.command.rob") && config.robGrave)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"victim", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(ctx -> {
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"victim");
            int posX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int posY = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            int posZ = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z");
            class_2960 worldId = class_2181.method_9289((CommandContext)ctx, (String)"dim").method_27983().method_29177();
            class_2338 pos = new class_2338(posX, posY, posZ);
            UUID graveId = YigdCommand.posToId(pos, worldId, player.method_5667());
            return YigdCommand.robGrave(player.method_7334(), ((class_2168)ctx.getSource()).method_44023(), graveId);
        }))).executes(ctx -> {
            class_3222 commandUser = ((class_2168)ctx.getSource()).method_44023();
            if (commandUser == null) {
                return -1;
            }
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"victim");
            int posX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int posY = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            int posZ = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z");
            class_2960 worldId = commandUser.field_6002.method_27983().method_29177();
            class_2338 pos = new class_2338(posX, posY, posZ);
            UUID graveId = YigdCommand.posToId(pos, worldId, player.method_5667());
            return YigdCommand.robGrave(player.method_7334(), commandUser, graveId);
        }))))).executes(ctx -> YigdCommand.robGrave(class_2186.method_9315((CommandContext)ctx, (String)"victim").method_7334(), ((class_2168)ctx.getSource()).method_44023(), null))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"grave").requires(source -> config.selfView || YigdCommand.hasPermission(source, "yigd.command.view"))).executes(ctx -> YigdCommand.viewGrave(((class_2168)ctx.getSource()).method_44023(), ((class_2168)ctx.getSource()).method_44023()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> YigdCommand.hasPermission(source, "yigd.command.view") && config.adminView)).executes(ctx -> YigdCommand.viewGrave(class_2186.method_9315((CommandContext)ctx, (String)"player"), ((class_2168)ctx.getSource()).method_44023()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"moderate").requires(source -> YigdCommand.hasPermission(source, "yigd.command.moderate") && config.moderateGraves)).executes(ctx -> YigdCommand.moderateGraves(((class_2168)ctx.getSource()).method_44023())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(source -> YigdCommand.hasPermission(source, "yigd.command.clear") && config.clearGraveBackups)).then(class_2170.method_9244((String)"victim", (ArgumentType)class_2186.method_9308()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.clearBackup(class_2186.method_9312((CommandContext)ctx, (String)"victim"), commandUser);
            }
            return YigdCommand.clearBackup(class_2186.method_9312((CommandContext)ctx, (String)"victim"), null);
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").requires(source -> YigdCommand.hasPermission(source, "yigd.command.whitelist") && config.whitelist)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> config.whitelistAdd)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.addWhitelist(commandUser, (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"));
            }
            return YigdCommand.addWhitelist(null, (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"));
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> config.whitelistRemove)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.removeWhitelist(commandUser, (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"));
            }
            return YigdCommand.removeWhitelist(null, (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"));
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").requires(source -> config.whitelistToggle)).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_1297 entity = src.method_9228();
            if (entity instanceof class_3222) {
                class_3222 commandUser = (class_3222)entity;
                return YigdCommand.toggleWhitelist(commandUser);
            }
            return YigdCommand.toggleWhitelist(null);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"coordinates").requires(source -> config.coordinateToggle)).executes(ctx -> YigdCommand.showGraveCoordinates((class_1657)((class_2168)ctx.getSource()).method_44023())))));
    }

    private static int showGraveCoordinates(class_1657 commandUser) {
        if (!YigdConfig.getConfig().commandToggles.coordinateToggle) {
            commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission"), false);
            return -1;
        }
        List<DeadPlayerData> data = DeathInfoManager.INSTANCE.data.get(commandUser.method_5667());
        if (data != null && data.size() > 0) {
            DeadPlayerData graveData = data.get(data.size() - 1);
            commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.grave_location_info", (Object[])new Object[]{graveData.gravePos.method_10263(), graveData.gravePos.method_10264(), graveData.gravePos.method_10260(), graveData.dimensionName}), false);
            return 1;
        }
        return 0;
    }

    private static int addWhitelist(@Nullable class_3222 commandUser, class_1657 addedPlayer) {
        if (commandUser != null && !YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.whitelist") || !YigdConfig.getConfig().commandToggles.whitelistAdd) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        DeathInfoManager.INSTANCE.addToWhiteList(addedPlayer.method_5667());
        if (commandUser != null) {
            commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.whitelist.added_player", (Object[])new Object[]{addedPlayer.method_5476().getString()}), false);
        }
        return 1;
    }

    private static int removeWhitelist(@Nullable class_3222 commandUser, class_1657 removedPlayer) {
        if (commandUser != null && !YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.whitelist") || !YigdConfig.getConfig().commandToggles.whitelistRemove) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        DeathInfoManager.INSTANCE.removeFromWhiteList(removedPlayer.method_5667());
        if (commandUser != null) {
            commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.whitelist.removed_player", (Object[])new Object[]{removedPlayer.method_5476().getString()}), false);
        }
        return 1;
    }

    private static int toggleWhitelist(@Nullable class_3222 commandUser) {
        if (commandUser != null && !YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.whitelist") || !YigdConfig.getConfig().commandToggles.whitelistToggle) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        boolean toggledTo = DeathInfoManager.INSTANCE.toggleListMode();
        if (commandUser != null) {
            commandUser.method_7353((class_2561)class_2561.method_43471((String)(toggledTo ? "text.yigd.message.whitelist.to_whitelist" : "text.yigd.message.whitelist.to_blacklist")), false);
        }
        return 1;
    }

    private static int moderateGraves(class_3222 player) {
        class_2540 buf;
        if (!YigdCommand.hasPermission((class_1657)player, "yigd.command.moderate") || !YigdConfig.getConfig().commandToggles.moderateGraves) {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            return -1;
        }
        boolean existsGraves = false;
        for (List<DeadPlayerData> data : DeathInfoManager.INSTANCE.data.values()) {
            if (data.size() <= 0) continue;
            existsGraves = true;
            break;
        }
        if (existsGraves) {
            buf = PacketByteBufs.create();
            Map<UUID, List<DeadPlayerData>> graveData = DeathInfoManager.INSTANCE.data;
            buf.writeInt(graveData.size());
            for (Map.Entry<UUID, List<DeadPlayerData>> entry : graveData.entrySet()) {
                List<DeadPlayerData> graveList = entry.getValue();
                GameProfile profile = graveList.size() <= 0 ? new GameProfile(entry.getKey(), "Shrek") : graveList.get((int)0).graveOwner;
                buf.method_43616(profile);
                buf.writeInt(graveList.size());
                for (DeadPlayerData grave : graveList) {
                    buf.writeByte((int)grave.availability);
                }
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.grave_not_found"), false);
            return 0;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.ALL_PLAYER_GRAVES, (class_2540)buf);
        return 1;
    }

    private static int viewGrave(@Nullable class_3222 player, class_3222 commandUser) {
        class_2540 buf;
        if (player == null) {
            return -1;
        }
        UUID userId = player.method_5667();
        YigdConfig config = YigdConfig.getConfig();
        if (!(YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.view") && config.commandToggles.adminView || config.commandToggles.selfView && userId.equals(commandUser.method_5667()))) {
            commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            return -1;
        }
        if (DeathInfoManager.INSTANCE.data.containsKey(userId) && DeathInfoManager.INSTANCE.data.get(userId).size() > 0) {
            List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
            Yigd.LOGGER.info("Sending packets to " + commandUser.method_5476().getString() + " with grave info...");
            GameProfile profile = deadPlayerData.get((int)0).graveOwner;
            buf = PacketByteBufs.create();
            buf.method_43616(profile);
            buf.writeInt(deadPlayerData.size());
            for (DeadPlayerData data : deadPlayerData) {
                int itemCount = 0;
                for (class_1799 stack : data.inventory) {
                    if (stack.method_7960()) continue;
                    ++itemCount;
                }
                for (YigdApi yigdApi : Yigd.apiMods) {
                    String modName = yigdApi.getModName();
                    if (!data.modInventories.containsKey(modName)) continue;
                    itemCount += yigdApi.getInventorySize(data.modInventories.get(modName));
                }
                int points = data.xp;
                int i = 0;
                while (points >= 0) {
                    points = i < 16 ? (points -= 2 * i + 7) : (i < 31 ? (points -= 5 * i - 38) : (points -= 9 * i - 158));
                    ++i;
                }
                buf.method_10797(data.id);
                buf.method_10807(data.gravePos);
                buf.method_10814(data.dimensionName);
                buf.writeInt(itemCount);
                buf.writeInt(i - 1);
                buf.writeByte((int)data.availability);
            }
        } else {
            commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.view_command.fail", (Object[])new Object[]{player.method_5476().getString()}).method_27694(style -> style.method_36139(0xFF0000)), false);
            return 0;
        }
        ServerPlayNetworking.send((class_3222)commandUser, (class_2960)PacketIdentifiers.PLAYER_GRAVES_GUI, (class_2540)buf);
        return 1;
    }

    private static class_3218 worldFromId(@Nullable MinecraftServer server, class_2960 worldId) {
        class_3218 world;
        block1: {
            class_3218 serverWorld;
            world = null;
            if (server == null) break block1;
            Iterator iterator = server.method_3738().iterator();
            while (iterator.hasNext() && (world = (serverWorld = (class_3218)iterator.next())).method_27983().method_29177() != worldId) {
            }
        }
        return world;
    }

    public static int robGrave(GameProfile victim, class_3222 stealer, @Nullable UUID graveId) {
        if (!YigdCommand.hasPermission((class_1657)stealer, "yigd.command.rob") || !YigdConfig.getConfig().commandToggles.robGrave) {
            stealer.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            return -1;
        }
        UUID victimId = victim.getId();
        if (!DeathInfoManager.INSTANCE.data.containsKey(victimId)) {
            stealer.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.rob_command.fail"), false);
            return 0;
        }
        List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(victimId);
        if (deadPlayerData.size() <= 0) {
            stealer.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.unclaimed_grave_missing", (Object[])new Object[]{victim.getName()}).method_27694(style -> style.method_36139(0xFF0000)), true);
            return 0;
        }
        DeadPlayerData foundDeath = deadPlayerData.get(deadPlayerData.size() - 1);
        if (graveId != null) {
            for (DeadPlayerData deadPlayerData2 : deadPlayerData) {
                if (deadPlayerData2.id != graveId) continue;
                foundDeath = deadPlayerData2;
                break;
            }
        }
        DeathInfoManager.INSTANCE.method_80();
        HashMap<String, Object> modInv = new HashMap<String, Object>();
        for (YigdApi yigdApi : Yigd.apiMods) {
            String modName = yigdApi.getModName();
            if (!foundDeath.modInventories.containsKey(modName)) continue;
            modInv.put(yigdApi.getModName(), foundDeath.modInventories.get(modName));
        }
        class_3218 class_32182 = YigdCommand.worldFromId(stealer.method_5682(), foundDeath.worldId);
        if (class_32182 != null && foundDeath.gravePos != null && class_32182.method_8320(foundDeath.gravePos).method_27852((class_2248)Yigd.GRAVE_BLOCK)) {
            class_32182.method_8650(foundDeath.gravePos, false);
            if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)class_32182, (double)foundDeath.gravePos.method_10263(), (double)foundDeath.gravePos.method_10264(), (double)foundDeath.gravePos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
        }
        GraveHelper.RetrieveItems((class_1657)stealer, foundDeath.inventory, modInv, foundDeath.xp, true);
        stealer.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.rob_command.success"), true);
        class_3222 victimPlayer = stealer.field_13995.method_3760().method_14602(victimId);
        if (victimPlayer != null) {
            victimPlayer.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.rob_command.victim"), false);
        } else {
            Yigd.notNotifiedRobberies.put(victimId, stealer.method_7334().getName());
        }
        return 1;
    }

    private static UUID posToId(class_2338 pos, class_2960 worldId, UUID userId) {
        List<DeadPlayerData> data = DeathInfoManager.INSTANCE.data.get(userId);
        if (data == null) {
            return null;
        }
        for (DeadPlayerData deadData : data) {
            if (!deadData.gravePos.equals((Object)pos) || !deadData.worldId.equals((Object)worldId)) continue;
            return deadData.id;
        }
        return null;
    }

    public static int restoreGrave(class_1657 player, @Nullable class_3222 commandUser, @Nullable UUID graveId) {
        if (commandUser != null && !YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.restore") || !YigdConfig.getConfig().commandToggles.retrieveGrave) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        UUID userId = player.method_5667();
        if (!DeathInfoManager.INSTANCE.data.containsKey(userId)) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.restore_command.fail"), true);
            }
            return -1;
        }
        List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
        if (deadPlayerData.size() <= 0) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.unclaimed_grave_missing", (Object[])new Object[]{player.method_5476().getString()}).method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        DeadPlayerData foundDeath = null;
        if (graveId == null) {
            foundDeath = deadPlayerData.get(deadPlayerData.size() - 1);
        } else {
            for (DeadPlayerData deadPlayerData2 : deadPlayerData) {
                if (!deadPlayerData2.id.equals(graveId)) continue;
                foundDeath = deadPlayerData2;
                break;
            }
        }
        if (foundDeath == null) {
            return -1;
        }
        HashMap<String, Object> modInv = new HashMap<String, Object>();
        for (YigdApi yigdApi : Yigd.apiMods) {
            String modName = yigdApi.getModName();
            if (!foundDeath.modInventories.containsKey(modName)) continue;
            modInv.put(yigdApi.getModName(), foundDeath.modInventories.get(modName));
        }
        class_3218 class_32182 = YigdCommand.worldFromId(player.method_5682(), foundDeath.worldId);
        if (class_32182 != null && foundDeath.gravePos != null && class_32182.method_8320(foundDeath.gravePos).method_27852((class_2248)Yigd.GRAVE_BLOCK)) {
            class_32182.method_8650(foundDeath.gravePos, false);
            if (YigdConfig.getConfig().graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)class_32182, (double)foundDeath.gravePos.method_10263(), (double)foundDeath.gravePos.method_10264(), (double)foundDeath.gravePos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
        }
        foundDeath.availability = 0;
        DeathInfoManager.INSTANCE.method_80();
        GraveHelper.RetrieveItems(player, foundDeath.inventory, modInv, foundDeath.xp, false);
        if (commandUser != null) {
            commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.restore_command.success"), true);
        }
        return 1;
    }

    private static int clearBackup(Collection<class_3222> victims, @Nullable class_3222 commandUser) {
        if (commandUser != null && !YigdCommand.hasPermission((class_1657)commandUser, "yigd.command.clear") || !YigdConfig.getConfig().commandToggles.clearGraveBackups) {
            if (commandUser != null) {
                commandUser.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_permission").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
            return -1;
        }
        int i = 0;
        for (class_3222 victim : victims) {
            UUID victimId = victim.method_5667();
            if (!DeathInfoManager.INSTANCE.data.containsKey(victimId)) continue;
            ++i;
            DeathInfoManager.INSTANCE.data.get(victimId).clear();
        }
        DeathInfoManager.INSTANCE.method_80();
        if (commandUser != null) {
            commandUser.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.backup.delete_player", (Object[])new Object[]{i}), false);
        }
        return 1;
    }

    public static boolean hasPermission(class_1657 player, String permission) {
        if (Yigd.miscCompatMods.contains("permissions")) {
            return switch (permission) {
                case "yigd.command.moderate" -> PermissionsCompat.moderatePermission(player);
                case "yigd.command.rob" -> PermissionsCompat.robPermission(player);
                case "yigd.command.restore" -> PermissionsCompat.restorePermission(player);
                case "yigd.command.view" -> PermissionsCompat.viewPermission(player);
                case "yigd.command.clear" -> PermissionsCompat.clearPermission(player);
                case "yigd.command.whitelist" -> PermissionsCompat.whitelistPermission(player);
                case "yigd.command.delete" -> PermissionsCompat.deletePermission(player);
                default -> false;
            };
        }
        return player.method_5687(2);
    }

    private static boolean hasPermission(class_2168 source, String permission) {
        if (Yigd.miscCompatMods.contains("permissions")) {
            return switch (permission) {
                case "yigd.command.moderate" -> PermissionsCompat.moderatePermission(source);
                case "yigd.command.rob" -> PermissionsCompat.robPermission(source);
                case "yigd.command.restore" -> PermissionsCompat.restorePermission(source);
                case "yigd.command.view" -> PermissionsCompat.viewPermission(source);
                case "yigd.command.clear" -> PermissionsCompat.clearPermission(source);
                case "yigd.command.whitelist" -> PermissionsCompat.whitelistPermission(source);
                default -> false;
            };
        }
        return source.method_9259(2);
    }
}

