/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected class_4185.class_4241 onPress;
    protected Glyph activeGlyph = Glyph.DOWN;
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;

    public DropDownButton(String label, class_4185.class_4241 onPress) {
        super(label, DropDownButton.emptyPressable());
        this.onPress = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.method_25368();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
    }

    protected void setRenderSolidBackground(boolean value) {
        this.paneScreen.setRenderSolidBackground(value);
    }

    protected void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.method_25402(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.getX());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        DrawUtil.drawLabel(poseStack, this.visible ? this.activeGlyph.getCode() : Glyph.CLOSED.getCode(), this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, false);
    }

    protected int getPanelLocation() {
        class_1041 window = class_310.method_1551().method_22683();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.method_4502();
        if (this.field_22761 - (this.panelMargin + panelHeight) <= 0) {
            this.activeGlyph = Glyph.DOWN;
            return this.field_22761 + this.panelMargin + this.field_22759;
        }
        if (this.field_22761 + (this.panelMargin + panelHeight) > windowBottom) {
            this.activeGlyph = Glyph.UP;
            return this.field_22761 - panelHeight - this.panelMargin;
        }
        this.activeGlyph = Glyph.DOWN;
        return this.field_22761 + this.panelMargin + this.field_22759;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).method_25364() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int method_25368() {
        int width = 0;
        if (this.items != null) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.method_1727(this.getLabel(item)));
            }
            this.field_22758 = width + this.buttonBuffer;
        }
        return this.field_22758;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.onPress.onPress((class_4185)selected);
        this.method_25355((class_2561)class_2561.method_43470((String)selected.getLabel()));
    }

    protected DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public static enum Glyph {
        CLOSED("\u25b6"),
        UP("\u25b2"),
        DOWN("\u25bc");

        String code;

        private Glyph(String code) {
            this.code = code;
        }

        String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }
    }
}

