/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Scrollable;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public class Button
extends class_4185
implements Scrollable {
    protected Integer customFrameColorLight = new Color(160, 160, 160).getRGB();
    protected Integer customFrameColorDark = new Color(120, 120, 120).getRGB();
    protected Integer customBgColor = new Color(100, 100, 100).getRGB();
    protected Integer customBgHoverColor = new Color(125, 135, 190).getRGB();
    protected Integer customBgHoverColor2 = new Color(100, 100, 100).getRGB();
    protected Integer labelColor;
    protected Integer varLabelColor;
    protected Integer hoverLabelColor;
    protected Integer disabledLabelColor;
    public static final int UNSET_ACTIVE_COLOR = -1;
    protected int packedActiveColor = -1;
    protected Integer disabledBgColor = new Color(45, 45, 45).getRGB();
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean drawBackgroundOnDisable = true;
    protected boolean drawLabelShadow = true;
    protected boolean showDisabledHoverText;
    protected boolean defaultStyle = true;
    protected int WIDTH_PAD = 12;
    protected String[] tooltip;
    protected String label;
    protected class_327 fontRenderer;
    protected Rectangle2D.Double bounds;
    protected ArrayList<Function<Button, Boolean>> clickListeners;
    private int tooltipSize;
    private DrawUtil.HAlign horizontalAlignment;
    private boolean drawHovered;
    private HoverState onHoverState;
    private boolean wasHovered;

    public Button(String label) {
        this(0, 0, label, Button.emptyPressable());
        this.resetLabelColors();
    }

    public Button(String label, class_4185.class_4241 onPress) {
        this(0, 0, label, onPress);
        this.resetLabelColors();
    }

    public Button(int width, int height, String label, class_4185.class_4241 onPress) {
        super(0, 0, width, height, (class_2561)Constants.getStringTextComponent(label), onPress);
        this.fontRenderer = class_310.method_1551().field_1772;
        this.clickListeners = new ArrayList(0);
        this.tooltipSize = 200;
        this.horizontalAlignment = DrawUtil.HAlign.Center;
        this.drawHovered = true;
        this.wasHovered = false;
        this.label = label;
        this.finishInit();
    }

    public static class_4185.class_4241 emptyPressable() {
        return button -> {};
    }

    public void resetLabelColors() {
        this.labelColor = new Color(0xE0E0E0).getRGB();
        this.hoverLabelColor = new Color(0xFFFFA0).getRGB();
        this.disabledLabelColor = Color.gray.getRGB();
    }

    public int getActiveColor() {
        if (this.packedActiveColor != -1) {
            return this.packedActiveColor;
        }
        return this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
    }

    protected void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.field_22759 == 0) {
            this.setHeight(20);
        }
        if (this.field_22758 == 0) {
            this.method_25358(200);
        }
        this.updateBounds();
    }

    protected void updateLabel() {
    }

    public boolean method_37303() {
        return this.isEnabled();
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.method_25369().getString());
        return max + this.WIDTH_PAD + (fr.method_1726() ? (int)Math.ceil((double)max * 0.25) : 0);
    }

    public String getLabel() {
        return this.label;
    }

    public void fitWidth(class_327 fr) {
        this.method_25358(this.getFitWidth(fr));
    }

    @Override
    public void drawPartialScrollable(class_4587 poseStack, class_310 minecraft, int x, int y, int width, int height) {
        minecraft.method_1531().method_22813(field_22757);
        int k = 0;
        RenderWrapper.setShader(class_757::method_34542);
        RenderWrapper.setShaderTexture(0, field_22757);
        this.method_25302(poseStack, x, y, 0, 46 + k * 20, width / 2, height);
        this.method_25302(poseStack, x + width / 2, y, 200 - width / 2, 46 + k * 20, width / 2, height);
    }

    public void showDisabledOnHover(boolean show) {
        this.showDisabledHoverText = show;
    }

    public boolean method_25405(double x, double y) {
        return super.method_25405((double)this.field_22760, (double)this.field_22761);
    }

    public boolean isMouseOver() {
        return super.method_25405((double)this.field_22760, (double)this.field_22761);
    }

    public void setMouseOver(boolean hover) {
        this.setHovered(hover);
    }

    public void method_25354(class_1144 soundHandler) {
        if (this.isEnabled()) {
            super.method_25354(soundHandler);
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        if (this.defaultStyle) {
            super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        } else {
            class_310 minecraft = class_310.method_1551();
            minecraft.method_1531().method_22813(field_22757);
            RenderWrapper.setShader(class_757::method_34542);
            RenderWrapper.setShaderTexture(0, field_22757);
            RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.setHovered(mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759);
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(poseStack, this.field_22760, this.field_22761, this.field_22758, 1.0, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(poseStack, this.field_22760, this.field_22761, 1.0, this.field_22759, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(poseStack, this.field_22760, this.field_22761 + this.field_22759 - 1, this.field_22758 - 1, 1.0, this.customFrameColorDark, 1.0f);
                DrawUtil.drawRectangle(poseStack, this.field_22760 + this.field_22758 - 1, this.field_22761 + 1, 1.0, this.field_22759 - 1, this.customFrameColorDark, 1.0f);
            }
            if (this.isDrawBackground() || !this.drawBackgroundOnDisable && this.isEnabled()) {
                DrawUtil.drawRectangle(poseStack, this.field_22760 + 1, this.field_22761 + 1, this.field_22758 - 2, this.field_22759 - 2, this.field_22762 && this.drawHovered ? this.customBgHoverColor : this.customBgColor, 1.0f);
            } else if (this.isEnabled() && this.isHovered() && this.drawHovered) {
                DrawUtil.drawRectangle(poseStack, this.field_22760 + 1, this.field_22761 + 1, this.field_22758 - 2, this.field_22759 - 2, this.customBgHoverColor2, 0.5f);
            }
            this.method_25353(poseStack, minecraft, mouseX, mouseY);
            this.varLabelColor = this.labelColor;
            if (!this.isEnabled()) {
                this.varLabelColor = this.disabledLabelColor;
                if (this.drawBackground) {
                    float alpha = 0.7f;
                    int widthOffset = this.field_22758 - (this.field_22759 >= 20 ? 3 : 2);
                    DrawUtil.drawRectangle(poseStack, this.getX() + 1, this.getY() + 1, widthOffset, this.field_22759 - 2, this.disabledBgColor, alpha);
                }
            } else if (this.isHovered() && this.drawHovered) {
                this.varLabelColor = this.hoverLabelColor;
            } else if (this.labelColor != null) {
                this.varLabelColor = this.labelColor;
            } else if (this.getActiveColor() != 0) {
                this.varLabelColor = this.getActiveColor();
            }
            DrawUtil.drawLabel(poseStack, this.method_25369().getString(), switch (this.horizontalAlignment) {
                case DrawUtil.HAlign.Left -> this.getRightX() - this.WIDTH_PAD / 2;
                case DrawUtil.HAlign.Right -> this.getX() + this.WIDTH_PAD / 2;
                default -> this.getCenterX();
            }, this.getMiddleY(), this.horizontalAlignment, DrawUtil.VAlign.Middle, null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow, 0.0);
        }
    }

    public void setHorizontalAlignment(DrawUtil.HAlign horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void drawHovered(boolean drawHovered) {
        this.drawHovered = drawHovered;
    }

    public void drawCenteredString(class_4587 poseStack, class_327 fontRenderer, String text, float x, float y, int color) {
        fontRenderer.method_1720(poseStack, text, x - (float)(fontRenderer.method_1727(text) / 2), y, color);
    }

    public void drawUnderline(class_4587 poseStack) {
        if (this.isVisible()) {
            DrawUtil.drawRectangle(poseStack, this.field_22760, this.field_22761 + this.field_22759, this.field_22758, 1.0, this.customFrameColorDark, 1.0f);
        }
    }

    public void secondaryDrawButton() {
    }

    public void method_25306() {
        if (this.clickListeners == null || this.clickListeners.size() == 0) {
            super.method_25306();
        } else {
            this.checkClickListeners();
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.onHoverState != null) {
            if (this.isHovered() && !this.wasHovered) {
                this.wasHovered = true;
                this.onHoverState.onHoverState(this, this.wasHovered);
            } else if (this.wasHovered && !this.isHovered()) {
                this.wasHovered = false;
                this.onHoverState.onHoverState(this, this.wasHovered);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean mousePressed(double mouseX, double mouseY, boolean checkClickListeners) {
        boolean clicked = this.isEnabled() && this.isVisible() && this.mouseOver(mouseX, mouseY);
        return clicked && (!checkClickListeners || this.checkClickListeners());
    }

    public boolean checkClickListeners() {
        boolean clicked = true;
        if (!this.clickListeners.isEmpty()) {
            try {
                for (Function<Button, Boolean> listener : this.clickListeners) {
                    if (!listener.apply(this).booleanValue()) break;
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error trying to toggle button '" + this.method_25369() + "': " + LogFormatter.toString(t));
                clicked = false;
            }
        }
        return clicked;
    }

    public String getUnformattedTooltip() {
        if (this.tooltip != null && this.tooltip.length > 0) {
            return this.tooltip[0];
        }
        return null;
    }

    public void method_25352(class_4587 matrixStack, int mouseX, int mouseY) {
    }

    public List<class_5481> getTooltip() {
        ArrayList<class_5481> list = new ArrayList<class_5481>();
        if (this.tooltip != null) {
            for (String line : this.tooltip) {
                list.addAll(this.fontRenderer.method_1728((class_5348)Constants.getTranslatedTextComponent(line), this.tooltipSize));
            }
            return list;
        }
        if (!this.isEnabled() && this.showDisabledHoverText) {
            list.add(class_5481.method_30747((String)Constants.getString("jm.common.disabled_feature"), (class_2583)class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        }
        return list;
    }

    public void setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltip(int size, String ... tooltip) {
        this.tooltipSize = size;
        this.tooltip = tooltip;
    }

    public boolean mouseOver(double mouseX, double mouseY) {
        return this.isVisible() && this.getBounds().contains(mouseX, mouseY);
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.method_25368(), this.method_25364());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    @Override
    public int getScrollableWidth() {
        return this.field_22758;
    }

    public void method_25358(int width) {
        if (this.field_22758 != width) {
            this.field_22758 = width;
            this.bounds = null;
        }
    }

    @Override
    public void setScrollableWidth(int width) {
        this.method_25358(width);
    }

    @Override
    public int getButtonHeight() {
        return this.method_25364();
    }

    public void setHeight(int height) {
        if (this.field_22759 != height) {
            this.field_22759 = height;
            this.bounds = null;
            if (height != 20) {
                this.defaultStyle = false;
            }
        }
    }

    public void setTextOnly(class_327 fr) {
        Objects.requireNonNull(fr);
        this.setHeight(9 + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    @Override
    public void drawScrollable(class_4587 poseStack, class_310 mc, int mouseX, int mouseY) {
        this.method_25394(poseStack, mouseX, mouseY, 0.0f);
    }

    @Override
    public void clickScrollable(class_310 mc, int mouseX, int mouseY) {
    }

    @Override
    public int getX() {
        return this.field_22760;
    }

    public void setX(int x) {
        if (this.field_22760 != x) {
            this.field_22760 = x;
            this.bounds = null;
        }
    }

    @Override
    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        if (this.field_22761 != y) {
            this.field_22761 = y;
            this.bounds = null;
        }
    }

    public int getCenterX() {
        return this.field_22760 + this.field_22758 / 2;
    }

    public int getMiddleY() {
        return this.field_22761 + this.field_22759 / 2;
    }

    public int getBottomY() {
        return this.field_22761 + this.field_22759;
    }

    public int getRightX() {
        return this.field_22760 + this.field_22758;
    }

    @Override
    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Button leftOf(int x) {
        this.setX(x - this.method_25368());
        return this;
    }

    public Button rightOf(int x) {
        this.setX(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.setX(x - this.field_22758 / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.setY(y - this.field_22759 / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.setX(other.getX() - this.method_25368() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.setX(other.getX() + other.method_25368() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.setY(other.getY() - this.method_25364() - margin);
        return this;
    }

    public Button above(int y) {
        this.setY(y - this.method_25364());
        return this;
    }

    public Button below(Button other, int margin) {
        this.setY(other.getY() + other.method_25364() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.setY(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.setY(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.getX();
        int y = this.getY();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.getX() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.getY() - vgap - this.method_25364();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.method_25364() / 2;
            }
        }
        this.setX(x);
        this.setY(y);
        return this;
    }

    public boolean isEnabled() {
        return this.field_22763;
    }

    public void setEnabled(boolean enabled) {
        this.field_22763 = enabled;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    public void setDrawButton(boolean drawButton) {
        if (drawButton != this.field_22764) {
            this.field_22764 = drawButton;
        }
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public void setBackgroundColors(Integer customBgColor, Integer customBgHoverColor, Integer customBgHoverColor2) {
        this.customBgColor = customBgColor;
        this.customBgHoverColor = customBgHoverColor;
        this.customBgHoverColor2 = customBgHoverColor2;
    }

    public void setDrawLabelShadow(boolean draw) {
        this.drawLabelShadow = draw;
    }

    public void setLabelColors(Integer labelColor, Integer hoverLabelColor, Integer disabledLabelColor) {
        this.labelColor = labelColor;
        this.packedActiveColor = labelColor;
        if (hoverLabelColor != null) {
            this.hoverLabelColor = hoverLabelColor;
        }
        if (disabledLabelColor != null) {
            this.disabledLabelColor = disabledLabelColor;
        }
    }

    public String getDisplayString() {
        return this.method_25369().getString();
    }

    public void setOnHover(HoverState hoverState) {
        this.onHoverState = hoverState;
    }

    public boolean isDrawBackgroundOnDisable() {
        return this.drawBackgroundOnDisable;
    }

    public void setDrawBackgroundOnDisable(boolean drawBackgroundOnDisable) {
        this.drawBackgroundOnDisable = drawBackgroundOnDisable;
    }

    public void refresh() {
    }

    public Integer getLabelColor() {
        return this.labelColor;
    }

    public boolean isHovered() {
        return super.method_25367();
    }

    public void setHovered(boolean hovered) {
        this.field_22762 = hovered;
    }

    public void addClickListener(Function<Button, Boolean> listener) {
        this.clickListeners.add(listener);
    }

    public String toString() {
        return new StringJoiner(", ", Button.class.getSimpleName() + "[", "]").add("label='" + this.label + "'").toString();
    }

    public static interface HoverState {
        public void onHoverState(Button var1, boolean var2);
    }
}

