/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.mod.vanilla.BedBlockProxy;
import journeymap.client.mod.vanilla.FlowerBlockProxy;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import net.minecraft.class_2238;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2372;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_2443;
import net.minecraft.class_2457;
import net.minecraft.class_2464;
import net.minecraft.class_2476;
import net.minecraft.class_2523;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3749;

public final class VanillaBlockHandler
implements IModBlockHandler {
    ListMultimap<class_3614, BlockFlag> materialFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Class<?>, BlockFlag> blockClassFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<class_2248, BlockFlag> blockFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    HashMap<class_3614, Float> materialAlphas = new HashMap();
    HashMap<class_2248, Float> blockAlphas = new HashMap();
    HashMap<Class<?>, Float> blockClassAlphas = new HashMap();
    private boolean mapPlants;
    private boolean mapPlantShadows;
    private boolean mapCrops;

    public VanillaBlockHandler() {
        this.preInitialize();
    }

    private void preInitialize() {
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.mapPlants = coreProperties.mapPlants.get();
        this.mapCrops = coreProperties.mapCrops.get();
        this.mapPlantShadows = coreProperties.mapPlantShadows.get();
        this.setFlags(class_3614.field_15952, BlockFlag.Ignore);
        this.setFlags(class_3614.field_15959, BlockFlag.Ignore);
        this.setFlags(class_3614.field_15942, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(class_3614.field_15945, BlockFlag.Grass);
        if (coreProperties.caveIgnoreGlass.get().booleanValue()) {
            this.setFlags(class_3614.field_15942, BlockFlag.OpenToSky);
        }
        this.setFlags(class_3614.field_15922, Float.valueOf(1.0f), BlockFlag.NoShadow);
        this.setFlags(class_3614.field_15920, Float.valueOf(0.25f), BlockFlag.Water, BlockFlag.NoShadow);
        this.setFlags(class_3614.field_15932, BlockFlag.NoTopo);
        this.setFlags(class_3614.field_15956, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(class_3614.field_15935, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(class_2246.field_10211, BlockFlag.NoTopo);
        this.setFlags(class_2246.field_10108, BlockFlag.NoTopo);
        this.materialAlphas.put(class_3614.field_15958, Float.valueOf(0.8f));
        this.materialAlphas.put(class_3614.field_15928, Float.valueOf(0.8f));
        this.setFlags(class_2246.field_10576, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(class_2246.field_10036, BlockFlag.NoShadow);
        this.setFlags(class_2246.field_9983, BlockFlag.OpenToSky);
        this.setFlags(class_2246.field_10477, BlockFlag.NoTopo, BlockFlag.NoShadow);
        this.setFlags(class_2246.field_10589, BlockFlag.Ignore);
        this.setFlags(class_2246.field_10348, BlockFlag.Ignore);
        this.setFlags(class_2246.field_10343, BlockFlag.OpenToSky, BlockFlag.NoShadow);
        this.setFlags(class_2354.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(class_2349.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(class_2372.class, BlockFlag.Grass);
        this.setFlags(class_2397.class, BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoTopo);
        this.setFlags(class_3614.field_15923, BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoTopo);
        this.setFlags(class_2443.class, BlockFlag.NoShadow, BlockFlag.NoTopo);
        this.setFlags(class_2457.class, BlockFlag.Ignore);
        this.setFlags(class_2527.class, BlockFlag.Ignore);
        this.setFlags(class_2541.class, Float.valueOf(0.2f), BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoShadow);
        this.setFlags(class_2261.class, BlockFlag.Plant);
        this.setFlags(class_2266.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(class_2523.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(class_2476.class, BlockFlag.Plant, BlockFlag.NoTopo);
    }

    @Override
    public void initialize(BlockMD blockMD) {
        String uid;
        class_2248 block = blockMD.getBlockState().method_26204();
        class_3614 material = blockMD.getBlockState().method_26207();
        class_2680 blockState = blockMD.getBlockState();
        if (blockState.method_26217() == class_2464.field_11455 && !(blockState.method_26204() instanceof class_2404)) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
        blockMD.addFlags(this.materialFlags.get((Object)material));
        Float alpha = this.materialAlphas.get(material);
        if (alpha != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (this.blockFlags.containsKey((Object)block)) {
            blockMD.addFlags(this.blockFlags.get((Object)block));
        }
        if ((alpha = this.blockAlphas.get(block)) != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        for (Class parentClass : this.blockClassFlags.keys()) {
            if (!parentClass.isAssignableFrom(block.getClass())) continue;
            blockMD.addFlags(this.blockClassFlags.get((Object)parentClass));
            alpha = this.blockClassAlphas.get(parentClass);
            if (alpha == null) break;
            blockMD.setAlpha(alpha.floatValue());
            break;
        }
        if (block instanceof class_2404) {
            blockMD.addFlags(BlockFlag.Fluid, BlockFlag.NoShadow);
            blockMD.setAlpha(0.7f);
        }
        if (material == class_3614.field_15942 && (class_2378.field_11146.method_10221((Object)block).method_12832().equalsIgnoreCase("glowstone") || block instanceof class_3749 || block instanceof class_2238 || block.equals(class_2246.field_10171))) {
            blockMD.removeFlags(BlockFlag.OpenToSky, BlockFlag.Transparency);
            blockMD.setAlpha(1.0f);
        }
        if (block instanceof class_2261 && blockMD.getBlockState().method_28501().contains(class_2320.field_10929) && blockMD.getBlockState().method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609) {
            blockMD.addFlags(BlockFlag.Ignore);
        }
        if (block instanceof class_2302) {
            blockMD.addFlags(BlockFlag.Crop);
        }
        if (block instanceof class_2356 || block instanceof class_2362) {
            blockMD.setBlockColorProxy(FlowerBlockProxy.INSTANCE);
        }
        if (block instanceof class_2244) {
            blockMD.setBlockColorProxy(BedBlockProxy.INSTANCE);
        }
        if ((uid = blockMD.getBlockId()).equals("minecraft:bell")) {
            blockMD.setBlockColorProxy(ModBlockDelegate.INSTANCE.getMaterialBlockColorProxy());
            return;
        }
        if (blockMD.isVanillaBlock()) {
            return;
        }
        if (uid.toLowerCase().contains("torch")) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
    }

    public void postInitialize(BlockMD blockMD) {
        if (blockMD.hasFlag(BlockFlag.Crop)) {
            blockMD.removeFlags(BlockFlag.Plant);
        }
        if (blockMD.hasAnyFlag(BlockMD.FlagsPlantAndCrop)) {
            if (!this.mapPlants && blockMD.hasFlag(BlockFlag.Plant) || !this.mapCrops && blockMD.hasFlag(BlockFlag.Crop)) {
                blockMD.addFlags(BlockFlag.Ignore);
            } else if (!this.mapPlantShadows) {
                blockMD.addFlags(BlockFlag.NoShadow);
            }
        }
        if (blockMD.isIgnore()) {
            blockMD.removeFlags(BlockMD.FlagsNormal);
        }
    }

    private void setFlags(class_3614 material, BlockFlag ... flags) {
        this.materialFlags.putAll((Object)material, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(class_3614 material, Float alpha, BlockFlag ... flags) {
        this.materialAlphas.put(material, alpha);
        this.setFlags(material, flags);
    }

    private void setFlags(Class parentClass, BlockFlag ... flags) {
        this.blockClassFlags.putAll((Object)parentClass, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Class parentClass, Float alpha, BlockFlag ... flags) {
        this.blockClassAlphas.put(parentClass, alpha);
        this.setFlags(parentClass, flags);
    }

    private void setFlags(class_2248 block, BlockFlag ... flags) {
        this.blockFlags.putAll((Object)block, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(class_2248 block, Float alpha, BlockFlag ... flags) {
        this.blockAlphas.put(block, alpha);
        this.setFlags(block, flags);
    }
}

