/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.registery;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1646;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_2477;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5819;

public class SpawnSettings {
    private static final class_2477 language = class_2477.method_10517();

    public static void initSpawnSettings(Entities.EntityKey mountKey, class_1299<MountEntity> type, boolean printLines) {
        Settings.EntitySettings settings = Settings.settings.get((Object)mountKey);
        if (settings.shouldSpawn) {
            class_1317.class_1319 spawnRestrictionLoc;
            class_2902.class_2903 motionBlocking = class_2902.class_2903.field_13203;
            class_1311 spawnGroup = class_1311.field_6294;
            if ("overworld".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                class_1317.class_1319 class_13192 = class_1317.class_1319.field_19350;
            }
            if ("village".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = class_1317.class_1319.field_19350;
                spawnGroup = class_1311.field_6303;
            } else if ("water".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = class_1317.class_1319.field_19350;
            } else if ("nether".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = class_1317.class_1319.field_6317;
                motionBlocking = class_2902.class_2903.field_13202;
                spawnGroup = class_1311.field_6302;
            } else if ("end".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = class_1317.class_1319.field_6317;
            } else if ("subterranean".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = class_1317.class_1319.field_6317;
                motionBlocking = class_2902.class_2903.field_13202;
                spawnGroup = class_1311.field_6302;
            } else {
                spawnRestrictionLoc = class_1317.class_1319.field_19350;
            }
            SpawnConditions spawnConditions = new SpawnConditions(mountKey, type, (double)(100 - settings.spawnRandomChance) / 100.0);
            class_1317.class_4306 spawnPredicate = spawnConditions::doBlockChecks;
            class_1317.method_20637(type, (class_1317.class_1319)spawnRestrictionLoc, (class_2902.class_2903)motionBlocking, (class_1317.class_4306)spawnPredicate);
            BiomeModifications.addSpawn(b -> {
                Object[] biomes;
                Object name = b.getBiomeKey().method_29177().method_12836() + ":" + b.getBiomeKey().method_29177().method_12832();
                String name2 = SpawnSettings.translate("biome." + b.getBiomeKey().method_29177().method_12836() + "." + b.getBiomeKey().method_29177().method_12832(), new Object[0]);
                if (printLines && Settings.globalSettings.printBiomes) {
                    System.out.println((String)name);
                    System.out.println(name2);
                }
                if ((biomes = settings.spawnBiomes) == null || biomes.length == 0) {
                    return false;
                }
                if ("all".equals(biomes[0].toLowerCase(Locale.ROOT))) {
                    return true;
                }
                if ("all overworld".equals(biomes[0].toLowerCase(Locale.ROOT))) {
                    return BiomeSelectors.foundInOverworld().test(b);
                }
                if ("all nether".equals(biomes[0].toLowerCase(Locale.ROOT))) {
                    return BiomeSelectors.foundInTheNether().test(b);
                }
                if ("all end".equals(biomes[0].toLowerCase(Locale.ROOT))) {
                    return BiomeSelectors.foundInTheEnd().test(b);
                }
                name = ((String)name).toLowerCase(Locale.ROOT);
                name2 = name2.toLowerCase(Locale.ROOT);
                for (int i = 0; i < biomes.length; ++i) {
                    biomes[i] = ((String)biomes[i]).toLowerCase(Locale.ROOT);
                }
                Arrays.sort(biomes);
                boolean name1Found = Arrays.binarySearch(biomes, name) >= 0;
                boolean name2Found = Arrays.binarySearch(biomes, name2) >= 0;
                return name1Found || name2Found;
            }, (class_1311)spawnGroup, type, (int)settings.spawnWeight, (int)settings.minSpawnGroupSize, (int)settings.maxSpawnGroupSize);
        }
    }

    public static String translate(String key, Object ... args) {
        String string = language.method_4679(key);
        try {
            return String.format(string, args);
        }
        catch (IllegalFormatException var4) {
            return "Format error: " + string;
        }
    }

    public static class SpawnConditions {
        double rarity;
        int yCeil;
        int yFloor;
        boolean debug;
        class_2248[] blocks;
        Entities.EntityKey mountKey;

        public SpawnConditions(Entities.EntityKey mountKey, class_1299<? extends MountEntity> type, double rarity) {
            this.mountKey = mountKey;
            this.rarity = rarity;
            this.yCeil = Settings.settings.get((Object)((Object)mountKey)).spawnYCeiling;
            this.yFloor = Settings.settings.get((Object)((Object)mountKey)).spawnYFloor;
            this.initBlocks(Settings.settings.get((Object)((Object)mountKey)).spawnBlocks);
            this.debug = Settings.settings.get((Object)((Object)mountKey)).spawnDebug || Settings.globalSettings.debug;
        }

        public void initBlocks(String[] blockNames) {
            if (blockNames.length > 0 && "all".equals(blockNames[0].trim().toLowerCase(Locale.ROOT))) {
                this.blocks = null;
                return;
            }
            this.blocks = new class_2248[blockNames.length];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = (class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)blockNames[i]));
            }
        }

        public boolean isValidChunk(int freq, int offset, class_241 chunkPos) {
            if (freq < 0) {
                return false;
            }
            if (freq == 0 || freq == 1) {
                return true;
            }
            if (freq == 2) {
                if (offset % 2 == 0) {
                    return chunkPos.field_1343 % 2.0f == chunkPos.field_1342 % 2.0f;
                }
                return chunkPos.field_1343 % 2.0f != chunkPos.field_1342 % 2.0f;
            }
            return (chunkPos.field_1343 + (float)offset) % (float)(freq - 1) == 0.0f && (chunkPos.field_1342 + (float)offset) % (float)(freq - 1) == 0.0f;
        }

        /*
         * WARNING - void declaration
         */
        boolean doBlockChecks(class_1299<? extends MountEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
            List nearbyMounts;
            Settings.EntitySettings settings = Settings.settings.get((Object)this.mountKey);
            class_241 chunkPos = new class_241((float)(world.method_22350((class_2338)pos).method_12004().field_9181 + settings.chunkOffset), (float)(world.method_22350((class_2338)pos).method_12004().field_9180 + settings.chunkOffset));
            if (!this.isValidChunk(settings.chunkFreq, settings.chunkOffset, chunkPos)) {
                this.printDebug(type, "Failed chunk restrictions " + settings.chunkFreq + " " + settings.chunkOffset);
                return false;
            }
            if (random.method_43058() < this.rarity) {
                this.printDebug(type, "Failed random chance to spawn");
                return false;
            }
            if (pos.method_10264() < this.yFloor || pos.method_10264() > this.yCeil) {
                this.printDebug(type, "Failed floor/ceiling checks");
                return false;
            }
            if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10164) || world.method_8320(pos).method_27852(class_2246.field_10164)) {
                this.printDebug(type, "Failed to spawn since there was lava");
                return false;
            }
            if ("overworld".equals(settings.spawnType.toLowerCase(Locale.ROOT)) && !world.method_8311(pos)) {
                this.printDebug(type, "Failed to spawn since it is an overworld entity and was in a cave");
                return false;
            }
            if ("subterranean".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                if (world.method_8311(pos)) {
                    this.printDebug(type, "Failed to spawn since it is a subterranean entity and was not in a cave");
                    return false;
                }
                class_2680 b = world.method_8320(pos);
                for (int i = 1; (b.method_27852(class_2246.field_10124) || !b.method_26207().method_15801()) && i <= 255; ++i) {
                    b = world.method_8320(pos.method_10086(i));
                }
                if (!b.method_27852(class_2246.field_10340)) {
                    this.printDebug(type, "Failed to spawn since it is a subterranean entity and was not in a real cave");
                    return false;
                }
            }
            if ("village".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                this.printDebug(type, "trying village check");
                if (!world.method_8311(pos)) {
                    this.printDebug(type, "Failed to spawn since it is a village entity and it is underground");
                    return false;
                }
                class_238 box = new class_238(pos);
                List villagers = world.method_18467(class_1646.class, box = box.method_1009(64.0, 64.0, 64.0));
                if (villagers.isEmpty()) {
                    this.printDebug(type, "Failed to spawn since it is an was not near a village");
                    return false;
                }
            }
            if (Settings.globalSettings.mobCap > 0 && (nearbyMounts = world.method_18467(MountEntity.class, new class_238(pos).method_1014((double)Settings.globalSettings.mobCapRange))).size() >= Settings.globalSettings.mobCap / 2) {
                this.printDebug(type, "Failed to spawn since the global mob limit was reached.");
                return false;
            }
            int unloadDist = 96;
            if ("village".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                unloadDist = 128;
            }
            if (settings.maxIn256Region > 0) {
                class_2338[] positions = new class_2338[]{new class_2338(pos.method_10263() + unloadDist, pos.method_10264(), pos.method_10260() + unloadDist), new class_2338(pos.method_10263() - unloadDist, pos.method_10264(), pos.method_10260() - unloadDist), new class_2338(pos.method_10263() - unloadDist, pos.method_10264(), pos.method_10260() + unloadDist), new class_2338(pos.method_10263() + unloadDist, pos.method_10264(), pos.method_10260() - unloadDist)};
                boolean enoughRoomToCheck = true;
                for (class_2338 class_23382 : positions) {
                    if (world.method_33598(class_23382.method_10263(), class_23382.method_10260())) continue;
                    enoughRoomToCheck = false;
                }
                if (!enoughRoomToCheck) {
                    this.printDebug(type, "Failed to spawn since it was too close to an unloaded chunk (can't accurately perform limit checks).");
                    return false;
                }
                class_238 searchSpace = new class_238(pos);
                searchSpace = searchSpace.method_1014(128.0);
                List nearbyMounts2 = world.method_18467(Settings.classes.get((Object)this.mountKey), searchSpace);
                if (nearbyMounts2.size() >= settings.maxIn256Region) {
                    this.printDebug(type, "Failed to spawn since there are already the max number of this mob in the region nearby");
                    return false;
                }
            }
            if ("water".equals(settings.spawnType.toLowerCase(Locale.ROOT)) && !world.method_8320(pos).method_27852(class_2246.field_10382) && !world.method_8320(pos.method_10074()).method_27852(class_2246.field_10382) && !world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) {
                this.printDebug(type, "Failed to spawn since is a water entity and was not in water");
                return false;
            }
            if (!"water".equals(settings.spawnType.toLowerCase(Locale.ROOT)) && (world.method_8320(pos).method_27852(class_2246.field_10382) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_10382) || world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382))) {
                this.printDebug(type, "Failed to spawn since is not a water entity and was in water");
                return false;
            }
            List nearbyMounts3 = world.method_18467(MountEntity.class, new class_238(pos).method_1014(8.0));
            if (nearbyMounts3.size() > 2) {
                this.printDebug(type, "Failed to spawn since there is already mythicmounts nearby " + nearbyMounts3.size());
                return false;
            }
            if (this.blocks == null || this.blocks.length == 0) {
                this.printDebug(type, "Spawn conditions met. (It is possible, but not guaranteed, to spawn)");
                return true;
            }
            class_2680[] check = new class_2680[]{world.method_8320(pos.method_10074()), world.method_8320(world.method_22340(pos.method_10089(3)) ? pos.method_10089(3) : pos), world.method_8320(world.method_22340(pos.method_10088(3)) ? pos.method_10088(3) : pos), world.method_8320(world.method_22340(pos.method_10076(3)) ? pos.method_10076(3) : pos), world.method_8320(world.method_22340(pos.method_10077(3)) ? pos.method_10077(3) : pos)};
            for (class_2338 class_23383 : check) {
                void var14_22;
                int i = 1;
                while (var14_22.method_27852(class_2246.field_10382) || !var14_22.method_26207().method_15799()) {
                    class_2680 class_26802 = world.method_8320(pos.method_10087(i));
                    ++i;
                }
                for (class_2248 block : this.blocks) {
                    if (!var14_22.method_27852(block)) continue;
                    this.printDebug(type, "Spawn conditions met. (It is possible, but not guaranteed to spawn)");
                    return true;
                }
            }
            this.printDebug(type, "Failed block restrictions");
            return false;
        }

        public void printDebug(class_1299<? extends MountEntity> type, String message) {
            if (this.debug) {
                System.out.println(type.method_5897().getString() + ": " + message);
            }
        }
    }
}

