/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.mounts;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class NightmareEntity
extends MountEntity {
    private static final UUID SOUL_SPEED_BOOST_ID = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private int frameCount = 0;
    private int currentFrame = 0;
    private final String[] textureFrames = new String[]{"_frame1.png", "_frame1b.png", "_frame2.png", "_frame2b.png", "_frame3.png", "_frame3b.png", "_frame4.png", "_frame4b.png"};
    int bookTick = 0;
    final String[] idleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle4", "animation.mount.idle5", "animation.mount.idle6", "animation.mount.idle7", "animation.mount.idle8"};
    final String[] mountedIdleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle5", "animation.mount.idle6", "animation.mount.idle7", "animation.mount.idle8"};

    public NightmareEntity(class_1299<? extends MountEntity> type, class_1937 worldIn) {
        super(type, worldIn, Entities.EntityKey.NIGHTMARE, true, false);
        this.armorTextureBaseStr = "textures/model/entity/armor/nightmare_armor";
        String a = "nightmare_mount1";
        String b = "nightmare_mount2";
        String c = "nightmare_mount5";
        for (int i = 0; i < 3; ++i) {
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount2");
            this.textures.add("nightmare_mount2");
            this.textures.add("nightmare_mount5");
        }
        this.textures.add("nightmare_mount3");
        this.textures.add("nightmare_mount4");
        this.textures.add("nightmare_mount6");
        this.childScale = 0.6f;
        this.childHeadScale = 1.0f;
        this.miniYOffset = 0.8f;
        this.method_5941(class_7.field_14, 0.0f);
    }

    public boolean method_6049(class_1293 effect) {
        boolean res = effect.method_5579() != class_1294.field_5920;
        return res && super.method_6049(effect);
    }

    protected void method_29502() {
        if (!this.method_43261().method_26215() && this.method_27303()) {
            class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23719);
            if (entityAttributeInstance == null) {
                return;
            }
            entityAttributeInstance.method_26835(new class_1322(SOUL_SPEED_BOOST_ID, "Soul speed boost", 0.07724998891353607, class_1322.class_1323.field_6328));
        }
    }

    @Override
    protected void method_6001(class_5819 random) {
        super.method_6001(random);
        Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(Settings.settings.get((Object)((Object)this.mountKey)).health + (double)this.field_5974.method_43048(6) + (double)this.field_5974.method_43048(6));
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)NightmareEntity.calcSpeedStat(this.mountKey));
        Objects.requireNonNull(this.method_5996(class_5134.field_23728)).method_6192(this.method_6774(random) * 1.5);
    }

    public boolean method_26319(class_3610 fluid) {
        return fluid.method_15767(class_3486.field_15518);
    }

    private void updateFloating() {
        if (this.method_5771()) {
            class_3726 shapeContext = class_3726.method_16195((class_1297)this);
            if (shapeContext.method_16192(class_2404.field_24412, this.method_24515(), true) && !this.field_6002.method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15518)) {
                this.field_5952 = true;
            } else {
                this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
            }
        }
    }

    @Override
    public boolean method_5957(class_4538 world) {
        return !world.method_8606((class_1297)this) && !world.method_22345(this.method_5829());
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        this.method_5852();
        if (this.method_5771() || this.method_5770().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10164)) {
            this.field_6017 = 0.0f;
        } else {
            super.method_5623(0.75 * heightDifference, onGround, landedState, landedPosition);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.updateFloating();
        this.method_5852();
        ++this.frameCount;
        this.frameCount %= 2;
        if (this.frameCount == 0) {
            ++this.currentFrame;
            this.currentFrame %= this.textureFrames.length;
        }
        if (this.field_6002.field_9236) {
            if (this.field_5974.method_43048(10) == 0) {
                this.field_6002.method_8486(this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5, Sounds.FIRE, class_3419.field_15254, 0.5f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.6f, false);
            }
            if (this.field_5974.method_43048(5) == 0) {
                for (int i = 0; i < this.field_5974.method_43048(1) + 1; ++i) {
                    this.field_6002.method_8406((class_2394)class_2398.field_11239, this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5, (double)(this.field_5974.method_43057() / 2.0f), 5.0E-5, (double)(this.field_5974.method_43057() / 2.0f));
                }
            }
            if (this.method_5771()) {
                this.method_23327(this.method_23317(), (float)this.method_31478() + 0.8f, this.method_23321());
            }
        }
    }

    @Override
    public String getTextureFile() {
        if (class_310.method_1551().field_1755 instanceof GuiBookEntry) {
            ++this.bookTick;
            this.bookTick %= 30;
            if (this.bookTick == 0) {
                ++this.currentFrame;
                this.currentFrame %= this.textureFrames.length;
            }
            return "textures/model/entity/nightmare_mount1" + this.textureFrames[this.currentFrame];
        }
        return super.getTextureFile() + this.textureFrames[this.currentFrame];
    }

    @Override
    public String getDefaultTexture() {
        return "nightmare_mount1_frame1.png";
    }

    @Override
    protected class_3414 method_5994() {
        if (this.method_6510()) {
            return Sounds.NIGHTMARE_ANGRY_EVENT;
        }
        return Sounds.NIGHTMARE_AMBIENT_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return Sounds.NIGHTMARE_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return Sounds.NIGHTMARE_DEATH_EVENT;
    }

    @Override
    protected class_3414 method_6747() {
        return Sounds.NIGHTMARE_ANGRY_EVENT;
    }

    @Override
    public AnimationBuilder getIdleAnimation() {
        if (this.method_5782()) {
            return this.getRandomAnimation(this.mountedIdleAnimations);
        }
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public AnimationBuilder getSleepingIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14613, 1.0f, 1.0f);
    }

    @Override
    protected void method_6723() {
        if (this.getIsFlying()) {
            this.playFlapSound();
        } else {
            this.method_5783(class_3417.field_14831, 1.0f, 1.0f);
        }
    }
}

