/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.ai;

import com.yahoo.chirpycricket.mythicmounts.entity.FlyingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.SwimmingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.SwimmingMountNavigation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_14;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class MountGoals {

    public static class MountSwimGoal
    extends class_1352 {
        private final MountEntity mob;

        public MountSwimGoal(MountEntity mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407));
            mob.method_5942().method_6354(true);
        }

        public boolean method_6264() {
            return this.mob.method_5799() && this.mob.method_5861(class_3486.field_15517) > this.mob.method_29241() || this.mob.method_5771() && this.mob.method_5861(class_3486.field_15518) > 0.0 && this.mob.shouldSwimInLava;
        }

        public void method_6268() {
            if (this.mob.method_6051().method_43057() < 0.8f) {
                this.mob.method_5993().method_6233();
            }
        }
    }

    public static class MountFollowOwnerGoal
    extends class_1352 {
        public static final int field_30205 = 12;
        private static final int HORIZONTAL_RANGE = 2;
        private static final int HORIZONTAL_VARIATION = 3;
        private static final int VERTICAL_VARIATION = 1;
        private final MountEntity tameable;
        private class_1309 owner;
        private final class_4538 world;
        private final double speed;
        private final class_1408 navigation;
        private int updateCountdownTicks;
        private final float maxDistance;
        private final float minDistance;
        private float oldWaterPathfindingPenalty;
        private final boolean leavesAllowed;

        public MountFollowOwnerGoal(MountEntity tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            this.tameable = tameable;
            this.world = tameable.field_6002;
            this.speed = speed;
            this.navigation = tameable.method_5942();
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.leavesAllowed = leavesAllowed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            if (!(tameable.method_5942() instanceof class_1409 || tameable.method_5942() instanceof class_1407 || tameable.method_5942() instanceof SwimmingMountNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean method_6264() {
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.method_7325()) {
                return false;
            }
            if (this.tameable.getIsSitting()) {
                return false;
            }
            if (!this.tameable.getShouldFollow()) {
                return false;
            }
            if (this.tameable.method_5858((class_1297)livingEntity) < (double)(this.minDistance * this.minDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean method_6266() {
            if (this.navigation.method_6357()) {
                return false;
            }
            if (this.tameable.getIsSitting()) {
                return false;
            }
            return !(this.tameable.method_5858((class_1297)this.owner) <= (double)(this.maxDistance * this.maxDistance));
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathfindingPenalty = this.tameable.method_5944(class_7.field_18);
            this.tameable.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.owner = null;
            this.navigation.method_6340();
            this.tameable.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
        }

        public void method_6268() {
            this.tameable.method_5988().method_6226((class_1297)this.owner, 10.0f, 40.0f);
            if (--this.updateCountdownTicks <= 0) {
                this.updateCountdownTicks = 10;
                if (!this.tameable.method_5934() && !this.tameable.method_5765()) {
                    if (this.tameable.method_5858((class_1297)this.owner) >= 144.0) {
                        this.tryTeleport();
                    } else {
                        this.navigation.method_6335((class_1297)this.owner, this.speed * 2.0);
                    }
                }
            }
        }

        private void tryTeleport() {
            class_2338 blockPos = this.owner.method_24515();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomInt(-3, 3);
                int k = this.getRandomInt(-1, 1);
                int l = this.getRandomInt(-3, 3);
                boolean bl = this.tryTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
                if (!bl) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new class_2338(x, y, z))) {
                return false;
            }
            this.tameable.method_5808((double)x + 0.5, y, (double)z + 0.5, this.tameable.method_36454(), this.tameable.method_36455());
            this.navigation.method_6340();
            return true;
        }

        private boolean canTeleportTo(class_2338 pos) {
            class_7 pathNodeType = class_14.method_23476((class_1922)this.world, (class_2338.class_2339)pos.method_25503());
            if (!(pathNodeType == class_7.field_12 || this.tameable.method_6094() && pathNodeType == class_7.field_18 || this.tameable.method_26319(class_3612.field_15908.method_15785()) && pathNodeType == class_7.field_14)) {
                return false;
            }
            class_2680 blockState = this.world.method_8320(pos.method_10074());
            if (!this.leavesAllowed && blockState.method_26204() instanceof class_2397) {
                return false;
            }
            class_2338 blockPos = pos.method_10059((class_2382)this.tameable.method_24515());
            return this.world.method_8587((class_1297)this.tameable, this.tameable.method_5829().method_996(blockPos));
        }

        private int getRandomInt(int min, int max) {
            return this.tameable.method_6051().method_43048(max - min + 1) + min;
        }
    }

    public static class MountLookAroundGoal
    extends class_1376 {
        MountEntity mob;

        public MountLookAroundGoal(MountEntity mob) {
            super((class_1308)mob);
            this.mob = mob;
        }

        public boolean method_6264() {
            if (this.mob.method_5988().method_38970()) {
                return false;
            }
            return !this.mob.getIsSleeping() && !this.mob.getIsFlying() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.mob.getIsSleeping() && !this.mob.getIsFlying() && super.method_6266();
        }

        public void method_6269() {
            if (!this.mob.getIsSleeping() && !this.mob.getIsFlying()) {
                super.method_6269();
            }
        }

        public void method_6268() {
            if (!this.mob.getIsSleeping() && !this.mob.getIsFlying()) {
                super.method_6268();
            }
        }
    }

    public static class LookAtBlockGoal
    extends class_1352 {
        protected MountEntity mob;
        protected class_2338 target;
        protected final float range;
        private int lookTime;
        protected final float chance;
        private final boolean field_33761;
        private final Predicate<class_2680> blockPredicate = state -> {
            for (class_2248 block : this.mob.seekingBlocks) {
                if (!state.method_27852(block)) continue;
                return true;
            }
            return false;
        };

        public LookAtBlockGoal(MountEntity mob, float range) {
            this(mob, range, 0.02f);
        }

        public LookAtBlockGoal(MountEntity mob, float range, float chance) {
            this(mob, range, chance, false);
        }

        public LookAtBlockGoal(MountEntity mobEntity, float f, float g, boolean bl) {
            this.mob = mobEntity;
            this.range = f;
            this.chance = g;
            this.field_33761 = bl;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.mob.method_5988().method_38970()) {
                return false;
            }
            if (this.mob.method_6051().method_43057() >= this.chance) {
                return false;
            }
            this.target = this.findBlock(this.blockPredicate, this.range).orElse(null);
            return this.target != null;
        }

        public boolean method_6266() {
            class_243 class_2432 = new class_243((double)this.target.method_10263(), (double)this.target.method_10264(), (double)this.target.method_10260());
            if (this.mob.method_5707(class_2432) > (double)(this.range * this.range)) {
                return false;
            }
            return this.lookTime > 0;
        }

        public void method_6269() {
            this.lookTime = 40 + this.mob.method_6051().method_43048(40);
        }

        public void method_6270() {
            this.target = null;
        }

        public void method_6268() {
            double d = (float)this.target.method_10264() + 0.5f;
            this.mob.method_5988().method_20248((double)this.target.method_10263(), d, (double)this.target.method_10260());
            --this.lookTime;
        }

        private Optional<class_2338> findBlock(Predicate<class_2680> predicate, double searchDistance) {
            class_2338 blockPos = this.mob.method_24515();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int i = 0;
            while ((double)i <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutable.method_25504((class_2382)blockPos, k, i - 1, l);
                            if (blockPos.method_19771((class_2382)mutable, searchDistance) && predicate.test(this.mob.field_6002.method_8320((class_2338)mutable))) {
                                return Optional.of(mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    public static class MountGoToBlockGoal
    extends class_1367 {
        private final class_2248[] blocks;
        MountEntity entity;

        public MountGoToBlockGoal(MountEntity turtle, double speed, class_2248[] blocks) {
            super((class_1314)turtle, speed, 16);
            this.blocks = blocks;
            this.entity = turtle;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.entity.getIsSitting() && !this.entity.getIsFlying() && !this.entity.getIsSleeping();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.entity.getIsSitting() && !this.entity.getIsFlying() && !this.entity.getIsSleeping();
        }

        public double getDesiredSquaredDistanceToTarget() {
            return 5.0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            class_2680 blockState = world.method_8320(pos);
            return Arrays.asList(this.blocks).contains(blockState.method_26204());
        }
    }

    public static class SwimRandomlyGoal
    extends class_1352 {
        private final SwimmingMountEntity turtle;
        private final double speed;
        private boolean noPath;
        class_2338 travelTarget;

        public SwimRandomlyGoal(SwimmingMountEntity turtle, double speed) {
            this.turtle = turtle;
            this.speed = speed;
        }

        public boolean method_6264() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return this.turtle.method_5799();
        }

        public void method_6269() {
            class_2338 blockPos;
            boolean i = true;
            boolean j = true;
            class_5819 random = this.turtle.method_6051();
            int k = random.method_43048(1025) - 512;
            int l = random.method_43048(9) - 4;
            int m = random.method_43048(1025) - 512;
            if ((double)l + this.turtle.method_23318() > (double)(this.turtle.field_6002.method_8615() - 1)) {
                l = 0;
            }
            this.travelTarget = blockPos = new class_2338((double)k + this.turtle.method_23317(), (double)l + this.turtle.method_23318(), (double)m + this.turtle.method_23321());
            this.noPath = false;
        }

        public void method_6268() {
            if (this.turtle.method_5942().method_6357()) {
                int j;
                int i;
                class_243 vec3d = class_243.method_24955((class_2382)this.travelTarget);
                class_243 vec3d2 = class_5532.method_31512((class_1314)this.turtle, (int)16, (int)3, (class_243)vec3d, (double)0.3141592741012573);
                if (vec3d2 == null) {
                    vec3d2 = class_5532.method_31512((class_1314)this.turtle, (int)8, (int)7, (class_243)vec3d, (double)360.0);
                }
                if (vec3d2 != null && !this.turtle.field_6002.method_22341((i = class_3532.method_15357((double)vec3d2.field_1352)) - 34, 0, (j = class_3532.method_15357((double)vec3d2.field_1350)) - 34, i + 34, 0, j + 34)) {
                    vec3d2 = null;
                }
                if (vec3d2 == null) {
                    this.noPath = true;
                    return;
                }
                this.turtle.method_5942().method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, this.speed);
            }
        }

        public boolean method_6266() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return !this.turtle.method_5942().method_6357() && !this.noPath && !this.turtle.method_6479();
        }

        public void method_6270() {
            super.method_6270();
        }
    }

    public static class WanderInWaterGoal
    extends class_1367 {
        private final SwimmingMountEntity turtle;

        public WanderInWaterGoal(SwimmingMountEntity turtle, double speed) {
            super((class_1314)turtle, turtle.method_6109() ? 2.0 : speed, 24);
            this.turtle = turtle;
            this.field_6515 = -1;
        }

        public boolean method_6266() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            return !this.turtle.method_5799() && this.field_6517 <= 1200 && this.method_6296((class_4538)this.turtle.field_6002, this.field_6512);
        }

        public boolean method_6264() {
            if (!this.turtle.shouldMove() || this.turtle.getIsFlying() || this.turtle.getShouldFollow()) {
                return false;
            }
            if (this.turtle.method_6109() && !this.turtle.method_5799()) {
                return super.method_6264();
            }
            return !this.turtle.method_5799() ? super.method_6264() : false;
        }

        public boolean method_6294() {
            return this.field_6517 % 160 == 0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return world.method_8320(pos).method_27852(class_2246.field_10382);
        }
    }

    public static class MountFleeGoal<T extends class_1309>
    extends class_1338<T> {
        private final MountEntity cat;
        static Predicate var10006 = class_1301.field_6156;

        public MountFleeGoal(MountEntity cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super((class_1314)cat, fleeFromType, distance, slowSpeed, fastSpeed, var10006::test);
            this.cat = cat;
        }

        public boolean method_6264() {
            return !this.cat.method_6727() && !this.cat.getIsSleeping() && super.method_6264();
        }

        public void method_6268() {
            super.method_6268();
            if (this.cat.getIsSitting() && !this.cat.getIsSleeping()) {
                this.cat.setIsSitting(false);
            }
        }

        public boolean method_6266() {
            return !this.cat.method_6727() && super.method_6266();
        }
    }

    public static class FlyRandomlyGoal
    extends class_1352 {
        private final FlyingMountEntity ghast;
        private static final int maxLoops = 10;

        public FlyRandomlyGoal(FlyingMountEntity ghast) {
            this.ghast = ghast;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            double f;
            double e;
            if (!this.ghast.getIsFlying() || this.ghast.method_5782() || this.ghast.getShouldFollow()) {
                return false;
            }
            class_1335 moveControl = this.ghast.method_5962();
            if (!moveControl.method_6241()) {
                return true;
            }
            double d = moveControl.method_6236() - this.ghast.method_23317();
            double g = d * d + (e = moveControl.method_6235() - this.ghast.method_23318()) * e + (f = moveControl.method_6237() - this.ghast.method_23321()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            double f;
            double d;
            double e;
            class_5819 random = this.ghast.method_6051();
            class_2382 trackedPos = this.ghast.getTrackedPos();
            float minHeight = this.ghast.method_5770().method_8598(class_2902.class_2903.field_13197, this.ghast.method_24515()).method_10264();
            float maxHeight = minHeight + 30.0f;
            for (int i = 0; i < 255; ++i) {
                if (this.ghast.field_6002.method_8320(this.ghast.method_24515().method_10087(i)).method_26215() && !this.ghast.field_6002.method_8320(this.ghast.method_24515().method_10087(i)).method_27852(class_2246.field_10382) && !this.ghast.field_6002.method_8320(this.ghast.method_24515().method_10087(i)).method_27852(class_2246.field_10164)) continue;
                minHeight = i + 2;
                i = 1000;
            }
            maxHeight = (float)Math.max((double)(minHeight + 30.0f), this.ghast.method_23318() + 8.0);
            int loopCount = 0;
            do {
                e = this.ghast.method_23318() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && (e >= (double)maxHeight || e <= (double)minHeight));
            if (loopCount >= 10) {
                e = this.ghast.method_23318();
            }
            loopCount = 0;
            do {
                d = this.ghast.method_23317() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && this.ghast.method_6727() && !trackedPos.equals((Object)class_2382.field_11176) && Math.abs((double)trackedPos.method_10263() - d) > 16.0);
            if (loopCount >= 10) {
                d = this.ghast.method_23317();
            }
            loopCount = 0;
            do {
                f = this.ghast.method_23321() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            } while (++loopCount < 10 && this.ghast.method_6727() && !trackedPos.equals((Object)class_2382.field_11176) && Math.abs((double)trackedPos.method_10260() - f) > 16.0);
            if (loopCount >= 10) {
                f = this.ghast.method_23321();
            }
            this.ghast.method_5962().method_6239(d, e, f, (double)this.ghast.getWanderFlyingSpeed());
        }
    }

    public static class MountTrackOwnerAttackerGoal
    extends class_1405 {
        private final MountEntity tameable;
        private class_1309 attacker;
        private int lastAttackedTime;

        public MountTrackOwnerAttackerGoal(MountEntity tameable) {
            super((class_1308)tameable, false);
            this.tameable = tameable;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.tameable.method_6727() && !this.tameable.getIsSitting()) {
                class_1657 livingEntity = this.tameable.getOwner();
                if (livingEntity == null) {
                    return false;
                }
                this.attacker = livingEntity.method_6065();
                int i = livingEntity.method_6117();
                return i != this.lastAttackedTime && this.method_6328(this.attacker, class_4051.field_18092) && this.tameable.canAttackWithOwner(this.attacker, (class_1309)livingEntity);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.attacker);
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity != null) {
                this.lastAttackedTime = livingEntity.method_6117();
            }
            super.method_6269();
        }
    }

    public static class MountRevengeGoal
    extends class_1399 {
        private final MountEntity mob;

        public MountRevengeGoal(MountEntity mob, Class<?> ... noRevengeTypes) {
            super((class_1314)mob, (Class[])noRevengeTypes);
            this.mob = mob;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.mob.method_6065();
            if (this.mob.method_6727() && this.mob.getOwner() == livingEntity || this.mob.getIsSitting()) {
                return false;
            }
            return super.method_6264();
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.mob.method_6065();
            if (this.mob.method_6727() && this.mob.getOwner() == livingEntity || this.mob.getIsSitting()) {
                return false;
            }
            return super.method_6264();
        }
    }

    public static class MountFollowTargetIfTamedGoal<T extends class_1309>
    extends class_1400<T> {
        private final MountEntity tameableMount;

        public MountFollowTargetIfTamedGoal(MountEntity tameableMount, Class<T> targetClass, boolean checkVisibility, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)tameableMount, targetClass, 10, checkVisibility, false, targetPredicate);
            this.tameableMount = tameableMount;
        }

        public boolean method_6264() {
            class_1309 attackerEntity = this.tameableMount.method_6065();
            return !this.tameableMount.method_6109() && (this.tameableMount.method_6727() && this.tameableMount.getOwner() != attackerEntity && attackerEntity == this.field_6644 || !this.tameableMount.method_6727()) && !this.tameableMount.method_5782() && super.method_6264();
        }

        public boolean method_6266() {
            if (this.tameableMount.method_5782() || this.tameableMount.method_6727()) {
                return false;
            }
            return this.field_6642 != null ? this.field_6642.method_18419((class_1309)this.field_6660, this.field_6644) : super.method_6266();
        }
    }

    public static class MountAttackWithOwnerGoal
    extends class_1405 {
        private final MountEntity tameable;
        private class_1309 attacking;
        private int lastAttackTime;

        public MountAttackWithOwnerGoal(MountEntity tameable) {
            super((class_1308)tameable, false);
            this.tameable = tameable;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.tameable.method_6727() && !this.tameable.getIsSitting() && !this.tameable.method_5782()) {
                int i;
                class_1657 attackingOwner;
                class_1496 attackingTamable;
                class_1657 mountOwner = this.tameable.getOwner();
                if (mountOwner == null) {
                    return false;
                }
                this.attacking = mountOwner.method_6052();
                if (this.attacking instanceof class_1496) {
                    attackingTamable = (class_1496)this.attacking;
                    class_1657 class_16572 = attackingOwner = attackingTamable.method_6768() == null ? null : this.tameable.method_5770().method_18470(attackingTamable.method_6768());
                    if (attackingOwner != null && mountOwner.equals((Object)attackingOwner)) {
                        return false;
                    }
                }
                if (this.attacking instanceof class_6025) {
                    attackingTamable = (class_6025)this.attacking;
                    class_1657 class_16573 = attackingOwner = attackingTamable.method_6139() == null ? null : this.tameable.method_5770().method_18470(attackingTamable.method_6139());
                    if (attackingOwner != null && mountOwner.equals((Object)attackingOwner)) {
                        return false;
                    }
                }
                return (i = mountOwner.method_6083()) != this.lastAttackTime && this.method_6328(this.attacking, class_4051.field_18092) && this.tameable.canAttackWithOwner(this.attacking, (class_1309)mountOwner);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.attacking);
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity != null) {
                this.lastAttackTime = livingEntity.method_6083();
            }
            super.method_6269();
        }
    }

    public static class MountAnimalMateGoal
    extends class_1341 {
        private int timer;
        MountEntity mount;

        public MountAnimalMateGoal(class_1429 animal, double chance, Class<? extends class_1429> entityClass) {
            super(animal, chance, entityClass);
            if (animal instanceof MountEntity) {
                this.mount = (MountEntity)animal;
            }
        }

        public void method_6269() {
            if (this.mount != null) {
                this.mount.setIsSitting(false);
                this.mount.setIsSleeping(false);
                this.mount.setIsFlying(false);
            }
            super.method_6269();
        }

        public void method_6268() {
            this.field_6404.method_5988().method_6226((class_1297)this.field_6406, 10.0f, 40.0f);
            this.field_6404.method_5942().method_6335((class_1297)this.field_6406, 1.25);
            ++this.timer;
            float dist = (float)Math.max(this.field_6404.method_5829().method_17939(), this.field_6404.method_5829().method_17941()) + 1.0f;
            dist = Math.max(dist, 5.0f);
            if (this.timer >= 60 && this.field_6404.method_5858((class_1297)this.field_6406) < (double)(dist * dist)) {
                this.method_6249();
            }
        }
    }

    public static class MountSitGoal
    extends class_1352 {
        private final MountEntity tameable;

        public MountSitGoal(MountEntity tameable) {
            this.tameable = tameable;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6266() {
            return this.tameable.getIsSitting();
        }

        public boolean method_6264() {
            if (!this.tameable.method_6727()) {
                return false;
            }
            if (this.tameable.method_5816()) {
                return false;
            }
            if (!this.tameable.method_24828()) {
                return false;
            }
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity == null) {
                return true;
            }
            return this.tameable.method_5858((class_1297)livingEntity) < 144.0 && livingEntity.method_6065() != null ? false : this.tameable.getIsSitting();
        }

        public void method_6269() {
            this.tameable.method_5942().method_6340();
        }
    }

    public static class MountLookAtEntityGoal
    extends class_1361 {
        MountEntity e;

        public MountLookAtEntityGoal(MountEntity mob, Class<? extends class_1309> targetType, float range) {
            super((class_1308)mob, targetType, range);
            this.e = mob;
        }

        public MountLookAtEntityGoal(MountEntity mob, Class<? extends class_1309> targetType, float range, float chance) {
            super((class_1308)mob, targetType, range, chance);
            this.e = mob;
        }

        public boolean method_6264() {
            return !this.e.getIsSleeping() && !this.e.getIsFlying() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.e.getIsSleeping() && !this.e.getIsFlying() && super.method_6266();
        }

        public void method_6269() {
            if (!this.e.getIsSleeping() && !this.e.getIsFlying()) {
                super.method_6269();
            }
        }

        public void method_6268() {
            if (!this.e.getIsSleeping() && !this.e.getIsFlying()) {
                super.method_6268();
            }
        }
    }

    public static class MountWanderAroundGoal
    extends class_1379 {
        MountEntity e;

        public MountWanderAroundGoal(MountEntity mob, double speed) {
            super((class_1314)mob, speed);
            this.e = mob;
        }

        public MountWanderAroundGoal(MountEntity mob, double speed, int chance) {
            super((class_1314)mob, speed, chance, true);
            this.e = mob;
        }

        public MountWanderAroundGoal(MountEntity mob, double d, int i, boolean bl) {
            super((class_1314)mob, d, i, bl);
            this.e = mob;
        }

        public boolean method_6264() {
            return this.e.shouldMove() && !this.e.getIsFlying() && super.method_6264();
        }

        public boolean method_6266() {
            return this.e.shouldMove() && super.method_6266();
        }

        public void method_6269() {
            if (this.e.shouldMove()) {
                super.method_6269();
            }
        }

        protected class_243 method_6302() {
            class_2382 v = this.e.getTrackedPos();
            class_243 pos = new class_243((double)v.method_10263(), (double)(v.method_10264() + 1), (double)v.method_10260());
            if (this.e.method_19538().method_1022(pos) > 16.0) {
                return class_5532.method_31512((class_1314)this.field_6566, (int)16, (int)5, (class_243)pos, (double)360.0);
            }
            return class_5532.method_31510((class_1314)this.field_6566, (int)10, (int)10);
        }
    }
}

