/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity;

import com.yahoo.chirpycricket.mythicmounts.MythicMountsServerPackets;
import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.FlyingMountMoveControl;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountGoals;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1352;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5498;

public class FlyingMountEntity
extends MountEntity {
    boolean takingOff = false;
    boolean landing = false;
    int takeOffDelay = 0;
    int minFlyingDuration = 200 + this.field_5974.method_43048(2000);
    int flyingCounter = 0;
    int maxGroundDuration = 200 + this.field_5974.method_43048(2000);
    int groundCounter = 0;
    int perspective = -1;
    boolean falling = false;
    double yInit = 0.0;

    public FlyingMountEntity(class_1299<? extends class_1498> type, class_1937 worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn, mountKey);
        this.canFly = true;
        this.field_6207 = new FlyingMountMoveControl(this);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        boolean isBeingRidden = this.isBeingRidden();
        if (isBeingRidden && this.field_5952) {
            this.setFlyingParams(false);
        }
        if (isBeingRidden && !this.field_5952 && !this.getIsFlying() && !this.falling) {
            this.falling = true;
            this.yInit = this.method_19538().field_1351;
        }
        if (isBeingRidden && !this.field_5952 && !this.getIsFlying() && this.falling && Math.abs(this.method_19538().field_1351 - this.yInit) > 2.0) {
            this.falling = false;
            this.setFlyingParams(true);
        }
        if (this.field_6002.method_8608() && !isBeingRidden) {
            this.setFlyingParams(this.getIsFlying());
        }
        if (Settings.globalSettings.enable3rdPersonFlying) {
            if (this.field_6002.method_8608() && isBeingRidden && this.perspective < 0) {
                this.perspective = class_310.method_1551().field_1690.method_31044().ordinal();
                class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
            }
            if (this.field_6002.method_8608() && !isBeingRidden && this.perspective >= 0) {
                if (class_310.method_1551().field_1690.method_31044().equals((Object)class_5498.field_26665)) {
                    class_310.method_1551().field_1690.method_31043(class_5498.values()[this.perspective]);
                }
                this.perspective = -1;
            }
        }
        if (!this.field_6002.method_8608() && !this.method_5782()) {
            if (!(this.getOwnerToldToSit() || this.getIsSitting() || this.method_6109())) {
                this.updateTakeOff();
                this.updateLanding();
                if (this.getIsFlying()) {
                    ++this.flyingCounter;
                    if (!this.landing && !this.takingOff && this.flyingCounter >= this.minFlyingDuration) {
                        this.initLanding();
                    }
                } else {
                    ++this.groundCounter;
                    this.takingOff = false;
                    this.landing = false;
                    if (this.groundCounter >= this.maxGroundDuration && this.enoughRoomToTakeOff() && !this.method_5934() && !this.method_5782() && !this.getShouldFollow()) {
                        this.initTakeOff();
                    }
                }
            }
            this.updateAnimationState();
        } else if (!this.field_6002.method_8608() && this.method_5782()) {
            this.resetWanderBehaviorCycle();
            this.setIsSitting(false);
            this.setIsSleeping(false);
        }
    }

    public void initTakeOff() {
        this.takingOff = true;
        this.takeOffDelay = 0;
        this.flyingCounter = 0;
        this.groundCounter = 0;
        this.setFlyingParams(true);
        if (!this.method_6727()) {
            this.setTrackedPos(this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260());
        }
        this.maxGroundDuration = 200 + this.field_5974.method_43048(2000);
    }

    public void updateTakeOff() {
        if (this.takingOff) {
            ++this.takeOffDelay;
            if (!this.field_5952 && this.takeOffDelay > 25) {
                this.takingOff = false;
                this.takeOffDelay = 0;
            }
        }
    }

    public boolean enoughRoomToTakeOff() {
        return this.field_6002.method_18026(this.method_5829().method_1014(1.0).method_989(0.0, 4.0, 0.0));
    }

    public void initLanding() {
        this.landing = true;
        this.minFlyingDuration = 200 + this.field_5974.method_43048(1000);
    }

    public void updateLanding() {
        if (this.landing) {
            boolean nearGround = false;
            for (int i = 0; i < 3; ++i) {
                if (!this.method_5770().method_8320(this.method_24515().method_10087(i)).method_26225()) continue;
                nearGround = true;
            }
            if (!this.takingOff && !this.isBeingRidden() && (this.field_5952 || nearGround) && this.getIsFlying()) {
                this.setFlyingParams(false);
                this.flyingCounter = 0;
                this.groundCounter = 0;
            }
        }
    }

    @Override
    public void onMounted() {
        super.onMounted();
        if (!this.field_6002.method_8608()) {
            this.setFlyingParams(this.getIsFlying());
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public boolean method_6101() {
        return false;
    }

    public void applySlowFallEffect(boolean shouldSlowFall) {
        if (shouldSlowFall) {
            class_1293 s = new class_1293(class_1294.field_5906);
            this.method_26082(s, null);
        } else {
            this.method_6016(class_1294.field_5906);
        }
    }

    public float getWanderFlyingSpeed() {
        return 1.0f;
    }

    public void setFlyingParams(boolean isFlying) {
        this.setIsFlying(isFlying);
        this.method_6758(isFlying);
        if (!Settings.globalSettings.disableGravity) {
            this.applySlowFallEffect(isFlying);
        }
        if (!this.field_6002.method_8608()) {
            this.method_5875(Settings.globalSettings.disableGravity && isFlying || isFlying && !this.method_5782());
        }
        if (isFlying) {
            this.setIsSitting(false);
            this.setIsSleeping(false);
            this.method_6125((float)this.method_26825(class_5134.field_23719) * 4.0f);
        } else {
            this.method_6125((float)this.method_26825(class_5134.field_23719));
        }
    }

    @Override
    public void method_6091(class_243 movementInput) {
        boolean isBeingRidden;
        if (this.getIsSitting()) {
            super.method_6091(class_243.field_1353);
        }
        if (isBeingRidden = this.isBeingRidden()) {
            if (!this.field_6002.method_8608() && !Settings.globalSettings.mountedFlightAllowed) {
                this.method_5875(false);
                super.method_6091(movementInput);
                return;
            }
            class_1309 passengerEntity = this.method_42167();
            this.method_36456(passengerEntity.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(passengerEntity.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            float passengerSidewaysSpeed = passengerEntity.field_6212 * 0.5f;
            float passengerForwardSpeed = passengerEntity.field_6250;
            if (passengerForwardSpeed <= 0.0f) {
                passengerForwardSpeed *= 0.25f;
                this.field_6975 = 0;
            }
            double maxFlightSpeed = (double)this.method_6029() * this.method_6728(this.field_5974) * 200.0;
            double upwardsVelocity = 0.3;
            if (this.field_6976 > 0.0f) {
                class_243 velocity = this.method_18798();
                if (!this.method_24828()) {
                    velocity = movementInput.method_1029().method_1021(maxFlightSpeed);
                    upwardsVelocity = 1.0;
                    if (!this.getIsFlying()) {
                        ClientPlayNetworking.send((class_2960)MythicMountsServerPackets.FLY_CONTROL, (class_2540)PacketByteBufs.create());
                        this.setFlyingParams(true);
                    }
                } else {
                    upwardsVelocity = this.method_6771() * (double)this.field_6976 * (double)this.method_23313();
                    if (this.method_6059(class_1294.field_5913)) {
                        upwardsVelocity += (double)((float)(this.method_6112(class_1294.field_5913).method_5578() + 1) * 0.1f);
                    }
                }
                this.method_18800(velocity.field_1352, upwardsVelocity, velocity.field_1350);
                this.method_6758(true);
                this.field_6007 = true;
                if (passengerForwardSpeed > 0.0f) {
                    float i = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                    float j = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
                    this.method_18799(this.method_18798().method_1031((double)(-0.4f * i * this.field_6976), 0.0, (double)(0.4f * j * this.field_6976)));
                }
                this.field_6976 = 0.0f;
            }
            if (this.method_5787()) {
                if (this.method_5799()) {
                    this.method_5724(0.02f, movementInput);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)0.8f));
                } else if (this.method_5771()) {
                    this.method_5724(0.02f, movementInput);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021(0.5));
                }
                if (this.getIsFlying()) {
                    if (!this.method_6059(class_1294.field_5906)) {
                        this.applySlowFallEffect(true);
                    }
                    this.method_6125((float)this.method_26825(class_5134.field_23719) * 4.0f);
                    double upDown = 0.0;
                    if (passengerEntity.method_36455() < 25.0f && passengerEntity.method_36455() > -25.0f && passengerForwardSpeed != 0.0f) {
                        upDown = 0.225f;
                    } else if (passengerEntity.method_36455() < -20.0f) {
                        upDown = (double)(passengerEntity.method_36455() / 90.0f) * -maxFlightSpeed * (double)passengerForwardSpeed;
                        if (passengerEntity.method_36455() < -40.0f) {
                            passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                        }
                    } else if (passengerEntity.method_36455() > 45.0f) {
                        upDown = 0.05 * -maxFlightSpeed * (double)passengerForwardSpeed;
                        passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                    }
                    class_243 flightVector = new class_243((double)passengerSidewaysSpeed, upDown, (double)passengerForwardSpeed);
                    super.method_6091(flightVector);
                } else {
                    this.method_6125((float)this.method_26825(class_5134.field_23719));
                    super.method_6091(new class_243((double)passengerSidewaysSpeed, movementInput.field_1351, (double)passengerForwardSpeed));
                }
            } else if (passengerEntity instanceof class_1657) {
                this.method_18799(class_243.field_1353);
            }
            if (!this.method_6763() && this.getIsFlying()) {
                this.setFlyingParams(false);
            }
        }
        if (!this.field_6002.field_9236 && !isBeingRidden) {
            if (this.getIsFlying()) {
                this.flyingTravel(movementInput);
            } else {
                super.method_6091(movementInput);
            }
        }
        this.method_29242((class_1309)this, false);
    }

    public void flyingTravel(class_243 movementInput) {
        if (this.method_5799()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)0.8f));
        } else if (this.method_5771()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            float f = 0.91f;
            if (this.field_5952) {
                f = this.field_6002.method_8320(new class_2338(this.method_23317(), this.method_23318() - 1.0, this.method_23321())).method_26204().method_9499() * 0.91f;
            }
            float g = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.field_5952) {
                f = this.field_6002.method_8320(new class_2338(this.method_23317(), this.method_23318() - 1.0, this.method_23321())).method_26204().method_9499() * 0.91f;
            }
            this.method_5724(0.1f * g, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)f));
        }
        this.method_29242((class_1309)this, false);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(7, (class_1352)new MountGoals.FlyRandomlyGoal(this));
    }
}

