/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yahoo.chirpycricket.mythicmounts.config.ConfigFileHelper;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class Settings {
    public static HashMap<Entities.EntityKey, EntitySettings> settings;
    public static HashMap<Entities.EntityKey, Class> classes;
    public static GlobalSettings globalSettings;
    private static JsonObject biomeJson;
    private static JsonObject itemGroupJson;
    private static JsonObject itemGroupCategoryJson;
    private static JsonObject mobJson;
    private static JsonObject spawnCategories;

    public static void init() {
        if (settings != null) {
            return;
        }
        settings = new HashMap();
        classes = Entities.classesForSettings;
        String filename = FabricLoader.getInstance().getConfigDir() + File.separator + "MythicMountsConfig.json";
        try {
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)new FileReader(filename), JsonObject.class);
            Settings.parseJson(json);
            int version = 0;
            if (globalSettings != null) {
                version = Settings.globalSettings.configVersion;
            }
            if (version < 10) {
                ConfigFileHelper.createBackupSettingsFile(version);
                ConfigFileHelper.createMergedSettings(Settings.mergeJson(json, (JsonObject)new Gson().fromJson("{\r\n    \"globalSettings\": {\r\n        \"configVersion\": 10,\r\n        \"printBiomes\": false,\r\n        \"globalDebug\": false,\r\n        \"enable3rdPersonFlying\": false,\r\n        \"enableFlyingGravity\": true,\r\n        \"disableUiOverlay\": false,\r\n        \"mobCap\": 10,\r\n        \"mobCapRange\": 192\r\n    },\r\n    \"biomeGroups\": {\r\n        \"deserts\": [\"minecraft:badlands\", \"minecraft:minecraft:wooded_badlands\", \"minecraft:eroded_badlands\", \"minecraft:savanna\", \"minecraft:savanna_plateau\", \"minecraft:windswept_savanna\", \"minecraft:desert\"],\r\n        \"jungles\": [\"minecraft:jungle\", \"minecraft:sparse_jungle\", \"minecraft:bamboo_jungle\"],\r\n        \"temperate\": [\"minecraft:plains\",\"minecraft:sunflower_plains\", \"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\"],\r\n        \"shores\": [\"minecraft:beach\",\"minecraft:snowy_beach\", \"minecraft:stony_shore\"],\r\n        \"swamps\": [\"minecraft:swamp\", \"minecraft:mangrove_swamp\"],\r\n        \"cold\": [\"minecraft:windswept_hills\", \"minecraft:windswept_gravelly_hills\", \"minecraft:windswept_forest\", \"minecraft:grove\", \"minecraft:meadow\", \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:jagged_peaks\", \"minecraft:stony_peaks\", \"minecraft:snowy_taiga\"],\r\n        \"snowy\": [ \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:snowy_plains\", \"minecraft:snowy_taiga\", \"minecraft:snowy_slopes\", \"minecraft:snowy_beach\"],\r\n        \"mountains\": [\"minecraft:windswept_hills\", \"minecraft:windswept_gravelly_hills\", \"minecraft:windswept_forest\", \"minecraft:grove\", \"minecraft:meadow\", \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:jagged_peaks\", \"minecraft:stony_peaks\"],\r\n        \"forests\": [\"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\", \"minecraft:taiga\"],\r\n        \"warmForests\": [\"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\"],\r\n        \"oldForests\": [\"minecraft:old_growth_spruce_taiga\", \"minecraft:old_growth_pine_taiga;\", \"Giant Tree Taiga Hills\", \"Giant Spruce Taiga Hills\", \"Giant Tree Taiga\", \"Giant Spruce Taiga\"],\r\n        \"snowyForests\": [\"minecraft:grove\", \"minecraft:snowy_taiga\"]\r\n    },\r\n    \"itemGroups\": {\r\n        \"flowerItems\": [\"sugar\", \"dandelion\", \"poppy\", \"blue_orchid\", \"allium\", \"azure_bluet\", \"red_tulip\", \"orange_tulip\", \"white_tulip\", \"pink_tulip\", \"oxeye_daisy\", \"cornflower\", \"lily_of_the_valley\", \"lilac\", \"rose_bush\", \"peony\", \"flowering_azalea_leaves\"],\r\n        \"grassItems\": [\"hay\", \"grass\", \"fern\", \"tall_grass\", \"large_fern\", \"bamboo\"],\r\n        \"leafItems\": [\"oak_leaves\", \"spruce_leaves\", \"birch_leaves\", \"jungle_leaves\", \"acacia_leaves\", \"dark_oak_leaves\", \"azalea_leaves\", \"flowering_azalea_leaves\", \"lily_pad\", \"small_dripleaf\", \"big_dripleaf\"],\r\n        \"mushroomItems\": [\"brown_mushroom\", \"red_mushroom\", \"crimson_fungus\", \"warped_fungus\"],\r\n        \"rootItems\": [\"cave_vines\", \"vines\", \"hanging_roots\", \"glow_lichen\", \"crimson_roots\", \"warped_roots\", \"nether_wart\", \"cactus\"],\r\n        \"seedItems\": [\"wheat_seeds\", \"melon_seeds\", \"pumpkin_seeds\", \"beetroot_seeds\", \"sweet_berries\"],\r\n        \"vegetableItems\": [\"potato\", \"carrot\", \"beetroot\"],\r\n        \"fruitItems\": [\"sweet_berries\", \"melon_slice\", \"apple\", \"glow_berries\"],\r\n        \"seaweedItems\": [\"seagrass\", \"kelp\", \"tall_seagrass\"],\r\n        \"fishItems\": [\"salmon\", \"cod\", \"tropical_fish\", \"pufferfish\"],\r\n        \"meatItems\": [\"rabbit\", \"chicken\", \"mutton\", \"beef\", \"porkchop\", \"egg\"],\r\n        \"scavengerItems\": [\"egg\", \"rotten_flesh\", \"spider_eye\"]\r\n    },\r\n    \"itemGroupCategories\": {\r\n        \"nectar\": [\"flowerItems\", \"fruitItems\"],\r\n        \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"],\r\n        \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"],\r\n        \"carnivore\": [\"meatItems\", \"fishItems\"],\r\n        \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"piscivore\": [\"seaweedItems\", \"fishItems\"],\r\n        \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"]\r\n    },\r\n    \"spawnCategories\": {\r\n        \"CourierBirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 12,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"DireWolfSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"DragonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 100,\r\n            \"spawnRandomChance\": 10,\r\n            \"chunkFreq\": 3,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"subterranean\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        },\r\n        \"GriffonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 100,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1\r\n        },\r\n        \"GeckotoaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 50,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 3,\r\n            \"chunkOffset\": 1,\r\n            \"spawnType\": \"subterranean\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        },\r\n        \"MothSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1\r\n        },\r\n        \"ColelytraSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 3,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"NetherBatSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 50,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 4\r\n        },\r\n        \"NudibranchSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 20,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"RidingLizardSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 50,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"NightmareSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 100,\r\n            \"spawnRandomChance\": 25,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 3,\r\n            \"maxIn256Region\": 5\r\n        },\r\n        \"AcenciaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"a\": 2,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"ArchelonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 10,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 2\r\n        },\r\n       \"FirebirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 2,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"village\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        }\r\n    },\r\n    \"mobConfig\": {\r\n        \"ACENCIA\": {\r\n            \"health\": 28,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"AcenciaSpawnSettings\",\r\n            \"spawnBiomes\": [\"snowyForests\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"mutton\",\"salmon\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"mutton\", \"salmon\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:sheep\",\"minecraft:goat\",\"minecraft:chicken\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"ARCHELON\": {\r\n            \"health\": 60,\r\n            \"speed\": 0.14999998807907104,\r\n            \"attack\": 6,\r\n            \"inventorySize\": 10,\r\n            \"spawnCategory\" : \"ArchelonSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:deep_lukewarm_ocean\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"cod\",\"salmon\"],\r\n            \"breedingItems\": [\"cod\",\"salmon\"],\r\n            \"foodItems\": [\"piscivore\"],\r\n            \"hostileToMobs\": [\"minecraft:salmon\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 75\r\n        },\r\n        \"COURIER_BIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"CourierBirdSpawnSettings\",\r\n            \"spawnBiomes\": [\"jungles\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"sweet_berries\"],\r\n            \"foodItems\": [\"fruitItems\"],\r\n            \"breedingItems\": [\"sweet_berries\", \"melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": true,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DIREWOLF\": {\r\n            \"health\": 30,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"DireWolfSpawnSettings\",\r\n            \"spawnBiomes\": [\"oldForests\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"bone\"],\r\n            \"breedingItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:skeleton\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DRAGON\": {\r\n            \"health\": 40,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"DragonSpawnSettings\",\r\n            \"spawnBiomes\": [\"All Overworld\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 5,\r\n            \"tamingItems\": [\"gold_ingot\",\"diamond\",\"emerald\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"breedingItems\": [\"golden_carrot\",\"golden_apple\",\"glistering_melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"GRIFFON\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"GriffonSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:windswept_gravelly_hills\",\"minecraft:windswept_forest\",\"minecraft:snowy_slopes\",\"minecraft:jagged_peaks\",\"minecraft:windswept_hills;\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\",\"mutton\"],\r\n            \"breedingItems\": [\"rabbit\",\"mutton\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:rabbit\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 50\r\n        },\r\n        \"GECKOTOA\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"GeckotoaSpawnSettings\",\r\n            \"spawnBiomes\": [\"All Overworld\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"foodItems\": [\"heartyHerbivore\"],\r\n            \"breedingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 50,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"MOTH\": {\r\n            \"health\": 10,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"MothSpawnSettings\",\r\n            \"spawnBiomes\": [\"Dark Forest Hills\",\"Dark Forest\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"seekingBlocks\": [\"minecraft:torch\", \"minecraft:redstone_torch\", \"minecraft:soul_torch\"],\r\n            \"tamingItems\": [\"flowerItems\"],\r\n            \"breedingItems\": [\"sugar\",\"melon_slice\",\"glistering_melon_slice\"],\r\n            \"foodItems\": [\"nectar\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"COLELYTRA\": {\r\n            \"health\": 14,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 5,\r\n            \"spawnCategory\" : \"ColelytraSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:mushroom_fields\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"breedingItems\": [\"mushroomItems\"],\r\n            \"foodItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"NETHER_BAT\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NetherBatSpawnSettings\",\r\n            \"spawnBiomes\": [\"Crimson Forest\",\"Warped Forest\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"porkchop\"],\r\n            \"breedingItems\": [\"porkchop\",\"apple\",\"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NUDIBRANCH\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NudibranchSpawnSettings\",\r\n            \"spawnBiomes\": [\"Warm Ocean\"],\r\n            \"spawnBlocks\": [\"minecraft:brain_coral_block\",\"minecraft:bubble_coral_block\",\"minecraft:fire_coral_block\",\"minecraft:horn_coral_block\",\"minecraft:tube_coral_block\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"seagrass\"],\r\n            \"foodItems\": [\"seaweedItems\"],\r\n            \"breedingItems\": [\"kelp\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"RIDING_LIZARD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"RidingLizardSpawnSettings\",\r\n            \"spawnBiomes\": [\"Desert\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\", \"chicken\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"pumpkin\", \"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:chicken\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"FIREBIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"FirebirdSpawnSettings\",\r\n            \"spawnBiomes\": [\"all overworld\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"golden_apple\"],\r\n            \"breedingItems\": [\"golden_apple\"],\r\n            \"foodItems\": [\"golden_apple\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NIGHTMARE\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 5,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"NightmareSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:basalt_deltas\", \"minecraft:soul_sand_valley\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 3,\r\n            \"tamingItems\": [\"bone\", \"coal\", \"charcoal\"],\r\n            \"breedingItems\": [\"blaze_rod\",\"fire_charge\"],\r\n            \"hostileToMobs\":  [\"minecraft:skeleton\",\"minecraft:wither_skeleton\"],\r\n            \"foodItems\": [\"mushroomItems\",\"rootItems\",\"bone\", \"coal\", \"charcoal\",\"blaze_rod\",\"fire_charge\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        }\r\n    }\r\n}", JsonObject.class)));
                json = (JsonObject)new Gson().fromJson((Reader)new FileReader(filename), JsonObject.class);
                Settings.parseJson(json);
            }
        }
        catch (IOException e) {
            Settings.parseJson("{\r\n    \"globalSettings\": {\r\n        \"configVersion\": 10,\r\n        \"printBiomes\": false,\r\n        \"globalDebug\": false,\r\n        \"enable3rdPersonFlying\": false,\r\n        \"enableFlyingGravity\": true,\r\n        \"disableUiOverlay\": false,\r\n        \"mobCap\": 10,\r\n        \"mobCapRange\": 192\r\n    },\r\n    \"biomeGroups\": {\r\n        \"deserts\": [\"minecraft:badlands\", \"minecraft:minecraft:wooded_badlands\", \"minecraft:eroded_badlands\", \"minecraft:savanna\", \"minecraft:savanna_plateau\", \"minecraft:windswept_savanna\", \"minecraft:desert\"],\r\n        \"jungles\": [\"minecraft:jungle\", \"minecraft:sparse_jungle\", \"minecraft:bamboo_jungle\"],\r\n        \"temperate\": [\"minecraft:plains\",\"minecraft:sunflower_plains\", \"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\"],\r\n        \"shores\": [\"minecraft:beach\",\"minecraft:snowy_beach\", \"minecraft:stony_shore\"],\r\n        \"swamps\": [\"minecraft:swamp\", \"minecraft:mangrove_swamp\"],\r\n        \"cold\": [\"minecraft:windswept_hills\", \"minecraft:windswept_gravelly_hills\", \"minecraft:windswept_forest\", \"minecraft:grove\", \"minecraft:meadow\", \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:jagged_peaks\", \"minecraft:stony_peaks\", \"minecraft:snowy_taiga\"],\r\n        \"snowy\": [ \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:snowy_plains\", \"minecraft:snowy_taiga\", \"minecraft:snowy_slopes\", \"minecraft:snowy_beach\"],\r\n        \"mountains\": [\"minecraft:windswept_hills\", \"minecraft:windswept_gravelly_hills\", \"minecraft:windswept_forest\", \"minecraft:grove\", \"minecraft:meadow\", \"minecraft:snowy_slopes\", \"minecraft:frozen_peaks\", \"minecraft:jagged_peaks\", \"minecraft:stony_peaks\"],\r\n        \"forests\": [\"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\", \"minecraft:taiga\"],\r\n        \"warmForests\": [\"minecraft:forest\", \"minecraft:flower_forest\", \"minecraft:birch_forest\", \"minecraft:dark_forest\", \"minecraft:mushroom_fields\"],\r\n        \"oldForests\": [\"minecraft:old_growth_spruce_taiga\", \"minecraft:old_growth_pine_taiga;\", \"Giant Tree Taiga Hills\", \"Giant Spruce Taiga Hills\", \"Giant Tree Taiga\", \"Giant Spruce Taiga\"],\r\n        \"snowyForests\": [\"minecraft:grove\", \"minecraft:snowy_taiga\"]\r\n    },\r\n    \"itemGroups\": {\r\n        \"flowerItems\": [\"sugar\", \"dandelion\", \"poppy\", \"blue_orchid\", \"allium\", \"azure_bluet\", \"red_tulip\", \"orange_tulip\", \"white_tulip\", \"pink_tulip\", \"oxeye_daisy\", \"cornflower\", \"lily_of_the_valley\", \"lilac\", \"rose_bush\", \"peony\", \"flowering_azalea_leaves\"],\r\n        \"grassItems\": [\"hay\", \"grass\", \"fern\", \"tall_grass\", \"large_fern\", \"bamboo\"],\r\n        \"leafItems\": [\"oak_leaves\", \"spruce_leaves\", \"birch_leaves\", \"jungle_leaves\", \"acacia_leaves\", \"dark_oak_leaves\", \"azalea_leaves\", \"flowering_azalea_leaves\", \"lily_pad\", \"small_dripleaf\", \"big_dripleaf\"],\r\n        \"mushroomItems\": [\"brown_mushroom\", \"red_mushroom\", \"crimson_fungus\", \"warped_fungus\"],\r\n        \"rootItems\": [\"cave_vines\", \"vines\", \"hanging_roots\", \"glow_lichen\", \"crimson_roots\", \"warped_roots\", \"nether_wart\", \"cactus\"],\r\n        \"seedItems\": [\"wheat_seeds\", \"melon_seeds\", \"pumpkin_seeds\", \"beetroot_seeds\", \"sweet_berries\"],\r\n        \"vegetableItems\": [\"potato\", \"carrot\", \"beetroot\"],\r\n        \"fruitItems\": [\"sweet_berries\", \"melon_slice\", \"apple\", \"glow_berries\"],\r\n        \"seaweedItems\": [\"seagrass\", \"kelp\", \"tall_seagrass\"],\r\n        \"fishItems\": [\"salmon\", \"cod\", \"tropical_fish\", \"pufferfish\"],\r\n        \"meatItems\": [\"rabbit\", \"chicken\", \"mutton\", \"beef\", \"porkchop\", \"egg\"],\r\n        \"scavengerItems\": [\"egg\", \"rotten_flesh\", \"spider_eye\"]\r\n    },\r\n    \"itemGroupCategories\": {\r\n        \"nectar\": [\"flowerItems\", \"fruitItems\"],\r\n        \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"],\r\n        \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"],\r\n        \"carnivore\": [\"meatItems\", \"fishItems\"],\r\n        \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"piscivore\": [\"seaweedItems\", \"fishItems\"],\r\n        \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"]\r\n    },\r\n    \"spawnCategories\": {\r\n        \"CourierBirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 12,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"DireWolfSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"DragonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 100,\r\n            \"spawnRandomChance\": 10,\r\n            \"chunkFreq\": 3,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"subterranean\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        },\r\n        \"GriffonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 100,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1\r\n        },\r\n        \"GeckotoaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 50,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 3,\r\n            \"chunkOffset\": 1,\r\n            \"spawnType\": \"subterranean\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        },\r\n        \"MothSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1\r\n        },\r\n        \"ColelytraSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 3,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"NetherBatSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 50,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 4\r\n        },\r\n        \"NudibranchSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 20,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 4\r\n        },\r\n        \"RidingLizardSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 50,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"NightmareSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 100,\r\n            \"spawnRandomChance\": 25,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"minSpawnGroupSize\": 2,\r\n            \"maxSpawnGroupSize\": 3,\r\n            \"maxIn256Region\": 5\r\n        },\r\n        \"AcenciaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\",\r\n            \"a\": 2,\r\n            \"maxSpawnGroupSize\": 3\r\n        },\r\n        \"ArchelonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 10,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 2\r\n        },\r\n       \"FirebirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 1,\r\n            \"spawnRandomChance\": 2,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"village\",\r\n            \"minSpawnGroupSize\": 1,\r\n            \"maxSpawnGroupSize\": 1,\r\n            \"maxIn256Region\": 1\r\n        }\r\n    },\r\n    \"mobConfig\": {\r\n        \"ACENCIA\": {\r\n            \"health\": 28,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"AcenciaSpawnSettings\",\r\n            \"spawnBiomes\": [\"snowyForests\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"mutton\",\"salmon\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"mutton\", \"salmon\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:sheep\",\"minecraft:goat\",\"minecraft:chicken\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"ARCHELON\": {\r\n            \"health\": 60,\r\n            \"speed\": 0.14999998807907104,\r\n            \"attack\": 6,\r\n            \"inventorySize\": 10,\r\n            \"spawnCategory\" : \"ArchelonSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:deep_lukewarm_ocean\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"cod\",\"salmon\"],\r\n            \"breedingItems\": [\"cod\",\"salmon\"],\r\n            \"foodItems\": [\"piscivore\"],\r\n            \"hostileToMobs\": [\"minecraft:salmon\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 75\r\n        },\r\n        \"COURIER_BIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"CourierBirdSpawnSettings\",\r\n            \"spawnBiomes\": [\"jungles\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"sweet_berries\"],\r\n            \"foodItems\": [\"fruitItems\"],\r\n            \"breedingItems\": [\"sweet_berries\", \"melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": true,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DIREWOLF\": {\r\n            \"health\": 30,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"DireWolfSpawnSettings\",\r\n            \"spawnBiomes\": [\"oldForests\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"bone\"],\r\n            \"breedingItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:skeleton\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DRAGON\": {\r\n            \"health\": 40,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"DragonSpawnSettings\",\r\n            \"spawnBiomes\": [\"All Overworld\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 5,\r\n            \"tamingItems\": [\"gold_ingot\",\"diamond\",\"emerald\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"breedingItems\": [\"golden_carrot\",\"golden_apple\",\"glistering_melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"GRIFFON\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"GriffonSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:windswept_gravelly_hills\",\"minecraft:windswept_forest\",\"minecraft:snowy_slopes\",\"minecraft:jagged_peaks\",\"minecraft:windswept_hills;\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\",\"mutton\"],\r\n            \"breedingItems\": [\"rabbit\",\"mutton\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:rabbit\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 50\r\n        },\r\n        \"GECKOTOA\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"GeckotoaSpawnSettings\",\r\n            \"spawnBiomes\": [\"All Overworld\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"foodItems\": [\"heartyHerbivore\"],\r\n            \"breedingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 50,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"MOTH\": {\r\n            \"health\": 10,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"MothSpawnSettings\",\r\n            \"spawnBiomes\": [\"Dark Forest Hills\",\"Dark Forest\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"seekingBlocks\": [\"minecraft:torch\", \"minecraft:redstone_torch\", \"minecraft:soul_torch\"],\r\n            \"tamingItems\": [\"flowerItems\"],\r\n            \"breedingItems\": [\"sugar\",\"melon_slice\",\"glistering_melon_slice\"],\r\n            \"foodItems\": [\"nectar\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"COLELYTRA\": {\r\n            \"health\": 14,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 5,\r\n            \"spawnCategory\" : \"ColelytraSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:mushroom_fields\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"breedingItems\": [\"mushroomItems\"],\r\n            \"foodItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"NETHER_BAT\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NetherBatSpawnSettings\",\r\n            \"spawnBiomes\": [\"Crimson Forest\",\"Warped Forest\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"porkchop\"],\r\n            \"breedingItems\": [\"porkchop\",\"apple\",\"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NUDIBRANCH\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NudibranchSpawnSettings\",\r\n            \"spawnBiomes\": [\"Warm Ocean\"],\r\n            \"spawnBlocks\": [\"minecraft:brain_coral_block\",\"minecraft:bubble_coral_block\",\"minecraft:fire_coral_block\",\"minecraft:horn_coral_block\",\"minecraft:tube_coral_block\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"seagrass\"],\r\n            \"foodItems\": [\"seaweedItems\"],\r\n            \"breedingItems\": [\"kelp\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"RIDING_LIZARD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"RidingLizardSpawnSettings\",\r\n            \"spawnBiomes\": [\"Desert\"],\r\n            \"diet\": \"carnivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\", \"chicken\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"pumpkin\", \"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:chicken\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"FIREBIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"FirebirdSpawnSettings\",\r\n            \"spawnBiomes\": [\"all overworld\"],\r\n            \"diet\": \"herbivore\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"golden_apple\"],\r\n            \"breedingItems\": [\"golden_apple\"],\r\n            \"foodItems\": [\"golden_apple\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NIGHTMARE\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 5,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"NightmareSpawnSettings\",\r\n            \"spawnBiomes\": [\"minecraft:basalt_deltas\", \"minecraft:soul_sand_valley\"],\r\n            \"diet\": \"omnivore\",\r\n            \"tamingChance\": 3,\r\n            \"tamingItems\": [\"bone\", \"coal\", \"charcoal\"],\r\n            \"breedingItems\": [\"blaze_rod\",\"fire_charge\"],\r\n            \"hostileToMobs\":  [\"minecraft:skeleton\",\"minecraft:wither_skeleton\"],\r\n            \"foodItems\": [\"mushroomItems\",\"rootItems\",\"bone\", \"coal\", \"charcoal\",\"blaze_rod\",\"fire_charge\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        }\r\n    }\r\n}");
            try {
                ConfigFileHelper.createDefaultSettings();
                System.out.println("No config file found. Created new config file for mythicmounts mod.");
            }
            catch (IOException ioException) {
                System.out.println("Warning: Was not able to find or create a config file for mythicmounts mod. Using built-in settings.");
            }
        }
    }

    private static JsonObject mergeJson(JsonObject oldJson, JsonObject newJson) {
        String[] sections = new String[]{"globalSettings", "biomeGroups", "itemGroups", "itemGroupCategories", "spawnCategories", "mobConfig"};
        JsonObject mergedJson = new JsonObject();
        for (int i = 0; i < sections.length; ++i) {
            if (oldJson.has(sections[i]) && oldJson.get(sections[i]).isJsonObject()) {
                mergedJson.add(sections[i], (JsonElement)Settings.mergeSubJson(oldJson.get(sections[i]).getAsJsonObject(), newJson.get(sections[i]).getAsJsonObject()));
                continue;
            }
            if (!newJson.has(sections[i]) || !newJson.get(sections[i]).isJsonObject()) continue;
            mergedJson.add(sections[i], newJson.get(sections[i]));
        }
        return mergedJson;
    }

    private static JsonObject mergeSubJson(JsonObject oldJson, JsonObject newJson) {
        JsonElement element;
        JsonObject mergedJson = new JsonObject();
        Set oldKeySet = oldJson.keySet();
        Set newKeySet = newJson.keySet();
        for (String key : oldKeySet) {
            element = oldJson.get(key);
            if ("configVersion".equals(key)) {
                element = newJson.get(key);
            }
            mergedJson.add(key, element);
        }
        for (String key : newKeySet) {
            element = newJson.get(key);
            if (mergedJson.has(key)) continue;
            mergedJson.add(key, element);
        }
        return mergedJson;
    }

    private static void parseJson(String jsonStr) {
        JsonObject json = (JsonObject)new Gson().fromJson(jsonStr, JsonObject.class);
        Settings.parseJson(json);
    }

    private static void parseJson(JsonObject json) {
        JsonObject globalJson = json.getAsJsonObject("globalSettings");
        globalSettings = new GlobalSettings(globalJson);
        biomeJson = json.getAsJsonObject("biomeGroups");
        spawnCategories = json.getAsJsonObject("spawnCategories");
        itemGroupJson = json.getAsJsonObject("itemGroups");
        itemGroupCategoryJson = json.getAsJsonObject("itemGroupCategories");
        mobJson = json.getAsJsonObject("mobGroups");
        JsonObject mobJson = json.getAsJsonObject("mobConfig");
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            if (!mobJson.has(key.toString())) continue;
            settings.put(key, new EntitySettings(key, mobJson.getAsJsonObject(key.toString())));
        }
    }

    public static boolean parseBool(boolean defaultVal, JsonElement e) {
        return e != null ? e.getAsBoolean() : defaultVal;
    }

    public static int parseInt(int defaultVal, JsonElement e) {
        return e != null ? e.getAsInt() : defaultVal;
    }

    public static double parseDouble(double defaultVal, JsonElement e) {
        return e != null ? e.getAsDouble() : defaultVal;
    }

    public static String parseString(String defaultVal, JsonElement e) {
        return e != null ? e.getAsString() : defaultVal;
    }

    public static class_1792 parseMinecraftItem(String itemName) {
        if (!"none".equals(itemName.trim().toLowerCase(Locale.ROOT))) {
            try {
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemName));
                if (item != null && !item.equals(class_2246.field_10124.method_8389())) {
                    return item;
                }
            }
            catch (Exception e) {
                System.out.println("WARNING: " + itemName + " is not a valid Minecraft item (skipping). [You can fix this by editing/removing the references to " + itemName + " in mythicmounts's config file]");
            }
        }
        return null;
    }

    public static class_1299 parseMinecraftEntity(String entityName) {
        String entityName2 = entityName.trim();
        if (!"none".equals(entityName2)) {
            Optional type = class_1299.method_5898((String)entityName2);
            if (type.isPresent()) {
                return (class_1299)type.get();
            }
            System.out.println("WARNING: " + entityName2 + " is not a valid Minecraft entity type (skipping). [You can fix this by editing/removing the references to " + entityName + " in mythicmounts's config file]");
        }
        return null;
    }

    public static class_1792[] parseCompoundItems(JsonObject json, String attributeName) {
        ArrayList<class_1792> parsedItems = new ArrayList<class_1792>();
        if (json.get(attributeName) != null && json.get(attributeName).isJsonArray()) {
            for (JsonElement str : json.getAsJsonArray(attributeName)) {
                String itemElementName = str.getAsString();
                if (itemGroupCategoryJson.get(itemElementName) != null && itemGroupCategoryJson.get(itemElementName).isJsonArray()) {
                    for (JsonElement itemGroup : itemGroupCategoryJson.get(itemElementName).getAsJsonArray()) {
                        if (itemGroupJson.get(itemGroup.getAsString()) == null) continue;
                        for (JsonElement item : itemGroupJson.get(itemGroup.getAsString()).getAsJsonArray()) {
                            class_1792 i = Settings.parseMinecraftItem(item.getAsString());
                            if (i == null) continue;
                            parsedItems.add(i);
                        }
                    }
                    continue;
                }
                if (itemGroupJson.get(itemElementName) != null) {
                    for (JsonElement item : itemGroupJson.get(itemElementName).getAsJsonArray()) {
                        class_1792 i = Settings.parseMinecraftItem(item.getAsString());
                        if (i == null) continue;
                        parsedItems.add(i);
                    }
                    continue;
                }
                class_1792 i = Settings.parseMinecraftItem(itemElementName);
                if (i == null) continue;
                parsedItems.add(i);
            }
        }
        class_1792[] items = new class_1792[parsedItems.size()];
        items = parsedItems.toArray(items);
        return items;
    }

    public static class GlobalSettings {
        public int configVersion = 0;
        public boolean disableGravity = false;
        public boolean mountedFlightAllowed = true;
        public boolean printBiomes = false;
        public boolean enable3rdPersonFlying = false;
        public boolean disableUiOverlay = false;
        public boolean debug = false;
        public int mobCap = 100;
        public int mobCapRange = 192;
        public class_1792 commandItem = class_1802.field_8600;

        public GlobalSettings(JsonObject json) {
            this.configVersion = Settings.parseInt(this.configVersion, json.get("configVersion"));
            this.mobCap = Settings.parseInt(this.mobCap, json.get("mobCap"));
            this.mobCapRange = Settings.parseInt(this.mobCapRange, json.get("mobCapRange"));
            this.printBiomes = Settings.parseBool(this.printBiomes, json.get("printBiomes"));
            this.disableGravity = !Settings.parseBool(this.disableGravity, json.get("enableFlyingGravity"));
            this.enable3rdPersonFlying = Settings.parseBool(this.enable3rdPersonFlying, json.get("enable3rdPersonFlying"));
            this.mountedFlightAllowed = Settings.parseBool(this.mountedFlightAllowed, json.get("mountedFlightAllowed"));
            this.disableUiOverlay = Settings.parseBool(this.disableUiOverlay, json.get("disableUiOverlay"));
            this.debug = Settings.parseBool(this.debug, json.get("globalDebug"));
            String item = Settings.parseString("minecraft:stick", json.get("commandItem"));
            this.commandItem = Settings.parseMinecraftItem(item);
        }
    }

    public static class EntitySettings {
        public boolean shouldSpawn = true;
        public boolean spawnDebug = false;
        public int spawnWeight = 5;
        public int spawnRandomChance = 5;
        public int spawnYCeiling = 50000;
        public int spawnYFloor = -50000;
        public int minSpawnGroupSize = 1;
        public int maxSpawnGroupSize = 3;
        public int maxIn256Region = -1;
        public String diet = "omnivore";
        public String spawnType = "overworld";
        public String temperature = "all";
        public String precipitation = "all";
        public int inventorySize = 3;
        public int chunkFreq = 0;
        public int chunkOffset = 0;
        public double attack = 1.0;
        public double speed = 0.2;
        public double health = 4.0;
        public boolean fleeFromPlayer = false;
        public boolean playerHostile = false;
        public boolean battleWithOwner = true;
        public boolean followOwner = false;
        public int tamingChance = 33;
        public double volume = 25.0;
        public boolean specialAbilitiesEnabled = true;
        public String[] spawnBiomes = new String[0];
        public String[] spawnBlocks = new String[0];
        public String[] seekingBlocks = new String[0];
        public class_1299[] mobHostile = new class_1299[0];
        public class_1792[] tamingItems = new class_1792[0];
        public class_1792[] breedingItems = new class_1792[0];
        public class_1792[] foodItems = new class_1792[0];

        public EntitySettings(Entities.EntityKey entityKey, JsonObject json) {
            this.fleeFromPlayer = Settings.parseBool(this.fleeFromPlayer, json.get("fleeFromPlayer"));
            this.playerHostile = Settings.parseBool(this.playerHostile, json.get("playerHostile"));
            this.battleWithOwner = Settings.parseBool(this.battleWithOwner, json.get("battleWithOwner"));
            this.followOwner = Settings.parseBool(this.followOwner, json.get("followOwner"));
            this.attack = Settings.parseDouble(this.attack, json.get("attack"));
            this.health = Settings.parseDouble(this.health, json.get("health"));
            this.speed = Settings.parseDouble(this.speed, json.get("speed"));
            this.volume = Settings.parseDouble(this.volume, json.get("loudness"));
            this.diet = Settings.parseString(this.diet, json.get("diet"));
            this.inventorySize = Settings.parseInt(this.inventorySize, json.get("inventorySize"));
            this.tamingChance = Settings.parseInt(this.tamingChance, json.get("tamingChance"));
            if (json.get("spawnCategory") != null && spawnCategories != null && spawnCategories.getAsJsonObject(json.get("spawnCategory").getAsString()) != null) {
                JsonObject spawnJson = spawnCategories.getAsJsonObject(json.get("spawnCategory").getAsString());
                this.shouldSpawn = Settings.parseBool(this.shouldSpawn, spawnJson.get("shouldSpawn"));
                this.shouldSpawn = Settings.parseBool(this.shouldSpawn, spawnJson.get("shouldSpawn"));
                this.specialAbilitiesEnabled = Settings.parseBool(this.specialAbilitiesEnabled, spawnJson.get("specialAbilitiesEnabled"));
                this.spawnWeight = Settings.parseInt(this.spawnWeight, spawnJson.get("spawnWeight"));
                this.spawnRandomChance = Settings.parseInt(this.spawnRandomChance, spawnJson.get("spawnRandomChance"));
                this.spawnYCeiling = Settings.parseInt(this.spawnYCeiling, spawnJson.get("spawnYCeiling"));
                this.spawnYFloor = Settings.parseInt(this.spawnYFloor, spawnJson.get("spawnYFloor"));
                this.minSpawnGroupSize = Settings.parseInt(this.minSpawnGroupSize, spawnJson.get("minSpawnGroupSize"));
                this.maxSpawnGroupSize = Settings.parseInt(this.maxSpawnGroupSize, spawnJson.get("maxSpawnGroupSize"));
                this.maxIn256Region = Settings.parseInt(this.maxIn256Region, spawnJson.get("maxIn256Region"));
                this.chunkFreq = Settings.parseInt(this.chunkFreq, spawnJson.get("chunkFreq"));
                this.chunkOffset = Settings.parseInt(this.chunkOffset, spawnJson.get("chunkOffset"));
                this.spawnType = Settings.parseString(this.spawnType, spawnJson.get("spawnType"));
                this.temperature = Settings.parseString(this.temperature, spawnJson.get("temperature"));
                this.precipitation = Settings.parseString(this.precipitation, spawnJson.get("precipitation"));
                if (this.minSpawnGroupSize > this.maxSpawnGroupSize) {
                    System.out.println("WARNING: minSpawnGroupSize should be <= maxSpawnGroupSize for " + entityKey + "'s spawnCategory " + json.getAsJsonObject("spawnCategory") + ". [You can fix this in mythicmounts's config file]");
                    this.maxSpawnGroupSize = this.minSpawnGroupSize;
                }
                if (this.spawnYFloor > this.spawnYCeiling) {
                    System.out.println("WARNING: spawnYFloor should be <= spawnYCeiling for " + entityKey + "'s spawnCategory " + json.getAsJsonObject("spawnCategory") + ". [You can fix this in mythicmounts's config file]");
                    this.spawnYCeiling = this.spawnYFloor;
                }
            } else {
                System.out.println("WARNING: No spawnCategory defined for " + entityKey + ". [You can fix this by adding a category to this mob's settings in mythicmounts's config file]");
            }
            ArrayList<String> parsedBiomes = new ArrayList<String>();
            if (json.get("spawnBiomes") != null && json.get("spawnBiomes").isJsonArray()) {
                for (Object str : json.getAsJsonArray("spawnBiomes")) {
                    String biomeElementName = str.getAsString();
                    if (biomeJson.get(biomeElementName) != null) {
                        for (JsonElement biome : biomeJson.get(biomeElementName).getAsJsonArray()) {
                            parsedBiomes.add(biome.getAsString());
                        }
                        continue;
                    }
                    parsedBiomes.add(biomeElementName);
                }
            }
            this.spawnBiomes = new String[parsedBiomes.size()];
            this.spawnBiomes = parsedBiomes.toArray(this.spawnBiomes);
            ArrayList<String> parsedBlocks = new ArrayList<String>();
            if (json.get("spawnBlocks") != null) {
                for (JsonElement block : json.get("spawnBlocks").getAsJsonArray()) {
                    parsedBlocks.add(block.getAsString());
                }
            }
            this.spawnBlocks = new String[parsedBlocks.size()];
            this.spawnBlocks = parsedBlocks.toArray(this.spawnBlocks);
            parsedBlocks = new ArrayList();
            if (json.get("seekingBlocks") != null) {
                for (JsonElement block : json.get("seekingBlocks").getAsJsonArray()) {
                    parsedBlocks.add(block.getAsString());
                }
            }
            this.seekingBlocks = new String[parsedBlocks.size()];
            this.seekingBlocks = parsedBlocks.toArray(this.seekingBlocks);
            this.breedingItems = Settings.parseCompoundItems(json, "breedingItems");
            this.tamingItems = Settings.parseCompoundItems(json, "tamingItems");
            this.foodItems = Settings.parseCompoundItems(json, "foodItems");
            ArrayList<class_1299> parsedEntities = new ArrayList<class_1299>();
            if (json.get("hostileToMobs") != null && json.get("hostileToMobs").isJsonArray()) {
                for (JsonElement str : json.getAsJsonArray("hostileToMobs")) {
                    String mobElementName = str.getAsString();
                    if (mobJson != null && mobJson.get(mobElementName) != null) {
                        for (JsonElement entity : mobJson.get(mobElementName).getAsJsonArray()) {
                            class_1299 e = Settings.parseMinecraftEntity(entity.getAsString());
                            if (e == null) continue;
                            parsedEntities.add(e);
                        }
                        continue;
                    }
                    class_1299 e = Settings.parseMinecraftEntity(mobElementName);
                    if (e == null) continue;
                    parsedEntities.add(e);
                }
            }
            this.mobHostile = new class_1299[parsedEntities.size()];
            this.mobHostile = parsedEntities.toArray(this.mobHostile);
        }

        public String toString() {
            return "shouldSpawn: " + this.shouldSpawn + "\nspawnDebug: " + this.spawnDebug + "\nspawnType: " + this.spawnType + "\nspawnWeight: " + this.spawnWeight + "\nspawnRandomChance: " + this.spawnRandomChance + "/ spawnYCeiling: " + this.spawnYCeiling + "\nmaxIn256Region: " + this.maxIn256Region + "\nchunkFreq: " + this.chunkFreq + " / chunkOffset: " + this.chunkOffset + "\nminSpawnGroupSize: " + this.minSpawnGroupSize + " / maxSpawnGroupSize: " + this.maxSpawnGroupSize + "\ntemperature: " + this.temperature + " / precipitation: " + this.precipitation + "\ntamingChance: " + this.tamingChance + "; inventorySize: " + this.inventorySize + "; attack: " + this.attack + "; speed: " + this.speed + "; health: " + this.health + "; diet: " + this.diet + "\nfleeFromPlayer: " + this.fleeFromPlayer + "; playerHostile: " + this.playerHostile + "; battleWithOwner: " + this.battleWithOwner + "; followOwner: " + this.followOwner + "; specialAbilitiesEnabled: " + this.specialAbilitiesEnabled + "\nvolume: " + this.volume + "\nspawnBiomes: " + Arrays.toString(this.spawnBiomes) + "\nspawnBlocks: " + Arrays.toString(this.spawnBlocks) + "\nseekingBlocks: " + Arrays.toString(this.seekingBlocks) + "\ntamingItems: " + Arrays.toString(this.tamingItems) + "\nbreedingItems: " + Arrays.toString(this.breedingItems) + "\nfoodItems: " + Arrays.toString(this.foodItems);
        }
    }
}

