/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class StringProperty
extends TeamProperty<String> {
    private final Pattern pattern;

    public StringProperty(class_2960 id, String def, @Nullable Pattern p) {
        super(id, def);
        this.pattern = p;
    }

    public StringProperty(class_2960 id, String def) {
        this(id, def, null);
    }

    public StringProperty(class_2960 id, class_2540 buf) {
        super(id, buf.method_10800(Short.MAX_VALUE));
        int f = buf.method_10816();
        String s = buf.method_10800(Short.MAX_VALUE);
        this.pattern = s.isEmpty() ? null : Pattern.compile(s, f);
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.STRING;
    }

    @Override
    public Optional<String> fromString(String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            return Optional.of(string);
        }
        return Optional.empty();
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10788((String)this.defaultValue, Short.MAX_VALUE);
        buf.method_10804(this.pattern == null ? 0 : this.pattern.flags());
        buf.method_10788(this.pattern == null ? "" : this.pattern.pattern(), Short.MAX_VALUE);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addString(this.id.method_12832(), (String)value.value, value.consumer, (String)this.defaultValue, this.pattern);
    }
}

