/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class StringListProperty
extends TeamProperty<List<String>> {
    public StringListProperty(class_2960 id, List<String> def) {
        super(id, def);
    }

    public StringListProperty(class_2960 id, class_2540 buf) {
        this(id, buf.method_34066(b -> b.method_10800(Short.MAX_VALUE)));
    }

    @Override
    public TeamPropertyType<List<String>> getType() {
        return TeamPropertyType.STRING_LIST;
    }

    @Override
    public Optional<List<String>> fromString(String string) {
        return string.length() > 2 && string.startsWith("[") && string.endsWith("]") ? Optional.of(new ArrayList<String>(Arrays.asList(string.substring(1, string.length() - 1).split("\t")))) : Optional.empty();
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34062((Collection)this.defaultValue, class_2540::method_10814);
    }

    @Override
    public String toString(List<String> value) {
        return "[" + String.join((CharSequence)"\t", value) + "]";
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<List<String>> value) {
        config.addList(this.id.method_12832(), (List)value.value, (ConfigValue)new StringConfig(), (Object)"");
    }

    @Override
    public class_2520 toNBT(List<String> value) {
        class_2499 res = new class_2499();
        value.forEach(s -> res.add((Object)class_2519.method_23256((String)s)));
        return res;
    }

    @Override
    public Optional<List<String>> fromNBT(class_2520 tag) {
        ArrayList res = new ArrayList();
        if (tag instanceof class_2499) {
            class_2499 l = (class_2499)tag;
            l.forEach(t -> res.add(t.method_10714()));
            return Optional.of(res);
        }
        return Optional.empty();
    }
}

