/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class TeamArgument
implements ArgumentType<TeamArgumentProvider> {
    public static final SimpleCommandExceptionType ALREADY_IN_PARTY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.already_in_party"));
    public static final DynamicCommandExceptionType PLAYER_IN_PARTY = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.player_already_in_party", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_IN_PARTY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.not_in_party"));
    public static final DynamicCommandExceptionType TEAM_NOT_FOUND = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.team_not_found", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType CANT_EDIT = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.cant_edit", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType NOT_MEMBER = new Dynamic2CommandExceptionType((a, b) -> class_2561.method_43469((String)"ftbteams.not_member", (Object[])new Object[]{a, b}));
    public static final Dynamic2CommandExceptionType NOT_OFFICER = new Dynamic2CommandExceptionType((a, b) -> class_2561.method_43469((String)"ftbteams.not_officer", (Object[])new Object[]{a, b}));
    public static final DynamicCommandExceptionType NOT_INVITED = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbteams.not_invited", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType OWNER_CANT_LEAVE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.owner_cant_leave"));
    public static final SimpleCommandExceptionType CANT_KICK_OWNER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.cant_kick_owner"));
    public static final SimpleCommandExceptionType API_OVERRIDE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.api_override"));
    public static final SimpleCommandExceptionType NAME_TOO_SHORT = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbteams.name_too_short"));

    public static TeamArgument create() {
        return new TeamArgument();
    }

    public static Team get(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return ((TeamArgumentProvider)context.getArgument(name, TeamArgumentProvider.class)).getTeam((class_2168)context.getSource());
    }

    private TeamArgument() {
    }

    public TeamArgumentProvider parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            class_2300 selector = new class_2303(reader).method_9882();
            if (selector.method_9819()) {
                throw class_2186.field_9861.create();
            }
            return new SelectorProvider(selector);
        }
        int i = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return new IDProvider(reader.getString().substring(i, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        if (commandContext.getSource() instanceof class_2172) {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            if (commandContext.getSource() instanceof class_2168) {
                if (FTBTeamsAPI.isManagerLoaded()) {
                    for (Team team : FTBTeamsAPI.getManager().getTeams()) {
                        if (team.getType().isPlayer()) continue;
                        list.add(team.getStringID());
                    }
                }
            } else if (ClientTeamManager.INSTANCE != null && !ClientTeamManager.INSTANCE.isInvalid()) {
                for (ClientTeam team : ClientTeamManager.INSTANCE.teamMap.values()) {
                    if (team.getType().isPlayer()) continue;
                    list.add(team.getStringID());
                }
            }
            list.addAll(((class_2172)commandContext.getSource()).method_9262());
            return class_2172.method_9265(list, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private static class SelectorProvider
    implements TeamArgumentProvider {
        private final class_2300 selector;

        private SelectorProvider(class_2300 s) {
            this.selector = s;
        }

        @Override
        public Team getTeam(class_2168 source) throws CommandSyntaxException {
            return FTBTeamsAPI.getManager().getPlayerTeam(this.selector.method_9811(source));
        }
    }

    private static class IDProvider
    implements TeamArgumentProvider {
        private final String id;

        private IDProvider(String s) {
            this.id = s;
        }

        private CommandSyntaxException error() {
            return TEAM_NOT_FOUND.create((Object)this.id);
        }

        @Override
        public Team getTeam(class_2168 source) throws CommandSyntaxException {
            Team team = FTBTeamsAPI.getManager().getTeamNameMap().get(this.id);
            if (team != null) {
                return team;
            }
            return source.method_9211().method_3793().method_14515(this.id).map(GameProfile::getId).map(FTBTeamsAPI.getManager()::getPlayerTeam).orElseThrow(this::error);
        }
    }

    public static class Info
    implements class_2314<TeamArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 friendlyByteBuf) {
        }

        public Template deserializeFromNetwork(class_2540 friendlyByteBuf) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
        }

        public Template unpack(TeamArgument argumentType) {
            return new Template();
        }

        public final class Template
        implements class_2314.class_7217<TeamArgument> {
            public TeamArgument instantiate(class_7157 commandBuildContext) {
                return TeamArgument.create();
            }

            public class_2314<TeamArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

