/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class KnownClientPlayer
implements Comparable<KnownClientPlayer> {
    public final UUID uuid;
    public String name;
    public boolean online;
    public UUID teamId;
    private GameProfile profile;
    private class_2487 extraData;

    public KnownClientPlayer(PlayerTeam pt) {
        this.uuid = pt.getId();
        this.name = pt.playerName;
        this.online = pt.online;
        this.teamId = pt.actualTeam.getId();
        this.extraData = pt.getExtraData();
    }

    public KnownClientPlayer(class_2540 buf) {
        this.uuid = buf.method_10790();
        this.name = buf.method_10800(Short.MAX_VALUE);
        this.online = buf.readBoolean();
        this.teamId = buf.method_10790();
        this.extraData = buf.method_30617();
    }

    public void update(KnownClientPlayer p) {
        this.name = p.name;
        this.online = p.online;
        this.teamId = p.teamId;
        this.profile = null;
        this.extraData = p.extraData;
    }

    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(this.uuid, this.name);
        }
        return this.profile;
    }

    public void write(class_2540 buf) {
        buf.method_10797(this.uuid);
        buf.method_10788(this.name, Short.MAX_VALUE);
        buf.writeBoolean(this.online);
        buf.method_10797(this.teamId);
        buf.method_10794(this.extraData);
    }

    public boolean isInternalTeam() {
        return this.teamId.equals(this.uuid);
    }

    public boolean isOnlineAndNotInParty() {
        return this.online && this.isInternalTeam();
    }

    public class_2487 getExtraData() {
        return this.extraData;
    }

    @Override
    public int compareTo(KnownClientPlayer o) {
        int i = Boolean.compare(o.isOnlineAndNotInParty(), this.isOnlineAndNotInParty());
        return i == 0 ? this.name.compareToIgnoreCase(o.name) : i;
    }
}

