/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.TeamPropertyArgument;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsCommands {
    private Predicate<class_2168> requiresOPorSP() {
        return source -> source.method_9211().method_3724() || source.method_9259(2);
    }

    private RequiredArgumentBuilder<class_2168, TeamArgumentProvider> teamArg() {
        return class_2170.method_9244((String)"team", (ArgumentType)TeamArgument.create());
    }

    private String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(class_2168 source) {
        if (source.method_9228() instanceof class_3222) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.method_9228().method_5667());
            return team != null && !team.getType().isParty();
        }
        return false;
    }

    private boolean hasParty(class_2168 source, TeamRank rank) {
        if (source.method_9228() instanceof class_3222) {
            Team team = FTBTeamsAPI.getPlayerTeam(source.method_9228().method_5667());
            return team != null && team.getType().isParty() && team.getHighestRank(source.method_9228().method_5667()).is(rank);
        }
        return false;
    }

    private Team team(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return FTBTeamsAPI.getPlayerTeam(player);
    }

    private Team teamArg(CommandContext<class_2168> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private Team teamArg(CommandContext<class_2168> context, TeamType type) throws CommandSyntaxException {
        Team team = this.teamArg(context);
        if (team.getType() != type) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private ServerTeam serverTeamArg(CommandContext<class_2168> context) throws CommandSyntaxException {
        return (ServerTeam)this.teamArg(context, TeamType.SERVER);
    }

    private PartyTeam partyTeamArg(CommandContext<class_2168> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)this.teamArg(context, TeamType.PARTY);
        if (rank != TeamRank.NONE && !team.getHighestRank(((class_2168)context.getSource()).method_9207().method_5667()).is(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private PartyTeam team(CommandContext<class_2168> context, TeamRank rank) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        if (!team.getHighestRank(player.method_5667()).is(rank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return (PartyTeam)team;
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(this::hasNoParty)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((class_2168)ctx.getSource()).method_9207(), this.string(ctx, "name")).getLeft()))).executes(ctx -> (Integer)TeamManager.INSTANCE.createParty(((class_2168)ctx.getSource()).method_9207(), "").getLeft()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"join").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<class_2168>)ctx, TeamRank.INVITED).join((class_2168)ctx.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deny_invite").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<class_2168>)ctx, TeamRank.INVITED).denyInvite((class_2168)ctx.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"leave").requires(source -> this.hasParty((class_2168)source, TeamRank.MEMBER))).executes(ctx -> ((PartyTeam)this.team((CommandContext<class_2168>)ctx)).leave(((class_2168)ctx.getSource()).method_9207().method_5667())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"invite").requires(source -> this.hasParty((class_2168)source, TeamRank.OFFICER))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OFFICER).invite(((class_2168)ctx.getSource()).method_9207(), class_2191.method_9330((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"kick").requires(source -> this.hasParty((class_2168)source, TeamRank.OFFICER))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OFFICER).kick((class_2168)ctx.getSource(), class_2191.method_9330((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transfer_ownership").requires(source -> this.hasParty((class_2168)source, TeamRank.OWNER))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OWNER).transferOwnership(((class_2168)ctx.getSource()).method_9207(), class_2186.method_9315((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(source -> this.hasParty((class_2168)source, TeamRank.OWNER))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OWNER).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OWNER).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), ""))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"settings_for").requires(this.requiresOPorSP())).then(this.teamArg().then(((RequiredArgumentBuilder)class_2170.method_9244((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.teamArg((CommandContext<class_2168>)ctx, TeamType.PARTY).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.teamArg((CommandContext<class_2168>)ctx, TeamType.PARTY).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), "")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"allies").requires(source -> this.hasParty((class_2168)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> this.hasParty((class_2168)source, TeamRank.OFFICER))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OFFICER).addAlly((class_2168)ctx.getSource(), class_2191.method_9330((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> this.hasParty((class_2168)source, TeamRank.OFFICER))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.OFFICER).removeAlly((class_2168)ctx.getSource(), class_2191.method_9330((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> this.hasParty((class_2168)source, TeamRank.MEMBER))).executes(ctx -> this.team((CommandContext<class_2168>)ctx, TeamRank.MEMBER).listAllies((class_2168)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"server").requires(this.requiresOPorSP())).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManager.INSTANCE.createServer((class_2168)ctx.getSource(), this.string(ctx, "name")).getLeft())))).then(class_2170.method_9247((String)"delete").then(this.teamArg().executes(ctx -> this.serverTeamArg((CommandContext<class_2168>)ctx).delete((class_2168)ctx.getSource()))))).then(class_2170.method_9247((String)"settings").then(this.teamArg().then(((RequiredArgumentBuilder)class_2170.method_9244((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.serverTeamArg((CommandContext<class_2168>)ctx).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.serverTeamArg((CommandContext<class_2168>)ctx).settings((class_2168)ctx.getSource(), TeamPropertyArgument.get((CommandContext<class_2168>)ctx, "key"), ""))))))).then(class_2170.method_9247((String)"msg").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.team((CommandContext<class_2168>)ctx).msg(((class_2168)ctx.getSource()).method_9207(), StringArgumentType.getString((CommandContext)ctx, (String)"text")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").then(class_2170.method_9247((String)"server_id").executes(ctx -> this.serverId((class_2168)ctx.getSource())))).then(this.teamArg().executes(ctx -> this.teamArg((CommandContext<class_2168>)ctx).info((class_2168)ctx.getSource())))).executes(ctx -> this.team((CommandContext<class_2168>)ctx).info((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> this.list((class_2168)ctx.getSource(), null))).then(class_2170.method_9247((String)"parties").executes(ctx -> this.list((class_2168)ctx.getSource(), TeamType.PARTY)))).then(class_2170.method_9247((String)"server_teams").executes(ctx -> this.list((class_2168)ctx.getSource(), TeamType.SERVER)))).then(class_2170.method_9247((String)"players").executes(ctx -> this.list((class_2168)ctx.getSource(), TeamType.PLAYER))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"force-disband").requires(source -> source.method_9259(2))).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<class_2168>)ctx, TeamRank.NONE).forceDisband((class_2168)ctx.getSource())))));
        if (Platform.isDevelopmentEnvironment()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbteams_add_fake_player").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"profile", (ArgumentType)class_2191.method_9329()).executes(ctx -> this.addFakePlayer(class_2191.method_9330((CommandContext)ctx, (String)"profile")))));
        }
    }

    private int serverId(class_2168 source) {
        class_5250 component = class_2561.method_43470((String)("Server ID: " + FTBTeamsAPI.getManager().getId()));
        component.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy"))));
        component.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, FTBTeamsAPI.getManager().getId().toString())));
        source.method_9226((class_2561)component, false);
        return 1;
    }

    private int list(class_2168 source, @Nullable TeamType type) {
        class_5250 list = class_2561.method_43470((String)"");
        boolean first = true;
        for (Team team : FTBTeamsAPI.getManager().getTeams()) {
            if (type != null && team.getType() != type) continue;
            if (first) {
                first = false;
            } else {
                list.method_27693(", ");
            }
            list.method_10852(team.getName());
        }
        source.method_9226((class_2561)class_2561.method_43469((String)"ftbteams.list", (Object[])new Object[]{first ? class_2561.method_43471((String)"ftbteams.info.owner.none") : list}), false);
        return 1;
    }

    private int addFakePlayer(Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            TeamManager.INSTANCE.playerLoggedIn(null, profile.getId(), profile.getName());
        }
        return 1;
    }
}

