/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.epherical.croptopia.config.TreeConfiguration;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class CroptopiaConfig {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected HoconConfigurationLoader loader;
    protected ConfigurationNode rootNode;
    protected final String configName;
    protected final boolean devEnvironment;
    private TypeSerializerCollection.Builder serializers;

    public CroptopiaConfig(boolean devEnvironment, String configName) {
        this.devEnvironment = devEnvironment;
        this.configName = configName;
        this.serializers = TypeSerializerCollection.builder();
    }

    public CroptopiaConfig(boolean devEnvironment) {
        this(devEnvironment, "croptopia.conf");
    }

    public <T, V extends TypeSerializer<T>> void addSerializer(Class<T> clazz, V instance) {
        this.serializers.register(clazz, instance);
    }

    public void addSerializer(TypeSerializerCollection collection) {
        this.serializers.registerAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfig() {
        URL path;
        boolean createdFile;
        File file;
        block29: {
            File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toFile(), "croptopia");
            file = new File(configDirectory, this.configName);
            createdFile = false;
            path = null;
            if (this.devEnvironment) {
                path = this.getClass().getClassLoader().getResource(this.configName);
            } else {
                try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.configName);){
                    byte[] bytes = new byte[stream.available()];
                    stream.read(bytes);
                    LOGGER.debug("Creating default config file: " + this.configName);
                    createdFile = this.createdFile(file);
                    if (!createdFile) break block29;
                    try (FileOutputStream outputStream = new FileOutputStream(file);){
                        outputStream.write(bytes);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not find an internal config file for {}", (Object)this.configName);
                }
                finally {
                    try {
                        createdFile = this.createdFile(file);
                        path = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().sink(() -> new BufferedWriter(new FileWriter(file)))).defaultOptions(options -> options.serializers(builder -> builder.registerAll(this.serializers.build())))).url(path)).build();
        try {
            if (createdFile) {
                this.loader.save(this.generateConfig(CommentedConfigurationNode.root()));
            }
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
        }
        try {
            this.rootNode = this.loader.load();
            this.parseConfig(this.rootNode);
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected ConfigurationNode generateConfig(CommentedConfigurationNode node) {
        try {
            ((CommentedConfigurationNode)node.node(new Object[]{"generateSaltInWorld"})).set((Object)true);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        return node;
    }

    protected void parseConfig(ConfigurationNode node) {
        File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toFile(), "croptopia");
        if (configDirectory.exists()) {
            this.addTreeConfigIfDoesNotExist(node, "treeConfig");
        }
    }

    private boolean canCreateFile(File file) {
        return file.exists();
    }

    private boolean createdFile(File file) {
        try {
            if (!file.getParentFile().exists() && file.getParentFile().mkdirs()) {
                LOGGER.debug("Created directory for: " + file.getParentFile().getCanonicalPath());
            }
            if (!file.exists() && file.createNewFile()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error creating new config file ", (Throwable)e);
            return false;
        }
        return false;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode;
    }

    public boolean generateSaltInWorld() {
        return this.getRootNode().node(new Object[]{"generateSaltInWorld"}).getBoolean();
    }

    private boolean addTreeConfigIfDoesNotExist(ConfigurationNode node, String nodeToAdd) {
        if (!node.hasChild(new Object[]{nodeToAdd})) {
            List<class_5321<class_1959>> forestBiomes = Arrays.asList(class_1972.field_9409, class_1972.field_35120, class_1972.field_9414);
            List<class_5321<class_1959>> jungleBiomes = Arrays.asList(class_1972.field_9417, class_1972.field_35118);
            List<class_5321<class_1959>> plainsKeys = Arrays.asList(class_1972.field_9451, class_1972.field_9455);
            List<class_5321<class_1959>> darkForestKeys = Arrays.asList(class_1972.field_9475);
            HashMultimap biomes = HashMultimap.create();
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, forestBiomes, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, jungleBiomes, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, plainsKeys, "apple_tree_configured", "orange_tree_configured", "peach_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, darkForestKeys, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            class_5321 woodlands = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("woodlands"));
            class_5321 wooded_plateau = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("wooded_plateau"));
            class_5321 wooded_island = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("wooded_island"));
            class_5321 autumnal_woods = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("autumnal_woods"));
            class_5321 autumnal_wooded_hills = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("autumnal_wooded_hills"));
            class_5321 lush_swamp = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("lush_swamp"));
            class_5321 mini_jungle = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("mini_jungle"));
            List<class_5321<class_1959>> wooded = Arrays.asList(wooded_island, wooded_plateau, woodlands);
            List<class_5321<class_1959>> autumnal = Arrays.asList(autumnal_woods, autumnal_wooded_hills);
            List<class_5321<class_1959>> jungle = Arrays.asList(mini_jungle);
            List<class_5321<class_1959>> lush = Arrays.asList(lush_swamp);
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, wooded, "apple_tree_configured", "cherry_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, autumnal, "pear_tree_configured", "persimmon_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, jungle, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, lush, "cinnamon_tree_configured");
            class_5321 aspenForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("aspen_forest"));
            class_5321 autumnalValley = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("autumnal_valley"));
            class_5321 bayou = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("bayou"));
            class_5321 blackForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("black_forest"));
            class_5321 canadianShield = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("canadian_shield"));
            class_5321 cherryBlossomForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("cherry_blossom_forest"));
            class_5321 cikaWoods = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("cika_woods"));
            class_5321 coniferousForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("coniferous_forest"));
            class_5321 cragGardens = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("crag_gardens"));
            class_5321 cypressSwamplands = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("cypress_swamplands"));
            class_5321 deadSea = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("dead_sea"));
            class_5321 daciteRidges = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("dacite_ridges"));
            class_5321 windsweptDunes = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("windswept_dunes"));
            class_5321 ebonyWoods = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("ebony_woods"));
            class_5321 forgottenForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("forgotten_forest"));
            class_5321 grove = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("temperate_grove"));
            class_5321 guianaShield = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("guiana_shield"));
            class_5321 jacarandaForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("jacaranda_forest"));
            class_5321 mapleTaiga = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("maple_taiga"));
            class_5321 coconinoMeadow = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("coconino_meadow"));
            class_5321 mojaveDesert = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("mojave_desert"));
            class_5321 lushTundra = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("lush_tundra"));
            class_5321 orchard = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("orchard"));
            class_5321 prairie = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("prairie"));
            class_5321 redOakForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("red_oak_forest"));
            class_5321 redRockValley = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("red_rock_valley"));
            class_5321 roseFields = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("rose_fields"));
            class_5321 autumnalForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("autumnal_forest"));
            class_5321 autumnalTaiga = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("autumnal_taiga"));
            class_5321 shatteredGlacier = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("shattered_glacier"));
            class_5321 firecrackerShrubland = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("firecracker_shrubland"));
            class_5321 sierraBadlands = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("sierra_badlands"));
            class_5321 skyrisVale = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("skyris_vale"));
            class_5321 redwoodThicket = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("redwood_thicket"));
            class_5321 frostedTaiga = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("frosted_taiga"));
            class_5321 frostedConiferousForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("frosted_coniferous_forest"));
            class_5321 fragmentForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("fragment_forest"));
            class_5321 tropicalIsland = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("tropical_islands"));
            class_5321 tropicalRainforest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("tropical_rainforest"));
            class_5321 twilightMeadow = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("twilight_meadow"));
            class_5321 weepingWitchForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("weeping_witch_forest"));
            class_5321 whiteMangroveMarshes = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("white_mangrove_marshes"));
            class_5321 temperateRainforest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("temperate_rainforest"));
            class_5321 zelkovaForest = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.bygID("zelkova_forest"));
            List<class_5321<class_1959>> bygWoods = Arrays.asList(aspenForest, orchard, redOakForest);
            List<class_5321<class_1959>> cherry = Arrays.asList(cherryBlossomForest);
            List<class_5321<class_1959>> nutty = Arrays.asList(weepingWitchForest, daciteRidges, ebonyWoods, mapleTaiga, twilightMeadow);
            List<class_5321<class_1959>> jungleByg = Arrays.asList(cragGardens, tropicalIsland, tropicalRainforest);
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, Collections.singleton(prairie), "apple_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, Arrays.asList(jacarandaForest, autumnalForest, autumnalTaiga), "pear_tree_configured", "persimmon_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, Arrays.asList(cypressSwamplands, whiteMangroveMarshes, temperateRainforest), "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, jungleByg, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, nutty, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, cherry, "cherry_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, bygWoods, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
            for (Map.Entry entry : biomes.asMap().entrySet()) {
                allTreeConfigs.add(new TreeConfiguration((String)entry.getKey(), (Collection)entry.getValue()));
            }
            ConfigurationNode node1 = node.node(new Object[]{nodeToAdd});
            try {
                node1.setList(TreeConfiguration.class, allTreeConfigs);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            try {
                this.loader.save(node);
            }
            catch (ConfigurateException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private static class_2960 travID(String name) {
        return new class_2960("traverse", name);
    }

    private static class_2960 bygID(String name) {
        return new class_2960("byg", name);
    }
}

