/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import java.util.Arrays;
import net.bettercombat.BetterCombat;
import net.bettercombat.config.ServerConfig;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_270;
import net.minecraft.class_6025;

public class TargetHelper {
    public static Relation getRelation(class_1657 attacker, class_1297 target) {
        class_6025 tameable;
        class_1297 owner;
        if (attacker == target) {
            return Relation.FRIENDLY;
        }
        if (target instanceof class_6025 && (owner = (tameable = (class_6025)target).method_35057()) != null) {
            return TargetHelper.getRelation(attacker, owner);
        }
        if (target instanceof class_1530) {
            return Relation.NEUTRAL;
        }
        ServerConfig config = BetterCombat.config;
        class_270 casterTeam = attacker.method_5781();
        class_270 targetTeam = target.method_5781();
        if (casterTeam == null || targetTeam == null) {
            if (target instanceof class_1657) {
                return Relation.coalesce(config.player_relation_to_teamless_players, Relation.NEUTRAL);
            }
            if (target instanceof class_1646) {
                return Relation.coalesce(config.player_relation_to_villagers, Relation.NEUTRAL);
            }
            if (target instanceof class_1296) {
                return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
            }
            if (target instanceof class_1588) {
                return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
            }
            return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
        }
        return attacker.method_5722(target) ? Relation.FRIENDLY : Relation.HOSTILE;
    }

    public static boolean isAttackableMount(class_1297 entity) {
        if (entity instanceof class_1588 || TargetHelper.isEntityHostileVehicle(entity.method_5820())) {
            return true;
        }
        return BetterCombat.config.allow_attacking_mount;
    }

    public static boolean isEntityHostileVehicle(String entityName) {
        ServerConfig config = BetterCombat.config;
        return config.hostile_player_vehicles != null && config.hostile_player_vehicles.length > 0 && Arrays.asList(config.hostile_player_vehicles).contains(entityName);
    }

    public static enum Relation {
        FRIENDLY,
        NEUTRAL,
        HOSTILE;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }
}

