/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.client;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import nx.pingwheel.client.Core;
import nx.pingwheel.client.PingWheelConfigHandler;
import nx.pingwheel.client.PingWheelSettingsScreen;
import nx.pingwheel.shared.Constants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class PingWheelClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"nx-ping-wheel");
    private static class_304 kbPing;
    private static class_304 kbSettings;

    public void onInitializeClient() {
        LOGGER.info("[Ping-Wheel] Client Init");
        PingWheelConfigHandler.getInstance().load();
        this.SetupKeyBindings();
        this.SetupClientCommands();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Constants.S2C_PING_LOCATION, Core::onReceivePing);
    }

    private void SetupKeyBindings() {
        kbPing = KeyBindingHelper.registerKeyBinding((class_304)new class_304("ping-wheel.key.mark-location", class_3675.class_307.field_1672, 4, "ping-wheel.name"));
        kbSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("ping-wheel.key.open-settings", class_3675.class_307.field_1668, -1, "ping-wheel.name"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (kbPing.method_1436()) {
                Core.markLocation();
            }
            if (kbSettings.method_1436()) {
                class_310.method_1551().method_1507((class_437)new PingWheelSettingsScreen());
            }
        });
    }

    private void SetupClientCommands() {
        Function<String, String> formatChannel = channel -> "".equals(channel) ? "\u00a7eGlobal \u00a77(default)" : String.format("\"\u00a76%s\u00a7r\"", channel);
        LiteralArgumentBuilder cmdChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"channel").executes(context -> {
            String currentChannel = PingWheelConfigHandler.getInstance().getConfig().getChannel();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)String.format("Current Ping-Wheel channel: %s", formatChannel.apply(currentChannel))));
            return 1;
        })).then(ClientCommandManager.argument((String)"channel_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String newChannel = (String)context.getArgument("channel_name", String.class);
            PingWheelConfigHandler.getInstance().getConfig().setChannel(newChannel);
            PingWheelConfigHandler.getInstance().save();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)String.format("Set Ping-Wheel channel to: %s", formatChannel.apply(newChannel))));
            return 1;
        }));
        LiteralArgumentBuilder cmdConfig = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").executes(context -> {
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_18858(() -> client.method_1507((class_437)new PingWheelSettingsScreen()));
            return 1;
        });
        Command helpCallback = context -> {
            String output = "\u00a7f/pingwheel config\n\u00a77(manage pingwheel configuration)\n\u00a7f/pingwheel channel\n\u00a77(get your current channel)\n\u00a7f/pingwheel channel <channel_name>\n\u00a77(set your current channel, use \"\" for global channel)";
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)output));
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"help").executes(helpCallback);
        LiteralArgumentBuilder cmdBase = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pingwheel").executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdConfig)).then((ArgumentBuilder)cmdChannel);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(cmdBase));
    }
}

