/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;

public class OptionList
extends class_4265<Entry> {
    private final int maxNameWidth;
    private static final class_2561 OPTION_ON = class_2561.method_43471((String)"modernfix.option.on").method_27694(style -> style.method_10977(class_124.field_1060));
    private static final class_2561 OPTION_OFF = class_2561.method_43471((String)"modernfix.option.off").method_27694(style -> style.method_10977(class_124.field_1061));
    private ModernFixConfigScreen mainScreen;

    public OptionList(ModernFixConfigScreen arg, class_310 arg2) {
        super(arg2, arg.field_22789 + 45, arg.field_22790, 43, arg.field_22790 - 32, 20);
        this.mainScreen = arg;
        int maxW = 0;
        Map<String, Option> optionMap = ModernFixMixinPlugin.instance.config.getOptionMap();
        List sortedKeys = optionMap.keySet().stream().filter(key -> !key.equals("mixin.core")).sorted().collect(Collectors.toList());
        for (String key2 : sortedKeys) {
            Option option = optionMap.get(key2);
            int w = this.field_22740.field_1772.method_1727(key2);
            maxW = Math.max(w, maxW);
            this.method_25321((class_350.class_351)new OptionEntry(key2, option));
        }
        this.maxNameWidth = maxW;
    }

    protected int method_25329() {
        return super.method_25329() + 15 + 20;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    class OptionEntry
    extends Entry {
        private final String name;
        private final class_4185 toggleButton;
        private final Option option;

        public OptionEntry(String optionName, Option option) {
            this.name = optionName;
            this.option = option;
            this.toggleButton = new class_4185(0, 0, 95, 20, (class_2561)class_2561.method_43470((String)""), arg -> {
                this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                try {
                    ModernFixMixinPlugin.instance.config.save();
                    if (!OptionList.this.mainScreen.madeChanges) {
                        OptionList.this.mainScreen.madeChanges = true;
                    }
                }
                catch (IOException e) {
                    this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                    ModernFix.LOGGER.error("Unable to save config", (Throwable)e);
                }
            });
        }

        public void method_25343(class_4587 matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            class_5250 nameComponent = class_2561.method_43470((String)this.name);
            if (this.option.isUserDefined()) {
                nameComponent = nameComponent.method_27692(class_124.field_1056).method_10852((class_2561)class_2561.method_43471((String)"modernfix.config.not_default"));
            }
            ((OptionList)OptionList.this).field_22740.field_1772.method_30883(matrixStack, (class_2561)nameComponent, (float)(left + 160 - OptionList.this.maxNameWidth), (float)(top + height / 2 - 4), 0xFFFFFF);
            this.toggleButton.field_22760 = left + 175;
            this.toggleButton.field_22761 = top;
            this.toggleButton.method_25355(this.getOptionMessage(this.option));
            this.toggleButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        }

        private class_2561 getOptionMessage(Option option) {
            return option.isEnabled() ? OPTION_ON : OPTION_OFF;
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.toggleButton);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.toggleButton.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.toggleButton.method_25406(mouseX, mouseY, button);
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

