/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.fabric.mixin.perf.dynamic_resources;

import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.impl.client.model.ModelLoadingRegistryImpl;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1066;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_3695;
import net.minecraft.class_4590;
import net.minecraft.class_4724;
import net.minecraft.class_4730;
import net.minecraft.class_790;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_807;
import net.minecraft.class_816;
import org.apache.commons.lang3.tuple.Triple;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.embeddedt.modernfix.util.LayeredForwardingMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1088.class}, priority=600)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<class_2960, class_1100> field_5376;
    @Shadow
    @Final
    public static class_1091 field_5374;
    @Shadow
    @Final
    protected class_3300 field_5379;
    @Shadow
    private class_4724 field_21774;
    @Shadow
    @Final
    private Set<class_2960> field_5390;
    @Shadow
    @Final
    private static Logger field_5380;
    @Shadow
    @Final
    @Mutable
    private Map<class_2960, class_1087> field_5387;
    @Shadow
    @Final
    @Mutable
    private Map<Triple<class_2960, class_4590, Boolean>, class_1087> field_5398;
    @Shadow
    @Final
    public static class_793 field_5400;
    @Shadow
    @Final
    private static class_801 field_5384;
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5394;
    @Shadow
    @Final
    private static String field_21773;
    @Shadow
    @Final
    private class_790.class_791 field_5399;
    @Shadow
    @Final
    private static Map<class_2960, class_2689<class_2248, class_2680>> field_5383;
    private Cache<Triple<class_2960, class_4590, Boolean>, class_1087> loadedBakedModels;
    private Cache<class_2960, class_1100> loadedModels;
    private HashMap<class_2960, class_1100> smallLoadingCache = new HashMap();
    private boolean inTextureGatheringPass;
    private Set<class_2960> injectedModels;
    private class_1100 missingModel;
    private Set<class_2960> blockStateFiles = new ObjectOpenHashSet();
    private Set<class_2960> modelFiles = new ObjectOpenHashSet();
    private boolean forceLoadModel = false;
    private class_1087 bakedMissingModel = null;
    private Set<class_2960> bakeStack = new LinkedHashSet<class_2960>();

    @Shadow
    protected abstract void method_4715(class_2960 var1) throws Exception;

    @Shadow
    public abstract class_1100 method_4726(class_2960 var1);

    @Shadow
    @Nullable
    public abstract class_1087 method_15878(class_2960 var1, class_3665 var2);

    @Shadow
    protected abstract void method_4729(class_2960 var1, class_1100 var2);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", ordinal=0))
    private void replaceTopLevelBakedModels(class_3695 filler, String s) {
        this.inTextureGatheringPass = true;
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        final Map<class_2960, class_1100> oldMap = this.field_5376;
        this.field_5376 = new ForwardingMap<class_2960, class_1100>(){

            protected Map<class_2960, class_1100> delegate() {
                return oldMap;
            }

            public class_1100 put(class_2960 key, class_1100 value) {
                ModelBakeryMixin.this.smallLoadingCache.put(key, value);
                return (class_1100)super.put((Object)key, (Object)value);
            }
        };
        filler.method_15396(s);
        this.injectedModels = new ObjectOpenHashSet();
        ModelLoadingRegistryImpl.LoaderInstance instance = ModelLoadingRegistryImpl.begin((class_1088)((class_1088)this), (class_3300)this.field_5379);
        instance.onModelPopulation(this.injectedModels::add);
        instance.finish();
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        class_2960 rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof class_2960) {
            rl = (class_2960)k;
        } else {
            rl = (class_2960)((Triple)k).getLeft();
            baked = true;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0), index=1)
    private Object captureMissingModel(Object model) {
        this.missingModel = (class_1100)model;
        return this.missingModel;
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void ignoreNonFabricModel(class_2960 modelLocation, CallbackInfo ci) throws Exception {
        if (this.inTextureGatheringPass && this.blockStateFiles != null && !this.forceLoadModel && !this.injectedModels.contains(modelLocation)) {
            class_2689 statecontainer;
            class_2960 blockStateLocation = null;
            if (modelLocation instanceof class_1091) {
                class_1091 location = (class_1091)modelLocation;
                if (Objects.equals(location.method_4740(), "inventory")) {
                    this.modelFiles.add(new class_2960(location.method_12836(), "item/" + location.method_12832()));
                } else {
                    blockStateLocation = new class_2960(location.method_12836(), location.method_12832());
                    this.blockStateFiles.add(blockStateLocation);
                }
            } else {
                this.modelFiles.add(modelLocation);
            }
            boolean isWrappedModel = false;
            if (blockStateLocation != null) {
                statecontainer = field_5383.get(blockStateLocation);
                if (statecontainer == null) {
                    statecontainer = ((class_2248)class_2378.field_11146.method_10223(blockStateLocation)).method_9595();
                }
            } else {
                statecontainer = class_2246.field_10124.method_9595();
            }
            this.field_5399.method_3426(statecontainer);
            this.forceLoadModel = true;
            this.method_4729(modelLocation, this.missingModel);
            this.forceLoadModel = false;
            if (this.smallLoadingCache.get(modelLocation) != this.missingModel) {
                isWrappedModel = true;
            }
            this.smallLoadingCache.clear();
            this.field_5376.remove(modelLocation);
            if (isWrappedModel) {
                ModernFix.LOGGER.warn("Model {} appears to be replaced by another mod and will load at startup", (Object)modelLocation);
                this.forceLoadModel = true;
                this.method_4715(modelLocation);
                this.forceLoadModel = false;
            }
            ci.cancel();
        }
    }

    private boolean trustedResourcePack(class_3262 pack) {
        return pack instanceof class_3268 || pack instanceof class_1066 || pack instanceof class_3259 || pack instanceof class_3258;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;collect(Ljava/util/stream/Collector;)Ljava/lang/Object;", ordinal=0))
    private Object collectExtraTextures(Stream<class_4730> instance, Collector<?, ?, ?> arCollector) {
        String[] extraFolders;
        ObjectOpenHashSet materialsSet = new ObjectOpenHashSet((Collection)instance.collect(Collectors.toSet()));
        ModelBakeryHelpers.gatherModelMaterials(this.field_5379, this::trustedResourcePack, (Set<class_4730>)materialsSet, this.blockStateFiles, this.modelFiles, this.missingModel, json -> (class_793)class_793.field_4254.fromJson(json, class_793.class), this::method_4726);
        for (String folder : extraFolders = new String[]{"attachment", "bettergrass", "block", "blocks", "cape", "entity/bed", "entity/chest", "item", "items", "model", "models", "part", "pipe", "ropebridge", "solid_block", "spell_effect", "spell_projectile"}) {
            Set textureLocations = this.field_5379.method_14488("textures/" + folder, p -> p.method_12832().endsWith(".png")).keySet();
            for (class_2960 rl : textureLocations) {
                if (rl.method_12836().equals("assets")) {
                    int slashIndex = rl.method_12832().indexOf(47);
                    String actualNamespace = rl.method_12832().substring(0, slashIndex);
                    String actualPath = rl.method_12832().substring(slashIndex + 1);
                    rl = new class_2960(actualNamespace, actualPath);
                }
                class_2960 texLoc = new class_2960(rl.method_12836(), rl.method_12832().substring(9, rl.method_12832().length() - 4));
                materialsSet.add(new class_4730(class_1059.field_5275, texLoc));
            }
        }
        this.blockStateFiles = null;
        this.modelFiles = null;
        return materialsSet;
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=textures"})})
    private void clearDummyModels(CallbackInfo ci) {
        Predicate<Map.Entry> isVanillaModel = entry -> entry.getValue() instanceof class_793 || entry.getValue() instanceof class_807 || entry.getValue() instanceof class_816;
        this.field_5376.entrySet().removeIf(isVanillaModel);
        this.field_5394.entrySet().removeIf(isVanillaModel);
    }

    @Inject(method={"uploadTextures"}, at={@At(value="FIELD", target="Lnet/minecraft/client/resources/model/ModelBakery;topLevelModels:Ljava/util/Map;", ordinal=0)}, cancellable=true)
    private void skipBake(class_1060 resourceManager, class_3695 profiler, CallbackInfoReturnable<class_4724> cir) {
        profiler.method_15407();
        this.inTextureGatheringPass = false;
        this.injectedModels = null;
        this.loadedModels.put((Object)field_5374, (Object)this.missingModel);
        this.field_5398 = this.loadedBakedModels.asMap();
        final ConcurrentMap unbakedCacheBackingMap = this.loadedModels.asMap();
        ForwardingMap<class_2960, class_1100> mutableBackingMap = new ForwardingMap<class_2960, class_1100>(){

            protected Map<class_2960, class_1100> delegate() {
                return unbakedCacheBackingMap;
            }

            public class_1100 put(class_2960 key, class_1100 value) {
                ModelBakeryMixin.this.smallLoadingCache.put(key, value);
                return (class_1100)super.put((Object)key, (Object)value);
            }
        };
        Stopwatch watch = Stopwatch.createStarted();
        new ArrayList<class_2960>(this.field_5394.keySet()).forEach(key -> {
            try {
                this.method_15878((class_2960)key, (class_3665)class_1086.field_5350);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Model {} failed to bake", key, (Object)e);
            }
        });
        watch.stop();
        ModernFix.LOGGER.info("Early model bake took {}", (Object)watch);
        ModernFix.LOGGER.info("{} unbaked models, {} baked models loaded permanently", (Object)this.field_5376.size(), (Object)this.field_5398.size());
        this.field_5376 = new LayeredForwardingMap<class_2960, class_1100>(new Map[]{this.field_5376, mutableBackingMap});
        this.field_5387 = new DynamicBakedModelProvider((class_1088)this, this.field_5398);
        if (this.bakedMissingModel != null) {
            ((DynamicBakedModelProvider)this.field_5387).setMissingModel(this.bakedMissingModel);
        }
        this.field_5387.put((class_2960)field_5374, this.method_15878((class_2960)field_5374, (class_3665)class_1086.field_5350));
        this.loadedModels.invalidateAll();
        this.loadedModels.put((Object)field_5374, (Object)this.missingModel);
        this.field_5394.clear();
        this.field_5394.put((class_2960)field_5374, this.missingModel);
        this.smallLoadingCache.clear();
        cir.setReturnValue((Object)this.field_21774);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == field_5374 && map == this.field_5376) {
            return this.missingModel;
        }
        return this.field_5376.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1100 fireUnbakedEvent(class_1100 model, class_2960 location) {
        if (this.inTextureGatheringPass) {
            return model;
        }
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (class_1088)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(class_2960 modelLocation, CallbackInfoReturnable<class_1100> cir) {
        if (modelLocation.equals((Object)field_5374)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        class_1100 existing = this.field_5376.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.field_5390.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + modelLocation);
                }
                this.field_5390.add(modelLocation);
                class_1100 iunbakedmodel = this.missingModel;
                while (!this.field_5390.isEmpty()) {
                    class_2960 resourcelocation = this.field_5390.iterator().next();
                    try {
                        existing = this.field_5376.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                field_5380.info("Loading {}", (Object)resourcelocation);
                            }
                            this.method_4715(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (class_1088.class_1089 var9) {
                        field_5380.warn(var9.getMessage());
                        this.field_5376.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        field_5380.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, modelLocation, var10});
                        this.field_5376.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        this.field_5390.remove(resourcelocation);
                    }
                }
                class_1100 result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                this.smallLoadingCache.clear();
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<class_2680> loadOnlyRelevantBlockState(class_2689<class_2248, class_2680> stateDefinition, class_2960 location) {
        if (this.inTextureGatheringPass) {
            return stateDefinition.method_11662();
        }
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (class_1091)location);
    }

    @Override
    public ImmutableList<class_2680> getBlockStatesForMRL(class_2689<class_2248, class_2680> stateDefinition, class_1091 location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (class_2960)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"bake"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadBakedModelDynamic(class_2960 arg, class_3665 arg2, CallbackInfoReturnable<class_1087> cir) {
        Function<class_4730, class_1058> textureGetter = mat -> this.field_21774.method_24097(mat);
        Triple triple = Triple.of((Object)arg, (Object)arg2.method_3509(), (Object)arg2.method_3512());
        class_1087 existing = this.field_5398.get(triple);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            if (this.field_21774 == null) {
                throw new IllegalStateException("bake called too early");
            }
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                class_793 blockmodel;
                if (debugDynamicModelLoading) {
                    field_5380.info("Baking {}", (Object)arg);
                }
                class_1100 iunbakedmodel = this.method_4726(arg);
                Collection theMaterials = iunbakedmodel.method_4754(this::method_4726, new HashSet());
                class_1058 missingSprite = this.field_21774.method_24098(class_1059.field_5275).method_4608(class_1047.method_4539());
                for (class_4730 m : theMaterials) {
                    class_1058 sprite;
                    if (!m.method_24144().equals((Object)class_1059.field_5275) || (sprite = this.field_21774.method_24098(class_1059.field_5275).method_4608(m.method_24147())) != missingSprite || m.method_24147().equals((Object)class_1047.method_4539())) continue;
                    ModernFix.LOGGER.warn("Texture {} is not present in blocks atlas", (Object)m.method_24147());
                }
                if (iunbakedmodel == this.missingModel && debugDynamicModelLoading) {
                    field_5380.warn("Model {} not present", (Object)arg);
                }
                if (iunbakedmodel != this.missingModel) {
                    for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                        try {
                            iunbakedmodel = integration.onUnbakedModelPreBake(arg, iunbakedmodel, (class_1088)this);
                        }
                        catch (RuntimeException e) {
                            ModernFix.LOGGER.error("Exception firing model pre-bake event for {}", (Object)arg, (Object)e);
                        }
                    }
                }
                class_1087 ibakedmodel = null;
                if (iunbakedmodel instanceof class_793 && (blockmodel = (class_793)iunbakedmodel).method_3431() == field_5400) {
                    ibakedmodel = field_5384.method_3479(textureGetter, blockmodel).method_3446((class_1088)this, blockmodel, arg_0 -> ((class_4724)this.field_21774).method_24097(arg_0), arg2, arg, false);
                }
                if (ibakedmodel == null) {
                    if (iunbakedmodel == this.missingModel) {
                        if (this.bakedMissingModel == null) {
                            this.bakedMissingModel = iunbakedmodel.method_4753((class_1088)this, textureGetter, arg2, arg);
                        }
                        if (this.field_5387 instanceof DynamicBakedModelProvider) {
                            ((DynamicBakedModelProvider)this.field_5387).setMissingModel(this.bakedMissingModel);
                        }
                        ibakedmodel = this.bakedMissingModel;
                    } else {
                        ibakedmodel = iunbakedmodel.method_4753((class_1088)this, textureGetter, arg2, arg);
                    }
                }
                if (ibakedmodel == null) {
                    ModernFix.LOGGER.error("Model {} returned null baked model", (Object)arg);
                    ibakedmodel = this.bakedMissingModel;
                }
                for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                    try {
                        ibakedmodel = integration.onBakedModelLoad(arg, iunbakedmodel, ibakedmodel, arg2, (class_1088)this);
                    }
                    catch (RuntimeException e) {
                        ModernFix.LOGGER.error("Exception encountered firing bake event for {}", (Object)arg, (Object)e);
                    }
                }
                this.field_5398.put((Triple<class_2960, class_4590, Boolean>)triple, ibakedmodel);
                cir.setReturnValue((Object)ibakedmodel);
            }
        }
    }
}

