/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.entity;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.packet.EntityIDSyncPacket;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;

public class EntityDataIDSyncHandler {
    private static Map<Class<? extends class_1297>, List<Pair<String, Integer>>> fieldsToSyncMap;

    public static void onDatapackSyncEvent(class_3222 targetPlayer) {
        if (targetPlayer != null) {
            if (fieldsToSyncMap == null) {
                fieldsToSyncMap = new HashMap<Class<? extends class_1297>, List<Pair<String, Integer>>>();
                Object2IntMap entityPoolMap = class_2945.field_13332;
                ArrayList<Field> fieldsToSync = new ArrayList<Field>();
                for (Class eClass : entityPoolMap.keySet()) {
                    fieldsToSync.clear();
                    try {
                        Field[] classFields = eClass.getDeclaredFields();
                        for (Field field : classFields) {
                            if (!Modifier.isStatic(field.getModifiers())) continue;
                            field.setAccessible(true);
                            Object o = field.get(null);
                            if (o == null || !class_2940.class.isAssignableFrom(o.getClass())) continue;
                            fieldsToSync.add(field);
                        }
                        for (Field field : fieldsToSync) {
                            int id = ((class_2940)field.get(null)).field_13306;
                            fieldsToSyncMap.computeIfAbsent(eClass, k -> new ArrayList()).add(Pair.of((Object)field.getName(), (Object)id));
                        }
                    }
                    catch (Throwable e) {
                        ModernFix.LOGGER.error("Skipping entity ID sync for {}: {}", (Object)eClass.getName(), (Object)e);
                    }
                }
            }
            EntityIDSyncPacket packet = new EntityIDSyncPacket(fieldsToSyncMap);
            ModernFix.LOGGER.debug("Sending ID correction packet to client with " + fieldsToSyncMap.size() + " classes");
            ModernFixPlatformHooks.sendPacket(targetPlayer, packet);
        }
    }
}

