/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3294;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.UVController;

public class ModelBakeryHelpers {
    public static final int MAX_BAKED_MODEL_COUNT = 10000;
    public static final int MAX_UNBAKED_MODEL_COUNT = 10000;
    public static final int MAX_MODEL_LIFETIME_SECS = 300;
    private static final int ERROR_THRESHOLD = 200;
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    private static void gatherAdditionalViaManualScan(List<class_3262> untrustedPacks, Set<class_2960> knownLocations, Collection<class_2960> uncertainLocations, String filePrefix) {
        if (untrustedPacks.size() > 0) {
            class_3294 frm = new class_3294(class_3264.field_14188, "dummy");
            for (int i = untrustedPacks.size() - 1; i >= 0; --i) {
                frm.method_24233(untrustedPacks.get(i));
            }
            for (class_2960 blockstate : uncertainLocations) {
                class_2960 fileLocation;
                Optional resource;
                if (knownLocations.contains(blockstate) || !(resource = frm.method_14486(fileLocation = new class_2960(blockstate.method_12836(), filePrefix + blockstate.method_12832() + ".json"))).isPresent()) continue;
                knownLocations.add(blockstate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logOrSuppressError(Object2IntOpenHashMap<String> suppressionMap, String type, class_2960 location, Throwable e) {
        int numErrors;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = suppressionMap;
        synchronized (object2IntOpenHashMap) {
            numErrors = suppressionMap.computeInt((Object)location.method_12836(), (k, oldVal) -> oldVal == null ? 1 : oldVal + 1);
        }
        if (numErrors <= 200) {
            ModernFix.LOGGER.error("Error reading {} {}: {}", (Object)type, (Object)location, (Object)e);
        }
    }

    public static void gatherModelMaterials(class_3300 manager, Predicate<class_3262> isTrustedPack, Set<class_4730> materialSet, Set<class_2960> blockStateFiles, Set<class_2960> modelFiles, class_1100 missingModel, Function<JsonElement, class_793> modelDeserializer, Function<class_2960, class_1100> bakeryModelGetter) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object2IntOpenHashMap blockstateErrors = new Object2IntOpenHashMap();
        ArrayList<class_3262> allPackResources = new ArrayList<class_3262>(manager.method_29213().collect(Collectors.toList()));
        Collections.reverse(allPackResources);
        ObjectOpenHashSet allAvailableModels = new ObjectOpenHashSet();
        ObjectOpenHashSet allAvailableStates = new ObjectOpenHashSet();
        for (class_3262 pack2 : allPackResources) {
            try {
                InputStream stream = pack2.method_14405(class_3264.field_14188, new class_2960("modernfix", "dummy.json"));
                if (stream == null) continue;
                stream.close();
            }
            catch (Exception stream) {}
        }
        allPackResources.removeIf(pack -> {
            if (isTrustedPack.test((class_3262)pack)) {
                for (String namespace : pack.method_14406(class_3264.field_14188)) {
                    Collection allBlockstates = pack.method_14408(class_3264.field_14188, namespace, "blockstates", p -> p.method_12832().endsWith(".json"));
                    for (class_2960 blockstate : allBlockstates) {
                        allAvailableStates.add((Object)new class_2960(blockstate.method_12836(), blockstate.method_12832().replace("blockstates/", "").replace(".json", "")));
                    }
                    Collection allModels = pack.method_14408(class_3264.field_14188, namespace, "models", p -> p.method_12832().endsWith(".json"));
                    for (class_2960 blockstate : allModels) {
                        allAvailableModels.add((Object)new class_2960(blockstate.method_12836(), blockstate.method_12832().replace("models/", "").replace(".json", "")));
                    }
                }
                return true;
            }
            ModernFix.LOGGER.debug("Pack with class {} needs manual scan", (Object)pack.getClass().getName());
            return false;
        });
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<class_2960>)allAvailableStates, blockStateFiles, "blockstates/");
        blockStateFiles.retainAll((Collection<?>)allAvailableStates);
        allAvailableStates.clear();
        allAvailableStates.trim();
        ConcurrentLinkedQueue blockStateLoadedFiles = new ConcurrentLinkedQueue();
        ArrayList<CompletableFuture<Void>> blockStateData = new ArrayList<CompletableFuture<Void>>();
        for (class_2960 blockstate : blockStateFiles) {
            class_2960 fileLocation = new class_2960(blockstate.method_12836(), "blockstates/" + blockstate.method_12832() + ".json");
            List resources = manager.method_14489(fileLocation);
            if (resources.isEmpty()) continue;
            blockStateData.add(CompletableFuture.runAsync(() -> {
                try {
                    for (class_3298 resource : resources) {
                        JsonParser parser = new JsonParser();
                        try {
                            InputStream stream = resource.method_14482();
                            try {
                                blockStateLoadedFiles.add(Pair.of((Object)blockstate, (Object)parser.parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8))));
                            }
                            finally {
                                if (stream == null) continue;
                                stream.close();
                            }
                        }
                        catch (JsonParseException e) {
                            ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                        }
                    }
                }
                catch (IOException e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        blockStateFiles = null;
        CompletableFuture.allOf(blockStateData.toArray(new CompletableFuture[0])).join();
        for (Pair pair : blockStateLoadedFiles) {
            if (pair.getSecond() == null) continue;
            try {
                JsonObject obj = ((JsonElement)pair.getSecond()).getAsJsonObject();
                if (obj.has("variants")) {
                    JsonObject eachVariant = obj.getAsJsonObject("variants");
                    for (Map.Entry entry2 : eachVariant.entrySet()) {
                        List<Object> variantModels;
                        JsonElement variantData = (JsonElement)entry2.getValue();
                        if (variantData.isJsonArray()) {
                            variantModels = new ArrayList();
                            for (JsonElement jsonElement : variantData.getAsJsonArray()) {
                                variantModels.add(jsonElement.getAsJsonObject());
                            }
                        } else {
                            variantModels = Collections.singletonList(variantData.getAsJsonObject());
                        }
                        for (JsonObject jsonObject : variantModels) {
                            modelFiles.add(new class_2960(jsonObject.get("model").getAsString()));
                        }
                    }
                    continue;
                }
                JsonArray multipartData = obj.get("multipart").getAsJsonArray();
                for (JsonElement element : multipartData) {
                    List<Object> applyObjects;
                    JsonObject self = element.getAsJsonObject();
                    JsonElement apply = self.get("apply");
                    if (apply.isJsonArray()) {
                        applyObjects = new ArrayList();
                        for (JsonElement jsonElement : apply.getAsJsonArray()) {
                            applyObjects.add(jsonElement.getAsJsonObject());
                        }
                    } else {
                        applyObjects = Collections.singletonList(apply.getAsJsonObject());
                    }
                    for (JsonObject jsonObject : applyObjects) {
                        modelFiles.add(new class_2960(jsonObject.get("model").getAsString()));
                    }
                }
            }
            catch (RuntimeException e) {
                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", (class_2960)pair.getFirst(), e);
            }
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} blockstate errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        blockStateData = null;
        blockStateLoadedFiles.clear();
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<class_2960>)allAvailableModels, modelFiles, "models/");
        modelFiles.retainAll((Collection<?>)allAvailableModels);
        allAvailableModels.clear();
        allAvailableModels.trim();
        HashMap<Object, class_793> basicModels = new HashMap<Object, class_793>();
        basicModels.put(class_1088.field_5374, (class_793)missingModel);
        basicModels.put(new class_2960("builtin/generated"), class_1088.field_5400);
        basicModels.put(new class_2960("builtin/entity"), class_1088.field_5389);
        LinkedHashSet errorSet = Sets.newLinkedHashSet();
        while (modelFiles.size() > 0) {
            ArrayList<CompletableFuture<Pair>> modelBytes = new ArrayList<CompletableFuture<Pair>>();
            for (class_2960 class_29602 : modelFiles) {
                if (basicModels.containsKey(class_29602)) continue;
                class_2960 fileLocation = new class_2960(class_29602.method_12836(), "models/" + class_29602.method_12832() + ".json");
                modelBytes.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        Optional resource = manager.method_14486(fileLocation);
                        InputStream stream = ((class_3298)resource.orElseThrow()).method_14482();
                        try {
                            JsonParser parser = new JsonParser();
                            pair = Pair.of((Object)model, (Object)parser.parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (JsonParseException | IOException | NoSuchElementException e) {
                                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", fileLocation, e);
                                return Pair.of((Object)fileLocation, null);
                            }
                        }
                        stream.close();
                    }
                    return pair;
                }, ModernFix.resourceReloadExecutor()));
            }
            modelFiles.clear();
            CompletableFuture.allOf(modelBytes.toArray(new CompletableFuture[0])).join();
            UVController.useDummyUv.set(Boolean.TRUE);
            for (CompletableFuture completableFuture : modelBytes) {
                Pair pair = (Pair)completableFuture.join();
                try {
                    if (pair.getSecond() != null) {
                        class_793 model = modelDeserializer.apply((JsonElement)pair.getSecond());
                        model.field_4252 = ((class_2960)pair.getFirst()).toString();
                        modelFiles.addAll(model.method_4755());
                        basicModels.put((class_2960)pair.getFirst(), model);
                        continue;
                    }
                }
                catch (Throwable e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", (class_2960)pair.getFirst(), e);
                }
                basicModels.put((class_2960)pair.getFirst(), (class_793)missingModel);
            }
            UVController.useDummyUv.set(Boolean.FALSE);
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} model errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        modelFiles = null;
        Function<class_2960, class_1100> modelGetter = loc -> {
            class_1100 m = (class_1100)basicModels.get(loc);
            return m != null ? m : (class_1100)bakeryModelGetter.apply((class_2960)loc);
        };
        for (class_793 class_7932 : basicModels.values()) {
            try {
                materialSet.addAll(class_7932.method_4754(modelGetter, (Set)errorSet));
            }
            catch (Throwable e) {
                ModernFix.LOGGER.error("Model {} threw error while getting materials", (Object)class_7932.field_4252, (Object)e);
            }
        }
        stopwatch.stop();
        ModernFix.LOGGER.info("Resolving model textures took " + stopwatch);
    }

    private static <T extends Comparable<T>, V extends T> class_2680 setPropertyGeneric(class_2680 state, class_2769<T> prop, Object o) {
        return (class_2680)state.method_11657(prop, (Comparable)o);
    }

    private static <T extends Comparable<T>> T getValueHelper(class_2769<T> property, String value) {
        return (T)property.method_11900(value).orElse(null);
    }

    public static ImmutableList<class_2680> getBlockStatesForMRL(class_2689<class_2248, class_2680> stateDefinition, class_1091 location) {
        if (Objects.equals(location.method_4740(), "inventory")) {
            return ImmutableList.of();
        }
        HashSet<class_2769> fixedProperties = new HashSet<class_2769>();
        class_2680 fixedState = (class_2680)stateDefinition.method_11664();
        for (String s : COMMA_SPLITTER.split((CharSequence)location.method_4740())) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            class_2769 property = stateDefinition.method_11663(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object value = ModelBakeryHelpers.getValueHelper(property, s2);
                if (value == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.method_11898());
                }
                fixedState = ModelBakeryHelpers.setPropertyGeneric(fixedState, property, value);
                fixedProperties.add(property);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        if (fixedProperties.size() == stateDefinition.method_11659().size()) {
            return ImmutableList.of((Object)fixedState);
        }
        ArrayList anyProperties = new ArrayList(stateDefinition.method_11659());
        anyProperties.removeAll(fixedProperties);
        ArrayList<class_2680> finalList = new ArrayList<class_2680>();
        finalList.add(fixedState);
        for (class_2769 property : anyProperties) {
            ArrayList<class_2680> newPermutations = new ArrayList<class_2680>();
            for (class_2680 state : finalList) {
                for (Comparable value : property.method_11898()) {
                    newPermutations.add(ModelBakeryHelpers.setPropertyGeneric(state, property, value));
                }
            }
            finalList = newPermutations;
        }
        return ImmutableList.copyOf(finalList);
    }
}

