/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dfu;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_155;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.dfu.DFUBlaster;

public class LazyDataFixer
implements DataFixer {
    private static final Logger LOGGER = LogManager.getLogger((String)"ModernFix");
    private DataFixer backingDataFixer;
    private final Supplier<DataFixer> dfuSupplier;
    private static final Schema FAKE_SCHEMA = new EmptySchema();

    public LazyDataFixer(Supplier<DataFixer> dfuSupplier) {
        LOGGER.info("Bypassed Mojang DFU");
        this.backingDataFixer = null;
        this.dfuSupplier = dfuSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dynamic<T> update(DSL.TypeReference type, Dynamic<T> input, int version, int newVersion) {
        if (version >= newVersion) {
            return input;
        }
        LazyDataFixer lazyDataFixer = this;
        synchronized (lazyDataFixer) {
            if (this.backingDataFixer == null) {
                LOGGER.info("Instantiating Mojang DFU");
                DFUBlaster.blastMaps();
                this.backingDataFixer = this.dfuSupplier.get();
            }
        }
        return this.backingDataFixer.update(type, input, version, newVersion);
    }

    public Schema getSchema(int key) {
        return FAKE_SCHEMA;
    }

    static class EmptySchema
    extends Schema {
        private static final Type<?> EMPTY_TYPE = new EmptyPart();
        private static final TypeTemplate FAKE_TEMPLATE = EMPTY_TYPE.template();

        public EmptySchema() {
            super(DataFixUtils.makeKey((int)class_155.method_16673().getWorldVersion()), null);
        }

        protected Map<String, Type<?>> buildTypes() {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            map.defaultReturnValue((Object)new EmptyPart());
            return map;
        }

        public TypeTemplate resolveTemplate(String name) {
            return FAKE_TEMPLATE;
        }

        public Type<?> getChoiceType(DSL.TypeReference type, String choiceName) {
            return EMPTY_TYPE;
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
        }

        public Map<String, Supplier<TypeTemplate>> registerEntities(Schema schema) {
            return Collections.emptyMap();
        }

        public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
            return Collections.emptyMap();
        }
    }
}

