/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.data.LevelLists;
import net.levelz.mixin.misc.ItemRendererAccessor;
import net.levelz.screen.SkillInfoScreen;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_809;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class SkillListScrollableWidget
extends class_7528 {
    private final String title;
    private final boolean mining;
    private final List<Integer> levelList;
    private final List<List<Integer>> objectList;
    private final List<String> skillList;
    private final class_437 screen;
    private final class_327 textRenderer;
    private final class_918 itemRenderer;
    private int totalYSpace = 0;
    private int ySpace = 0;
    private boolean scrollbarDragged;

    public SkillListScrollableWidget(int x, int y, int width, int height, List<Integer> levelList, List<List<Integer>> objectList, List<String> skillList, String title, class_437 screen, class_327 textRenderer, class_918 itemRenderer) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.title = title;
        this.screen = screen;
        this.textRenderer = textRenderer;
        this.itemRenderer = itemRenderer;
        this.levelList = levelList;
        this.objectList = objectList;
        this.skillList = skillList;
        this.mining = this.title.equals("mining");
    }

    public void method_37020(class_6382 narrationMessageBuilder) {
    }

    protected int method_44391() {
        return this.totalYSpace;
    }

    protected boolean method_44392() {
        return this.totalYSpace > 185;
    }

    protected double method_44393() {
        return 27.0;
    }

    protected void method_44389(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.ySpace = this.field_22761;
        for (int u = 0; u < this.levelList.size(); ++u) {
            if (this.objectList.get(u).isEmpty()) continue;
            if (!this.skillList.isEmpty()) {
                this.textRenderer.method_30883(matrices, (class_2561)class_2561.method_43469((String)("item.levelz." + this.skillList.get(u) + ".tooltip"), (Object[])new Object[]{this.levelList.get(u)}), (float)this.field_22760, (float)this.ySpace, 0x3F3F3F);
            } else {
                this.textRenderer.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.levelz.level", (Object[])new Object[]{this.levelList.get(u)}), (float)this.field_22760, (float)this.ySpace, 0x3F3F3F);
            }
            int listSplitter = 0;
            int gridXSpace = this.field_22760;
            this.ySpace += 16;
            for (int k = 0; k < this.objectList.get(u).size(); ++k) {
                class_1799 stack = null;
                ArrayList<Object> tooltip = new ArrayList<Object>();
                if (this.mining) {
                    class_2248 block = (class_2248)class_2378.field_11146.method_10200(this.objectList.get(u).get(k).intValue());
                    stack = new class_1799((class_1935)block);
                    tooltip.add(block.method_9518());
                } else {
                    class_1792 item = (class_1792)class_2378.field_11142.method_10200(this.objectList.get(u).get(k).intValue());
                    tooltip.add(item.method_7848());
                    stack = item.method_7854();
                    if (class_1845.method_8077((class_1799)item.method_7854()) && LevelLists.potionList.contains(item)) {
                        int index = LevelLists.potionList.indexOf(item);
                        class_1842 potion = (class_1842)LevelLists.potionList.get(index + 1);
                        class_1799 potionStack = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)potion);
                        tooltip.add(class_2561.method_30163((String)("Ingredient for " + class_2561.method_43471((String)((class_1812)class_1844.method_8061((class_1799)potionStack, (class_1842)potion).method_7909()).method_7866(potionStack)).getString())));
                    }
                }
                if (stack != null) {
                    this.renderGuiItemModel(matrices, stack, gridXSpace, this.ySpace);
                    if (!tooltip.isEmpty() && this.isPointWithinBounds(gridXSpace - this.field_22760, this.ySpace - this.field_22761 - (int)this.method_44387(), 16, 16, mouseX, mouseY)) {
                        class_7528.method_44380();
                        matrices.method_22903();
                        matrices.method_22904(0.0, this.method_44387(), 0.0);
                        this.screen.method_30901(matrices, tooltip, mouseX, mouseY);
                        matrices.method_22909();
                        class_7528.method_44379((int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759));
                    }
                }
                gridXSpace += 18;
                if (++listSplitter % 9 != 0 && k != this.objectList.get(u).size() - 1) continue;
                this.ySpace += 18;
                gridXSpace = this.field_22760;
            }
            this.ySpace += 8;
        }
        if (this.totalYSpace == 0) {
            this.totalYSpace = this.ySpace - this.field_22761;
        }
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_7528.method_44379((int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759));
        matrices.method_22903();
        matrices.method_22904(0.0, -this.method_44387(), 0.0);
        this.method_44389(matrices, mouseX, mouseY, delta);
        matrices.method_22909();
        class_7528.method_44380();
        this.method_44384(matrices);
    }

    protected void method_44384(class_4587 matrices) {
        if (this.method_44392()) {
            int l = Math.max(this.field_22761 + 1, (int)this.method_44387() * (this.field_22759 - 27) / this.method_44390() + this.field_22761 - 1);
            RenderSystem.setShaderTexture((int)0, (class_2960)SkillInfoScreen.BACKGROUND_TEXTURE);
            this.method_25302(matrices, this.field_22760 + 177, this.field_22761, 200, 0, 8, 185);
            this.method_25302(matrices, this.field_22760 + 178, l, 208, 0, 6, 27);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.field_22764) {
            return false;
        }
        this.method_44382(this.method_44387() - amount * this.method_44393());
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrollbarDragged = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) {
            return false;
        }
        boolean bl = this.method_44388(mouseX, mouseY);
        boolean bl2 = this.method_44392() && mouseX >= (double)(this.field_22760 + this.field_22758 - 5) && mouseX <= (double)(this.field_22760 + this.field_22758 + 1) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        this.method_25365(bl || bl2);
        if (bl2 && button == 0) {
            this.scrollbarDragged = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!(this.field_22764 && this.method_25370() && this.scrollbarDragged)) {
            return false;
        }
        if (mouseY < (double)this.field_22761) {
            this.method_44382(0.0);
        } else if (mouseY > (double)(this.field_22761 + this.field_22759)) {
            this.method_44382(this.method_44390());
        } else {
            int i = this.getScrollbarThumbHeight();
            double d = Math.max(1, this.method_44390() / (this.field_22759 - i));
            this.method_44382(this.method_44387() + deltaY * d);
        }
        return true;
    }

    protected boolean method_44388(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758 + 1) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    private int getContentsHeightWithPadding() {
        return this.method_44391() + 4;
    }

    private int getScrollbarThumbHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.getContentsHeightWithPadding())), (int)32, (int)this.field_22759);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        double d;
        double d2;
        int i = this.field_22760;
        int j = this.field_22761;
        pointX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(pointX < (double)(x + width + 1))) return false;
        pointY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(pointY < (double)(y + height + 1))) return false;
        return true;
    }

    private void renderGuiItemModel(class_4587 matrices, class_1799 stack, int x, int y) {
        boolean bl;
        class_1087 model = this.itemRenderer.method_4019(stack, null, null, 0);
        ((ItemRendererAccessor)this.itemRenderer).getTextureManager().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 100.0);
        matrixStack.method_22904(8.0, 8.0, 0.0);
        matrixStack.method_22905(1.0f, -1.0f, 1.0f);
        matrixStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        boolean bl2 = bl = !model.method_24304();
        if (bl) {
            class_308.method_24210();
        }
        matrices.method_22903();
        matrices.method_22904(0.0, this.method_44387() * 1.0625, 0.0);
        this.itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, matrices, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        matrices.method_22909();
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        if (bl) {
            class_308.method_24211();
        }
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }
}

