/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.levelz.init.KeyInit;
import net.levelz.network.PlayerStatsClientPacket;
import net.levelz.screen.SkillInfoScreen;
import net.levelz.screen.SkillListScreen;
import net.levelz.stats.PlayerStatsManager;
import net.levelz.stats.Skill;
import net.libz.api.Tab;
import net.libz.util.DrawTabHelper;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SkillScreen
extends class_437
implements Tab {
    public static final class_2960 BACKGROUND_TEXTURE = new class_2960("levelz:textures/gui/skill_background.png");
    public static final class_2960 ICON_TEXTURES = new class_2960("levelz:textures/gui/icons.png");
    private final WidgetButtonPage[] skillButtons = new WidgetButtonPage[12];
    private final WidgetButtonPage[] levelButtons = new WidgetButtonPage[12];
    private class_1657 playerEntity;
    private PlayerStatsManager playerStatsManager;
    private int backgroundWidth = 200;
    private int backgroundHeight = 215;
    private int x;
    private int y;

    public SkillScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.levelz.skill_screen"));
    }

    protected void method_25426() {
        super.method_25426();
        this.playerEntity = this.field_22787.field_1724;
        this.playerStatsManager = ((PlayerStatsManagerAccess)this.playerEntity).getPlayerStatsManager();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        for (int i = 0; i < this.skillButtons.length; ++i) {
            int skillInt = i;
            this.skillButtons[i] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + 15 + (i > 5 ? 90 : 0), this.y + 90 + i * 20 - (i > 5 ? 120 : 0), 16, 16, i * 16, 16, false, true, (class_2561)class_2561.method_43471((String)("spritetip.levelz." + Skill.values()[i].name().toLowerCase() + "_skill")), button -> this.field_22787.method_1507((class_437)new SkillInfoScreen(Skill.values()[skillInt].name().toLowerCase()))));
            for (int o = 1; o < 10; ++o) {
                String translatable = "spritetip.levelz." + Skill.values()[i].name().toLowerCase() + "_skill_info_" + o;
                class_5250 tooltip = class_2561.method_43471((String)translatable);
                if (tooltip.getString().equals(translatable)) continue;
                this.skillButtons[i].addTooltip((class_2561)tooltip);
            }
            this.levelButtons[i] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + 83 + (i > 5 ? 90 : 0), this.y + 92 + i * 20 - (i > 5 ? 120 : 0), 13, 13, 33, 42, true, true, null, button -> {
                int level = 1;
                if (((WidgetButtonPage)button).wasRightButtonClicked()) {
                    level = 5;
                } else if (((WidgetButtonPage)button).wasMiddleButtonClicked()) {
                    level = 10;
                }
                PlayerStatsClientPacket.writeC2SIncreaseLevelPacket(this.playerStatsManager, Skill.values()[skillInt], level);
            }));
            this.levelButtons[i].field_22763 = this.playerStatsManager.getSkillPoints() > 0 && this.playerStatsManager.getSkillLevel(Skill.values()[i]) < ConfigInit.CONFIG.maxLevel;
        }
        WidgetButtonPage infoButton = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + 178, this.y + 73, 11, 13, 0, 42, true, false, (class_2561)class_2561.method_43471((String)"text.levelz.more_info"), button -> {}));
        String[] infoTooltip = class_2561.method_43471((String)"text.levelz.gui.level_up_skill.tooltip").getString().split("\n");
        for (int i = 0; i < infoTooltip.length; ++i) {
            infoButton.addTooltip(class_2561.method_30163((String)infoTooltip[i]));
        }
        if (!LevelLists.craftingItemList.isEmpty()) {
            this.method_37063((class_364)new WidgetButtonPage(this.x + 180, this.y + 5, 15, 13, 0, 80, true, true, (class_2561)class_2561.method_43471((String)"text.levelz.crafting_info"), button -> this.field_22787.method_1507((class_437)new SkillListScreen("crafting"))));
        }
        if (!ConfigInit.CONFIG.useIndependentExp) {
            WidgetButtonPage levelUpButton = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + 177, this.y + 49, 13, 13, 33, 42, true, true, (class_2561)class_2561.method_43471((String)"text.levelz.level_up"), button -> {
                int level = 1;
                if (((WidgetButtonPage)button).wasRightButtonClicked()) {
                    level = 5;
                } else if (((WidgetButtonPage)button).wasMiddleButtonClicked()) {
                    level = 10;
                }
                PlayerStatsClientPacket.writeC2SLevelUpPacket(level);
            }));
            String[] levelUpTooltip = class_2561.method_43471((String)"text.levelz.gui.level_up.tooltip").getString().split("\n");
            for (int i = 0; i < levelUpTooltip.length; ++i) {
                levelUpButton.addTooltip(class_2561.method_30163((String)levelUpTooltip[i]));
            }
            levelUpButton.field_22763 = !this.playerStatsManager.isMaxLevel() && this.playerStatsManager.getNonIndependentExperience() / (long)this.playerStatsManager.getNextLevelExperience() >= 1L;
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        class_332.method_25291((class_4587)matrices, (int)i, (int)j, (int)this.method_25305(), (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)256, (int)256);
        if (this.field_22787.field_1724 != null) {
            int o;
            int scaledWidth = this.field_22787.method_22683().method_4486();
            int scaledHeight = this.field_22787.method_22683().method_4502();
            class_490.method_2486((int)(scaledWidth / 2 - 75), (int)(scaledHeight / 2 - 40), (int)30, (float)-28.0f, (float)0.0f, (class_1309)this.field_22787.field_1724);
            class_5250 playerName = class_2561.method_43469((String)"text.levelz.gui.title", (Object[])new Object[]{this.playerEntity.method_5477().getString()});
            this.field_22793.method_30883(matrices, (class_2561)playerName, (float)(this.x - this.field_22793.method_27525((class_5348)playerName) / 2 + 120), (float)(this.y + 7), 0x3F3F3F);
            this.field_22793.method_1729(matrices, String.valueOf(Math.round(this.playerEntity.method_6032())), (float)(this.x + 74), (float)(this.y + 22), 0x3F3F3F);
            this.field_22793.method_1729(matrices, String.valueOf(BigDecimal.valueOf(this.playerEntity.method_26825(class_5134.field_23724)).setScale(2, RoundingMode.HALF_DOWN).floatValue()), (float)(this.x + 74), (float)(this.y + 36), 0x3F3F3F);
            this.field_22793.method_1729(matrices, String.valueOf(BigDecimal.valueOf(this.playerEntity.method_26825(class_5134.field_23719) * 10.0).setScale(2, RoundingMode.HALF_DOWN).floatValue()), (float)(this.x + 124), (float)(this.y + 22), 0x3F3F3F);
            this.field_22793.method_1729(matrices, this.getDamageLabel(), (float)(this.x + 124), (float)(this.y + 36), 0x3F3F3F);
            this.field_22793.method_1729(matrices, String.valueOf(Math.round(this.playerEntity.method_7344().method_7586())), (float)(this.x + 171), (float)(this.y + 22), 0x3F3F3F);
            this.field_22793.method_1729(matrices, String.valueOf(BigDecimal.valueOf(this.playerEntity.method_26825(class_5134.field_23726)).setScale(2, RoundingMode.HALF_DOWN).floatValue()), (float)(this.x + 171), (float)(this.y + 36), 0x3F3F3F);
            class_5250 skillLevelText = class_2561.method_43469((String)"text.levelz.gui.level", (Object[])new Object[]{this.playerStatsManager.getOverallLevel()});
            this.field_22793.method_30883(matrices, (class_2561)skillLevelText, (float)(this.x - this.field_22793.method_27525((class_5348)skillLevelText) / 2 + 91), (float)(this.y + 52), 0x3F3F3F);
            class_5250 skillPointText = class_2561.method_43469((String)"text.levelz.gui.points", (Object[])new Object[]{this.playerStatsManager.getSkillPoints()});
            this.field_22793.method_30883(matrices, (class_2561)skillPointText, (float)(this.x - this.field_22793.method_27525((class_5348)skillPointText) / 2 + 156), (float)(this.y + 52), 0x3F3F3F);
            RenderSystem.setShaderTexture((int)0, (class_2960)ICON_TEXTURES);
            this.method_25302(matrices, this.x + 58, this.y + 64, 0, 100, 131, 5);
            int nextLevelExperience = this.playerStatsManager.getNextLevelExperience();
            float levelProgress = 0.0f;
            long experience = 0L;
            if (!ConfigInit.CONFIG.useIndependentExp) {
                experience = this.playerStatsManager.getNonIndependentExperience();
                levelProgress = Math.min((float)experience / (float)nextLevelExperience, 1.0f);
            } else {
                levelProgress = this.playerStatsManager.getLevelProgress();
                experience = (int)((float)nextLevelExperience * levelProgress);
            }
            this.method_25302(matrices, this.x + 58, this.y + 64, 0, 105, (int)(130.0f * levelProgress), 5);
            class_5250 currentXpText = class_2561.method_43469((String)"text.levelz.gui.current_xp", (Object[])new Object[]{experience, nextLevelExperience});
            this.field_22793.method_30883(matrices, (class_2561)currentXpText, (float)(this.x - this.field_22793.method_27525((class_5348)currentXpText) / 2 + 123), (float)(this.y + 74), 0x3F3F3F);
            for (o = 0; o < this.levelButtons.length; ++o) {
                this.levelButtons[o].field_22763 = this.playerStatsManager.getSkillPoints() > 0 && this.playerStatsManager.getSkillLevel(Skill.values()[o]) < ConfigInit.CONFIG.maxLevel;
            }
            for (o = 0; o < 12; ++o) {
                class_5250 currentLevelText = class_2561.method_43469((String)"text.levelz.gui.current_level", (Object[])new Object[]{this.playerStatsManager.getSkillLevel(Skill.values()[o]), ConfigInit.CONFIG.maxLevel});
                this.field_22793.method_30883(matrices, (class_2561)currentLevelText, (float)(this.x - this.field_22793.method_27525((class_5348)currentLevelText) / 2 + 57 + (o > 5 ? 90 : 0)), (float)(this.y + 95 + o * 20 - (o > 5 ? 120 : 0)), 0x3F3F3F);
            }
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)ICON_TEXTURES);
        this.method_25302(matrices, this.x + 58, this.y + 21, 0, 0, 9, 9);
        this.method_25302(matrices, this.x + 58, this.y + 34, 9, 0, 9, 9);
        this.method_25302(matrices, this.x + 108, this.y + 21, 18, 0, 9, 9);
        this.method_25302(matrices, this.x + 108, this.y + 34, 27, 0, 9, 9);
        this.method_25302(matrices, this.x + 155, this.y + 21, 36, 0, 9, 9);
        this.method_25302(matrices, this.x + 155, this.y + 34, 45, 0, 9, 9);
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_4587)matrices, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (KeyInit.screenKey.method_1417(keyCode, scanCode) || Objects.requireNonNull(this.field_22787).field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (this.method_25399() != null ? 1 : 0) != 0);
        return super.method_25402(mouseX, mouseY, button);
    }

    public int getWidth() {
        return this.backgroundWidth;
    }

    public int getHeight() {
        return this.backgroundHeight;
    }

    private String getDamageLabel() {
        float damage = 0.0f;
        class_1792 item = this.playerEntity.method_6047().method_7909();
        ArrayList<Object> levelList = LevelLists.customItemList;
        if (!levelList.isEmpty() && PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, levelList, class_2378.field_11142.method_10221((Object)item).toString(), false)) {
            if (item instanceof class_1829) {
                class_1829 swordItem = (class_1829)item;
                damage = swordItem.method_8020();
            } else if (item instanceof class_1766) {
                class_1766 miningToolItem = (class_1766)item;
                damage = miningToolItem.method_26366();
            } else if (!item.method_7844(class_1304.field_6173).isEmpty() && item.method_7844(class_1304.field_6173).containsKey((Object)class_5134.field_23721)) {
                Multimap multimap = item.method_7844(class_1304.field_6173);
                for (Map.Entry entry : multimap.entries()) {
                    if (!((class_1320)entry.getKey()).equals(class_5134.field_23721)) continue;
                    damage = (float)((class_1322)entry.getValue()).method_6186();
                    break;
                }
            }
        } else if (item instanceof class_1831) {
            class_1831 toolItem = (class_1831)item;
            levelList = null;
            if (item instanceof class_1829) {
                levelList = LevelLists.swordList;
            } else if (item instanceof class_1743) {
                levelList = ConfigInit.CONFIG.bindAxeDamageToSwordRestriction ? LevelLists.swordList : LevelLists.axeList;
            } else if (item instanceof class_1794) {
                levelList = LevelLists.hoeList;
            } else if (item instanceof class_1810 || item instanceof class_1821) {
                levelList = LevelLists.toolList;
            }
            if (levelList != null && PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, levelList, toolItem.method_8022().toString().toLowerCase(), false)) {
                if (item instanceof class_1829) {
                    class_1829 swordItem = (class_1829)item;
                    damage = swordItem.method_8020();
                } else if (item instanceof class_1766) {
                    class_1766 miningToolItem = (class_1766)item;
                    damage = miningToolItem.method_26366();
                }
            }
        }
        damage = (float)((double)damage + this.playerEntity.method_26825(class_5134.field_23721));
        return String.valueOf(BigDecimal.valueOf(damage).setScale(2, RoundingMode.HALF_DOWN).floatValue());
    }

    public static class WidgetButtonPage
    extends class_4185 {
        private final boolean hoverOutline;
        private final boolean clickable;
        private final int textureX;
        private final int textureY;
        private List<class_2561> tooltip = new ArrayList<class_2561>();
        private int clickedKey = -1;

        public WidgetButtonPage(int x, int y, int sizeX, int sizeY, int textureX, int textureY, boolean hoverOutline, boolean clickable, @Nullable class_2561 tooltip, class_4185.class_4241 onPress) {
            super(x, y, sizeX, sizeY, class_5244.field_39003, onPress);
            this.hoverOutline = hoverOutline;
            this.clickable = clickable;
            this.textureX = textureX;
            this.textureY = textureY;
            this.field_22758 = sizeX;
            this.field_22759 = sizeY;
            if (tooltip != null) {
                this.tooltip.add(tooltip);
            }
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ICON_TEXTURES);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            int i = this.hoverOutline ? this.method_25356(this.method_25367()) : 0;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            this.method_25302(matrices, this.field_22760, this.field_22761, this.textureX + i * this.field_22758, this.textureY, this.field_22758, this.field_22759);
            if (this.method_25367()) {
                this.method_25352(matrices, mouseX, mouseY);
            }
        }

        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
            if (!this.tooltip.isEmpty()) {
                class_310 client = class_310.method_1551();
                client.field_1755.method_30901(matrices, this.tooltip, mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.clickedKey = button;
            if (!this.clickable) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        protected boolean method_25351(int button) {
            return super.method_25351(button) || button == 1 || button == 2;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.clickable) {
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void addTooltip(class_2561 text) {
            this.tooltip.add(text);
        }

        public boolean wasMiddleButtonClicked() {
            return this.clickedKey == 2;
        }

        public boolean wasRightButtonClicked() {
            return this.clickedKey == 1;
        }
    }
}

