/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.levelz.init.KeyInit;
import net.levelz.screen.SkillInfoScreen;
import net.levelz.screen.SkillScreen;
import net.levelz.screen.widget.SkillListScrollableWidget;
import net.libz.api.Tab;
import net.libz.util.DrawTabHelper;
import net.libz.util.SortList;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class SkillListScreen
extends class_437
implements Tab {
    private int backgroundWidth = 200;
    private int backgroundHeight = 215;
    private int x;
    private int y;
    private final String title;
    private final boolean crafing;

    public SkillListScreen(String title) {
        super(class_2561.method_30163((String)title));
        this.title = title;
        this.crafing = this.title.equals("crafting");
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.method_37063((class_364)new SkillScreen.WidgetButtonPage(this.x + 180, this.y + (this.crafing ? 5 : 7), 15 - (this.crafing ? 0 : 3), 13 - (this.crafing ? 0 : 4), this.crafing ? 0 : 57, 80, this.crafing, true, null, button -> {
            if (this.crafing) {
                this.field_22787.method_1507((class_437)new SkillScreen());
            } else {
                this.field_22787.method_1507((class_437)new SkillInfoScreen(this.title));
            }
        }));
        ArrayList<Integer> levelList = new ArrayList();
        ArrayList<List<Integer>> objectList = new ArrayList();
        ArrayList<String> skillList = new ArrayList();
        if (Objects.equals(this.title, "mining")) {
            levelList = LevelLists.miningLevelList;
            objectList = LevelLists.miningBlockList;
        } else if (Objects.equals(this.title, "alchemy")) {
            levelList = LevelLists.brewingLevelList;
            objectList = LevelLists.brewingItemList;
        } else if (Objects.equals(this.title, "smithing")) {
            levelList = LevelLists.smithingLevelList;
            objectList = LevelLists.smithingItemList;
        } else if (this.crafing) {
            levelList = LevelLists.craftingLevelList;
            objectList = LevelLists.craftingItemList;
            skillList = LevelLists.craftingSkillList;
            if (ConfigInit.CONFIG.sortCraftingRecipesBySkill) {
                SortList.concurrentSort(skillList, (List[])new List[]{skillList, levelList, objectList});
            }
        }
        this.method_37063((class_364)new SkillListScrollableWidget(this.x + 10, this.y + 22, 183, 185, levelList, objectList, skillList, this.title, this, this.field_22793, this.field_22788));
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)SkillInfoScreen.BACKGROUND_TEXTURE);
        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        class_332.method_25291((class_4587)matrices, (int)i, (int)j, (int)this.method_25305(), (float)0.0f, (float)0.0f, (int)this.backgroundWidth, (int)this.backgroundHeight, (int)256, (int)256);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.levelz.locked_list", (Object[])new Object[]{class_2561.method_43471((String)String.format("spritetip.levelz.%s_skill", this.title))}), (float)(this.x + 6), (float)(this.y + 7), 0x3F3F3F);
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_4587)matrices, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            if (ConfigInit.CONFIG.switch_screen) {
                this.field_22787.method_1507((class_437)new SkillScreen());
            } else {
                this.method_25419();
            }
            return true;
        }
        if (KeyInit.screenKey.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507((class_437)new SkillScreen());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (boolean)false);
        return super.method_25402(mouseX, mouseY, button);
    }

    public int getWidth() {
        return this.backgroundWidth;
    }

    public int getHeight() {
        return this.backgroundHeight;
    }
}

